/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.TransferHandler;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import sun.awt.AppContext;
import sun.security.action.GetPropertyAction;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class SwingUtilities
implements SwingConstants {
    private static boolean canAccessEventQueue = false;
    private static boolean eventQueueTested = false;
    private static boolean suppressDropSupport;
    private static boolean checkedSuppressDropSupport;
    private static final Object sharedOwnerFrameKey;

    private static boolean getSuppressDropTarget() {
        if (!checkedSuppressDropSupport) {
            suppressDropSupport = Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction("suppressSwingDropSupport")));
            checkedSuppressDropSupport = true;
        }
        return suppressDropSupport;
    }

    static void installSwingDropTargetAsNecessary(Component component, TransferHandler transferHandler) {
        DropTarget dropTarget;
        if (!SwingUtilities.getSuppressDropTarget() && ((dropTarget = component.getDropTarget()) == null || dropTarget instanceof UIResource)) {
            if (transferHandler == null) {
                component.setDropTarget(null);
            } else if (!GraphicsEnvironment.isHeadless()) {
                component.setDropTarget(new TransferHandler.SwingDropTarget(component));
            }
        }
    }

    public static final boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public static Rectangle getLocalBounds(Component component) {
        Rectangle rectangle = new Rectangle(component.getBounds());
        rectangle.y = 0;
        rectangle.x = 0;
        return rectangle;
    }

    public static Window getWindowAncestor(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            return (Window)container;
        }
        return null;
    }

    static Point convertScreenLocationToParent(Container container, int n, int n2) {
        for (Container container2 = container; container2 != null; container2 = container2.getParent()) {
            if (!(container2 instanceof Window)) continue;
            Point point = new Point(n, n2);
            SwingUtilities.convertPointFromScreen(point, container);
            return point;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor");
    }

    public static Point convertPoint(Component component, Point point, Component component2) {
        if (component == null && component2 == null) {
            return point;
        }
        if (component == null && (component = SwingUtilities.getWindowAncestor(component2)) == null) {
            throw new Error("Source component not connected to component tree hierarchy");
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointToScreen(point2, component);
        if (component2 == null && (component2 = SwingUtilities.getWindowAncestor(component)) == null) {
            throw new Error("Destination component not connected to component tree hierarchy");
        }
        SwingUtilities.convertPointFromScreen(point2, component2);
        return point2;
    }

    public static Point convertPoint(Component component, int n, int n2, Component component2) {
        Point point = new Point(n, n2);
        return SwingUtilities.convertPoint(component, point, component2);
    }

    public static Rectangle convertRectangle(Component component, Rectangle rectangle, Component component2) {
        Point point = new Point(rectangle.x, rectangle.y);
        point = SwingUtilities.convertPoint(component, point, component2);
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    public static Container getAncestorOfClass(Class<?> clazz, Component component) {
        Container container;
        if (component == null || clazz == null) {
            return null;
        }
        for (container = component.getParent(); container != null && !clazz.isInstance(container); container = container.getParent()) {
        }
        return container;
    }

    public static Container getAncestorNamed(String string, Component component) {
        Container container;
        if (component == null || string == null) {
            return null;
        }
        for (container = component.getParent(); container != null && !string.equals(container.getName()); container = container.getParent()) {
        }
        return container;
    }

    public static Component getDeepestComponentAt(Component component, int n, int n2) {
        if (!component.contains(n, n2)) {
            return null;
        }
        if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                if (component2 == null || !component2.isVisible()) continue;
                Point point = component2.getLocation();
                if ((component2 = component2 instanceof Container ? SwingUtilities.getDeepestComponentAt(component2, n - point.x, n2 - point.y) : component2.getComponentAt(n - point.x, n2 - point.y)) == null || !component2.isVisible()) continue;
                return component2;
            }
        }
        return component;
    }

    public static MouseEvent convertMouseEvent(Component component, MouseEvent mouseEvent, Component component2) {
        MouseEvent mouseEvent2;
        Point point = SwingUtilities.convertPoint(component, new Point(mouseEvent.getX(), mouseEvent.getY()), component2);
        Component component3 = component2 != null ? component2 : component;
        if (mouseEvent instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
            mouseEvent2 = new MouseWheelEvent(component3, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers() | mouseWheelEvent.getModifiersEx(), point.x, point.y, mouseWheelEvent.getXOnScreen(), mouseWheelEvent.getYOnScreen(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        } else if (mouseEvent instanceof MenuDragMouseEvent) {
            MenuDragMouseEvent menuDragMouseEvent = (MenuDragMouseEvent)mouseEvent;
            mouseEvent2 = new MenuDragMouseEvent(component3, menuDragMouseEvent.getID(), menuDragMouseEvent.getWhen(), menuDragMouseEvent.getModifiers() | menuDragMouseEvent.getModifiersEx(), point.x, point.y, menuDragMouseEvent.getXOnScreen(), menuDragMouseEvent.getYOnScreen(), menuDragMouseEvent.getClickCount(), menuDragMouseEvent.isPopupTrigger(), menuDragMouseEvent.getPath(), menuDragMouseEvent.getMenuSelectionManager());
        } else {
            mouseEvent2 = new MouseEvent(component3, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        }
        return mouseEvent2;
    }

    public static void convertPointToScreen(Point point, Component component) {
        do {
            int n;
            int n2;
            if (component instanceof JComponent) {
                n2 = component.getX();
                n = component.getY();
            } else if (component instanceof Applet || component instanceof Window) {
                try {
                    Point point2 = component.getLocationOnScreen();
                    n2 = point2.x;
                    n = point2.y;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    n2 = component.getX();
                    n = component.getY();
                }
            } else {
                n2 = component.getX();
                n = component.getY();
            }
            point.x += n2;
            point.y += n;
        } while (!(component instanceof Window) && !(component instanceof Applet) && (component = component.getParent()) != null);
    }

    public static void convertPointFromScreen(Point point, Component component) {
        do {
            int n;
            int n2;
            if (component instanceof JComponent) {
                n2 = component.getX();
                n = component.getY();
            } else if (component instanceof Applet || component instanceof Window) {
                try {
                    Point point2 = component.getLocationOnScreen();
                    n2 = point2.x;
                    n = point2.y;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    n2 = component.getX();
                    n = component.getY();
                }
            } else {
                n2 = component.getX();
                n = component.getY();
            }
            point.x -= n2;
            point.y -= n;
        } while (!(component instanceof Window) && !(component instanceof Applet) && (component = component.getParent()) != null);
    }

    public static Window windowForComponent(Component component) {
        return SwingUtilities.getWindowAncestor(component);
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        if (component == component2) {
            return true;
        }
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (container != component2) continue;
            return true;
        }
        return false;
    }

    public static Rectangle computeIntersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = n > rectangle.x ? n : rectangle.x;
        int n6 = n + n3 < rectangle.x + rectangle.width ? n + n3 : rectangle.x + rectangle.width;
        int n7 = n2 > rectangle.y ? n2 : rectangle.y;
        int n8 = n2 + n4 < rectangle.y + rectangle.height ? n2 + n4 : rectangle.y + rectangle.height;
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
        if (rectangle.width < 0 || rectangle.height < 0) {
            rectangle.height = 0;
            rectangle.width = 0;
            rectangle.y = 0;
            rectangle.x = 0;
        }
        return rectangle;
    }

    public static Rectangle computeUnion(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = n < rectangle.x ? n : rectangle.x;
        int n6 = n + n3 > rectangle.x + rectangle.width ? n + n3 : rectangle.x + rectangle.width;
        int n7 = n2 < rectangle.y ? n2 : rectangle.y;
        int n8 = n2 + n4 > rectangle.y + rectangle.height ? n2 + n4 : rectangle.y + rectangle.height;
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
        return rectangle;
    }

    public static Rectangle[] computeDifference(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2 == null || !rectangle.intersects(rectangle2) || SwingUtilities.isRectangleContainingRectangle(rectangle2, rectangle)) {
            return new Rectangle[0];
        }
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = null;
        Rectangle rectangle5 = null;
        Rectangle rectangle6 = null;
        Rectangle rectangle7 = null;
        int n = 0;
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            rectangle3.x = rectangle.x;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle2.x - rectangle.x;
            rectangle3.height = rectangle.height;
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle4 = new Rectangle(rectangle3);
                ++n;
            }
            rectangle3.x = rectangle2.x;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle2.width;
            rectangle3.height = rectangle2.y - rectangle.y;
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle5 = new Rectangle(rectangle3);
                ++n;
            }
            rectangle3.x = rectangle2.x;
            rectangle3.y = rectangle2.y + rectangle2.height;
            rectangle3.width = rectangle2.width;
            rectangle3.height = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle6 = new Rectangle(rectangle3);
                ++n;
            }
            rectangle3.x = rectangle2.x + rectangle2.width;
            rectangle3.y = rectangle.y;
            rectangle3.width = rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
            rectangle3.height = rectangle.height;
            if (rectangle3.width > 0 && rectangle3.height > 0) {
                rectangle7 = new Rectangle(rectangle3);
                ++n;
            }
        } else if (rectangle2.x <= rectangle.x && rectangle2.y <= rectangle.y) {
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                rectangle3.x = rectangle.x;
                rectangle3.y = rectangle2.y + rectangle2.height;
                rectangle3.width = rectangle.width;
                rectangle3.height = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n;
                }
            } else if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle2.y + rectangle2.height - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        } else if (rectangle2.x <= rectangle.x && rectangle2.y + rectangle2.height >= rectangle.y + rectangle.height) {
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.y + rectangle.height - rectangle2.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        } else if (rectangle2.x <= rectangle.x) {
            if (rectangle2.x + rectangle2.width >= rectangle.x + rectangle.width) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle2.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle2.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        } else if (rectangle2.x <= rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
            if (rectangle2.y <= rectangle.y && rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = rectangle3;
                    ++n;
                }
            } else if (rectangle2.y <= rectangle.y) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle2.y + rectangle2.height - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            } else if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y, rectangle2.x - rectangle.x, rectangle.y + rectangle.height - rectangle2.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y, rectangle2.x - rectangle.x, rectangle2.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        } else if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            if (rectangle2.y <= rectangle.y && rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
            } else if (rectangle2.y <= rectangle.y) {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x, rectangle2.y + rectangle2.height, rectangle2.width, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n;
                }
            } else {
                rectangle3.setBounds(rectangle.x, rectangle.y, rectangle2.x - rectangle.x, rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle4 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x, rectangle.y, rectangle2.width, rectangle2.y - rectangle.y);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle5 = new Rectangle(rectangle3);
                    ++n;
                }
                rectangle3.setBounds(rectangle2.x + rectangle2.width, rectangle.y, rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), rectangle.height);
                if (rectangle3.width > 0 && rectangle3.height > 0) {
                    rectangle6 = new Rectangle(rectangle3);
                    ++n;
                }
            }
        }
        Rectangle[] rectangleArray = new Rectangle[n];
        n = 0;
        if (rectangle4 != null) {
            rectangleArray[n++] = rectangle4;
        }
        if (rectangle5 != null) {
            rectangleArray[n++] = rectangle5;
        }
        if (rectangle6 != null) {
            rectangleArray[n++] = rectangle6;
        }
        if (rectangle7 != null) {
            rectangleArray[n++] = rectangle7;
        }
        return rectangleArray;
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 0x10) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) == 8;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) == 4;
    }

    public static int computeStringWidth(FontMetrics fontMetrics, String string) {
        return SwingUtilities2.stringWidth(null, fontMetrics, string);
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        boolean bl = true;
        int n6 = n2;
        int n7 = n4;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n2) {
            case 10: {
                n6 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n6 = bl ? 4 : 2;
            }
        }
        switch (n4) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        return SwingUtilities.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n, n6, n3, n7, rectangle, rectangle2, rectangle3, n5);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        return SwingUtilities.layoutCompoundLabelImpl(null, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        int n8 = 0;
        int n9 = 0;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
            n7 = 0;
        } else {
            View view;
            n7 = icon == null ? 0 : n5;
            n6 = n4 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n7);
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = Math.min(n6, (int)view.getPreferredSpan(0));
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities2.stringWidth(jComponent, fontMetrics, string);
                n8 = SwingUtilities2.getLeftSideBearing(jComponent, fontMetrics, string);
                if (n8 < 0) {
                    rectangle3.width -= n8;
                }
                if (rectangle3.width > n6) {
                    string = SwingUtilities2.clipString(jComponent, fontMetrics, string, n6);
                    rectangle3.width = SwingUtilities2.stringWidth(jComponent, fontMetrics, string);
                }
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        rectangle3.y = n3 == 1 ? (n4 != 0 ? 0 : -(rectangle3.height + n7)) : (n3 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n4 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n7));
        rectangle3.x = n4 == 2 ? -(rectangle3.width + n7) : (n4 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n7);
        n6 = Math.min(rectangle2.x, rectangle3.x);
        int n10 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n6;
        int n11 = Math.min(rectangle2.y, rectangle3.y);
        int n12 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n11;
        int n13 = n == 1 ? rectangle.y - n11 : (n == 0 ? rectangle.y + rectangle.height / 2 - (n11 + n12 / 2) : rectangle.y + rectangle.height - (n11 + n12));
        int n14 = n2 == 2 ? rectangle.x - n6 : (n2 == 4 ? rectangle.x + rectangle.width - (n6 + n10) : rectangle.x + rectangle.width / 2 - (n6 + n10 / 2));
        rectangle3.x += n14;
        rectangle3.y += n13;
        rectangle2.x += n14;
        rectangle2.y += n13;
        if (n8 < 0) {
            rectangle3.x -= n8;
            rectangle3.width += n8;
        }
        if (n9 > 0) {
            rectangle3.width -= n9;
        }
        return string;
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4) {
        SwingUtilities.getCellRendererPane(component, container).paintComponent(graphics, component, container, n, n2, n3, n4, false);
    }

    public static void paintComponent(Graphics graphics, Component component, Container container, Rectangle rectangle) {
        SwingUtilities.paintComponent(graphics, component, container, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private static CellRendererPane getCellRendererPane(Component component, Container container) {
        Container container2 = component.getParent();
        if (container2 instanceof CellRendererPane) {
            if (container2.getParent() != container) {
                container.add(container2);
            }
        } else {
            container2 = new CellRendererPane();
            container2.add(component);
            container.add(container2);
        }
        return (CellRendererPane)container2;
    }

    public static void updateComponentTreeUI(Component component) {
        SwingUtilities.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        Component[] componentArray;
        if (component instanceof JComponent) {
            componentArray = (Component[])component;
            componentArray.updateUI();
            Component[] componentArray2 = componentArray.getComponentPopupMenu();
            if (componentArray2 != null) {
                SwingUtilities.updateComponentTreeUI((Component)componentArray2);
            }
        }
        componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (Component component2 : componentArray) {
                SwingUtilities.updateComponentTreeUI0(component2);
            }
        }
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(runnable);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static int getAccessibleIndexInParent(Component component) {
        return component.getAccessibleContext().getAccessibleIndexInParent();
    }

    public static Accessible getAccessibleAt(Component component, Point point) {
        if (component instanceof Container) {
            return component.getAccessibleContext().getAccessibleComponent().getAccessibleAt(point);
        }
        if (component instanceof Accessible) {
            AccessibleContext accessibleContext;
            Accessible accessible = (Accessible)((Object)component);
            if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
                int n = accessibleContext.getAccessibleChildrenCount();
                for (int i = 0; i < n; ++i) {
                    AccessibleComponent accessibleComponent;
                    accessible = accessibleContext.getAccessibleChild(i);
                    if (accessible == null || (accessibleContext = accessible.getAccessibleContext()) == null || (accessibleComponent = accessibleContext.getAccessibleComponent()) == null || !accessibleComponent.isShowing()) continue;
                    Point point2 = accessibleComponent.getLocation();
                    Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                    if (!accessibleComponent.contains(point3)) continue;
                    return accessible;
                }
            }
            return (Accessible)((Object)component);
        }
        return null;
    }

    public static AccessibleStateSet getAccessibleStateSet(Component component) {
        return component.getAccessibleContext().getAccessibleStateSet();
    }

    public static int getAccessibleChildrenCount(Component component) {
        return component.getAccessibleContext().getAccessibleChildrenCount();
    }

    public static Accessible getAccessibleChild(Component component, int n) {
        return component.getAccessibleContext().getAccessibleChild(n);
    }

    @Deprecated
    public static Component findFocusOwner(Component component) {
        Component component2;
        Component component3 = component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (component3 != null) {
            if (component3 == component) {
                return component2;
            }
            component3 = component3 instanceof Window ? null : component3.getParent();
        }
        return null;
    }

    public static JRootPane getRootPane(Component component) {
        if (component instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)component)).getRootPane();
        }
        while (component != null) {
            if (component instanceof JRootPane) {
                return (JRootPane)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static Component getRoot(Component component) {
        Component component2 = null;
        for (Component component3 = component; component3 != null; component3 = component3.getParent()) {
            if (component3 instanceof Window) {
                return component3;
            }
            if (!(component3 instanceof Applet)) continue;
            component2 = component3;
        }
        return component2;
    }

    static JComponent getPaintingOrigin(JComponent jComponent) {
        Container container = jComponent;
        while ((container = container.getParent()) instanceof JComponent) {
            Container container2 = container;
            if (!((JComponent)container2).isPaintingOrigin()) continue;
            return container2;
        }
        return null;
    }

    public static boolean processKeyBindings(KeyEvent keyEvent) {
        if (keyEvent != null) {
            boolean bl;
            if (keyEvent.isConsumed()) {
                return false;
            }
            boolean bl2 = bl = keyEvent.getID() == 401;
            if (!SwingUtilities.isValidKeyEventForKeyBindings(keyEvent)) {
                return false;
            }
            for (Component component = keyEvent.getComponent(); component != null; component = component.getParent()) {
                if (component instanceof JComponent) {
                    return ((JComponent)component).processKeyBindings(keyEvent, bl);
                }
                if (!(component instanceof Applet) && !(component instanceof Window)) continue;
                return JComponent.processKeyBindingsForAllComponents(keyEvent, (Container)component, bl);
            }
        }
        return false;
    }

    static boolean isValidKeyEventForKeyBindings(KeyEvent keyEvent) {
        return true;
    }

    public static boolean notifyAction(Action action, KeyStroke keyStroke, KeyEvent keyEvent, Object object, int n) {
        if (action == null) {
            return false;
        }
        if (action instanceof UIAction ? !((UIAction)action).isEnabled(object) : !action.isEnabled()) {
            return false;
        }
        Object object2 = action.getValue("ActionCommandKey");
        boolean bl = object2 == null && action instanceof JComponent.ActionStandin;
        String string = object2 != null ? object2.toString() : (!bl && keyEvent.getKeyChar() != '\uffff' ? String.valueOf(keyEvent.getKeyChar()) : null);
        action.actionPerformed(new ActionEvent(object, 1001, string, keyEvent.getWhen(), n));
        return true;
    }

    public static void replaceUIInputMap(JComponent jComponent, int n, InputMap inputMap) {
        InputMap inputMap2 = jComponent.getInputMap(n, inputMap != null);
        while (inputMap2 != null) {
            InputMap inputMap3 = inputMap2.getParent();
            if (inputMap3 == null || inputMap3 instanceof UIResource) {
                inputMap2.setParent(inputMap);
                return;
            }
            inputMap2 = inputMap3;
        }
    }

    public static void replaceUIActionMap(JComponent jComponent, ActionMap actionMap) {
        ActionMap actionMap2 = jComponent.getActionMap(actionMap != null);
        while (actionMap2 != null) {
            ActionMap actionMap3 = actionMap2.getParent();
            if (actionMap3 == null || actionMap3 instanceof UIResource) {
                actionMap2.setParent(actionMap);
                return;
            }
            actionMap2 = actionMap3;
        }
    }

    public static InputMap getUIInputMap(JComponent jComponent, int n) {
        InputMap inputMap = jComponent.getInputMap(n, false);
        while (inputMap != null) {
            InputMap inputMap2 = inputMap.getParent();
            if (inputMap2 instanceof UIResource) {
                return inputMap2;
            }
            inputMap = inputMap2;
        }
        return null;
    }

    public static ActionMap getUIActionMap(JComponent jComponent) {
        ActionMap actionMap = jComponent.getActionMap(false);
        while (actionMap != null) {
            ActionMap actionMap2 = actionMap.getParent();
            if (actionMap2 instanceof UIResource) {
                return actionMap2;
            }
            actionMap = actionMap2;
        }
        return null;
    }

    static Frame getSharedOwnerFrame() throws HeadlessException {
        Frame frame = (Frame)SwingUtilities.appContextGet(sharedOwnerFrameKey);
        if (frame == null) {
            frame = new SharedOwnerFrame();
            SwingUtilities.appContextPut(sharedOwnerFrameKey, frame);
        }
        return frame;
    }

    static WindowListener getSharedOwnerFrameShutdownListener() throws HeadlessException {
        Frame frame = SwingUtilities.getSharedOwnerFrame();
        return (WindowListener)((Object)frame);
    }

    static Object appContextGet(Object object) {
        return AppContext.getAppContext().get(object);
    }

    static void appContextPut(Object object, Object object2) {
        AppContext.getAppContext().put(object, object2);
    }

    static void appContextRemove(Object object) {
        AppContext.getAppContext().remove(object);
    }

    static Class<?> loadSystemClass(String string) throws ClassNotFoundException {
        return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    private SwingUtilities() {
        throw new Error("SwingUtilities is just a container for static methods");
    }

    static boolean doesIconReferenceImage(Icon icon, Image image) {
        Image image2 = icon != null && icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
        return image2 == image;
    }

    static int findDisplayedMnemonicIndex(String string, int n) {
        if (string == null || n == 0) {
            return -1;
        }
        char c = Character.toUpperCase((char)n);
        char c2 = Character.toLowerCase((char)n);
        int n2 = string.indexOf(c);
        int n3 = string.indexOf(c2);
        if (n2 == -1) {
            return n3;
        }
        if (n3 == -1) {
            return n2;
        }
        return n3 < n2 ? n3 : n2;
    }

    public static Rectangle calculateInnerArea(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return null;
        }
        Rectangle rectangle2 = rectangle;
        Insets insets = jComponent.getInsets();
        if (rectangle2 == null) {
            rectangle2 = new Rectangle();
        }
        rectangle2.x = insets.left;
        rectangle2.y = insets.top;
        rectangle2.width = jComponent.getWidth() - insets.left - insets.right;
        rectangle2.height = jComponent.getHeight() - insets.top - insets.bottom;
        return rectangle2;
    }

    static void updateRendererOrEditorUI(Object object) {
        if (object == null) {
            return;
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        if (object instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)object).getComponent();
        }
        if (component != null) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    public static Container getUnwrappedParent(Component component) {
        Container container = component.getParent();
        while (container instanceof JLayer) {
            container = container.getParent();
        }
        return container;
    }

    public static Component getUnwrappedView(JViewport jViewport) {
        Component component = jViewport.getView();
        while (component instanceof JLayer) {
            component = ((JLayer)component).getView();
        }
        return component;
    }

    static Container getValidateRoot(Container container, boolean bl) {
        Container container2 = null;
        while (container != null) {
            if (!container.isDisplayable() || container instanceof CellRendererPane) {
                return null;
            }
            if (container.isValidateRoot()) {
                container2 = container;
                break;
            }
            container = container.getParent();
        }
        if (container2 == null) {
            return null;
        }
        while (container != null) {
            if (!container.isDisplayable() || bl && !container.isVisible()) {
                return null;
            }
            if (container instanceof Window || container instanceof Applet) {
                return container2;
            }
            container = container.getParent();
        }
        return null;
    }

    static {
        sharedOwnerFrameKey = new Object();
    }

    static class SharedOwnerFrame
    extends Frame
    implements WindowListener {
        SharedOwnerFrame() {
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.installListeners();
        }

        void installListeners() {
            Window[] windowArray;
            for (Window window : windowArray = this.getOwnedWindows()) {
                if (window == null) continue;
                window.removeWindowListener(this);
                window.addWindowListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosed(WindowEvent windowEvent) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Window[] windowArray;
                for (Window window : windowArray = this.getOwnedWindows()) {
                    if (window == null) continue;
                    if (window.isDisplayable()) {
                        return;
                    }
                    window.removeWindowListener(this);
                }
                this.dispose();
            }
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void show() {
        }

        @Override
        public void dispose() {
            try {
                this.getToolkit().getSystemEventQueue();
                super.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

