/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.LoginOptions;
import sun.security.krb5.internal.ccache.CCacheInputStream;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.ccache.FileCCacheConstants;
import sun.security.krb5.internal.ccache.Tag;

public class FileCredentialsCache
extends CredentialsCache
implements FileCCacheConstants {
    public int version;
    public Tag tag;
    public PrincipalName primaryPrincipal;
    public Realm primaryRealm;
    private Vector<Credentials> credentialsList;
    private static String dir;
    private static boolean DEBUG;
    private static boolean alreadyLoaded;
    private static boolean alreadyTried;

    public static synchronized FileCredentialsCache acquireInstance(PrincipalName principalName, String string) {
        block6: {
            try {
                FileCredentialsCache fileCredentialsCache = new FileCredentialsCache();
                cacheName = string == null ? fileCredentialsCache.getDefaultCacheName() : FileCredentialsCache.checkValidation(string);
                if (cacheName == null || !new File(cacheName).exists()) {
                    return null;
                }
                if (principalName != null) {
                    fileCredentialsCache.primaryPrincipal = principalName;
                    fileCredentialsCache.primaryRealm = principalName.getRealm();
                }
                fileCredentialsCache.load(cacheName);
                return fileCredentialsCache;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
            }
            catch (KrbException krbException) {
                if (!DEBUG) break block6;
                krbException.printStackTrace();
            }
        }
        return null;
    }

    public static FileCredentialsCache acquireInstance() {
        return FileCredentialsCache.acquireInstance(null, null);
    }

    static synchronized FileCredentialsCache New(PrincipalName principalName, String string) {
        try {
            FileCredentialsCache fileCredentialsCache = new FileCredentialsCache();
            cacheName = FileCredentialsCache.checkValidation(string);
            if (cacheName == null) {
                return null;
            }
            fileCredentialsCache.init(principalName, cacheName);
            return fileCredentialsCache;
        }
        catch (IOException iOException) {
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return null;
    }

    static synchronized FileCredentialsCache New(PrincipalName principalName) {
        block4: {
            try {
                FileCredentialsCache fileCredentialsCache = new FileCredentialsCache();
                cacheName = fileCredentialsCache.getDefaultCacheName();
                fileCredentialsCache.init(principalName, cacheName);
                return fileCredentialsCache;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
            }
            catch (KrbException krbException) {
                if (!DEBUG) break block4;
                krbException.printStackTrace();
            }
        }
        return null;
    }

    private FileCredentialsCache() {
    }

    boolean exists(String string) {
        File file = new File(string);
        return file.exists();
    }

    synchronized void init(PrincipalName principalName, String string) throws IOException, KrbException {
        this.primaryPrincipal = principalName;
        this.primaryRealm = principalName.getRealm();
        CCacheOutputStream cCacheOutputStream = new CCacheOutputStream(new FileOutputStream(string));
        this.version = 1283;
        cCacheOutputStream.writeHeader(this.primaryPrincipal, this.version);
        cCacheOutputStream.close();
        this.load(string);
    }

    synchronized void load(String string) throws IOException, KrbException {
        CCacheInputStream cCacheInputStream = new CCacheInputStream(new FileInputStream(string));
        this.version = cCacheInputStream.readVersion();
        if (this.version == 1284) {
            this.tag = cCacheInputStream.readTag();
        } else {
            this.tag = null;
            if (this.version == 1281 || this.version == 1282) {
                cCacheInputStream.setNativeByteOrder();
            }
        }
        PrincipalName principalName = cCacheInputStream.readPrincipal(this.version);
        if (this.primaryPrincipal != null) {
            if (!this.primaryPrincipal.match(principalName)) {
                throw new IOException("Primary principals don't match.");
            }
        } else {
            this.primaryPrincipal = principalName;
        }
        this.primaryRealm = this.primaryPrincipal.getRealm();
        this.credentialsList = new Vector();
        while (cCacheInputStream.available() > 0) {
            Credentials credentials = cCacheInputStream.readCred(this.version);
            if (credentials == null) continue;
            this.credentialsList.addElement(credentials);
        }
        cCacheInputStream.close();
    }

    @Override
    public synchronized void update(Credentials credentials) {
        if (this.credentialsList != null) {
            if (this.credentialsList.isEmpty()) {
                this.credentialsList.addElement(credentials);
            } else {
                Credentials credentials2 = null;
                boolean bl = false;
                for (int i = 0; i < this.credentialsList.size(); ++i) {
                    credentials2 = this.credentialsList.elementAt(i);
                    if (!this.match(credentials.sname.getNameStrings(), credentials2.sname.getNameStrings()) || !credentials.sname.getRealmString().equalsIgnoreCase(credentials2.sname.getRealmString())) continue;
                    bl = true;
                    if (credentials.endtime.getTime() < credentials2.endtime.getTime()) continue;
                    if (DEBUG) {
                        System.out.println(" >>> FileCredentialsCache Ticket matched, overwrite the old one.");
                    }
                    this.credentialsList.removeElementAt(i);
                    this.credentialsList.addElement(credentials);
                }
                if (!bl) {
                    if (DEBUG) {
                        System.out.println(" >>> FileCredentialsCache Ticket not exactly matched, add new one into cache.");
                    }
                    this.credentialsList.addElement(credentials);
                }
            }
        }
    }

    @Override
    public synchronized PrincipalName getPrimaryPrincipal() {
        return this.primaryPrincipal;
    }

    @Override
    public synchronized void save() throws IOException, Asn1Exception {
        CCacheOutputStream cCacheOutputStream = new CCacheOutputStream(new FileOutputStream(cacheName));
        cCacheOutputStream.writeHeader(this.primaryPrincipal, this.version);
        Credentials[] credentialsArray = null;
        credentialsArray = this.getCredsList();
        if (credentialsArray != null) {
            for (int i = 0; i < credentialsArray.length; ++i) {
                cCacheOutputStream.addCreds(credentialsArray[i]);
            }
        }
        cCacheOutputStream.close();
    }

    boolean match(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Credentials[] getCredsList() {
        if (this.credentialsList == null || this.credentialsList.isEmpty()) {
            return null;
        }
        Credentials[] credentialsArray = new Credentials[this.credentialsList.size()];
        for (int i = 0; i < this.credentialsList.size(); ++i) {
            credentialsArray[i] = this.credentialsList.elementAt(i);
        }
        return credentialsArray;
    }

    @Override
    public Credentials getCreds(LoginOptions loginOptions, PrincipalName principalName, Realm realm) {
        if (loginOptions == null) {
            return this.getCreds(principalName, realm);
        }
        Credentials[] credentialsArray = this.getCredsList();
        if (credentialsArray == null) {
            return null;
        }
        for (int i = 0; i < credentialsArray.length; ++i) {
            if (!principalName.match(credentialsArray[i].sname) || !realm.toString().equals(credentialsArray[i].srealm.toString()) || !credentialsArray[i].flags.match(loginOptions)) continue;
            return credentialsArray[i];
        }
        return null;
    }

    @Override
    public Credentials getCreds(PrincipalName principalName, Realm realm) {
        Credentials[] credentialsArray = this.getCredsList();
        if (credentialsArray == null) {
            return null;
        }
        for (int i = 0; i < credentialsArray.length; ++i) {
            if (!principalName.match(credentialsArray[i].sname) || !realm.toString().equals(credentialsArray[i].srealm.toString())) continue;
            return credentialsArray[i];
        }
        return null;
    }

    @Override
    public Credentials getDefaultCreds() {
        Credentials[] credentialsArray = this.getCredsList();
        if (credentialsArray == null) {
            return null;
        }
        for (int i = credentialsArray.length - 1; i >= 0; --i) {
            String[] stringArray;
            if (!credentialsArray[i].sname.toString().startsWith("krbtgt") || !(stringArray = credentialsArray[i].sname.getNameStrings())[1].equals(credentialsArray[i].srealm.toString())) continue;
            return credentialsArray[i];
        }
        return null;
    }

    public static String getDefaultCacheName() {
        String string;
        String string2;
        block16: {
            string2 = "krb5cc";
            string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String string = System.getenv("KRB5CCNAME");
                    if (string != null && string.length() >= 5 && string.regionMatches(true, 0, "FILE:", 0, 5)) {
                        string = string.substring(5);
                    }
                    return string;
                }
            });
            if (string != null) {
                if (DEBUG) {
                    System.out.println(">>>KinitOptions cache name is " + string);
                }
                return string;
            }
            String string3 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string3 != null && (string3.startsWith("SunOS") || string3.startsWith("Linux"))) {
                try {
                    if (!alreadyTried) {
                        try {
                            FileCredentialsCache.ensureLoaded();
                        }
                        catch (Exception exception) {
                            if (DEBUG) {
                                System.out.println("Could not load native Kerberos bridge");
                                exception.printStackTrace();
                            }
                            alreadyTried = true;
                        }
                    }
                    if (alreadyLoaded) {
                        if (DEBUG) {
                            System.out.println(">> Look up native default credential cache");
                        }
                        string = FileCredentialsCache.nativeGetDefaultCacheName();
                    }
                    if (string != null && (string.startsWith("FILE:") || string.startsWith("DIR::"))) {
                        string = string.substring(5);
                        if (DEBUG) {
                            System.out.println(">>>KinitOptions cache name is " + string);
                        }
                        return string;
                    }
                    long l = 0L;
                    Class<?> clazz = Class.forName("com.sun.security.auth.module.UnixSystem");
                    Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                    Object obj = constructor.newInstance(new Object[0]);
                    Method method = clazz.getMethod("getUid", new Class[0]);
                    l = (Long)method.invoke(obj, new Object[0]);
                    string = File.separator + "tmp" + File.separator + string2 + "_" + l;
                    if (DEBUG) {
                        System.out.println(">>>KinitOptions cache name is " + string);
                    }
                    return string;
                }
                catch (Exception exception) {
                    if (!DEBUG) break block16;
                    System.out.println("Exception in obtaining uid for Unix platforms Using user's home directory");
                    exception.printStackTrace();
                }
            }
        }
        String string4 = AccessController.doPrivileged(new GetPropertyAction("user.name"));
        String string5 = AccessController.doPrivileged(new GetPropertyAction("user.home"));
        if (string5 == null) {
            string5 = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
        }
        string = string4 != null ? string5 + File.separator + string2 + "_" + string4 : string5 + File.separator + string2;
        if (DEBUG) {
            System.out.println(">>>KinitOptions cache name is " + string);
        }
        return string;
    }

    private static native String nativeGetDefaultCacheName() throws Exception;

    public static String checkValidation(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        try {
            string2 = new File(string).getCanonicalPath();
            File file = new File(string2);
            if (!file.exists()) {
                File file2 = new File(file.getParent());
                if (!file2.isDirectory()) {
                    string2 = null;
                }
                file2 = null;
            }
            file = null;
        }
        catch (IOException iOException) {
            string2 = null;
        }
        return string2;
    }

    private static String exec(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        try {
            Process process = AccessController.doPrivileged(new PrivilegedAction<Process>((String[])objectArray){
                final /* synthetic */ String[] val$command;
                {
                    this.val$command = stringArray;
                }

                @Override
                public Process run() {
                    try {
                        return Runtime.getRuntime().exec(this.val$command);
                    }
                    catch (IOException iOException) {
                        if (DEBUG) {
                            iOException.printStackTrace();
                        }
                        return null;
                    }
                }
            });
            if (process == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "8859_1"));
            String string2 = null;
            if (objectArray.length == 1 && ((String)objectArray[0]).equals("/usr/bin/env")) {
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.length() < 11 || !string2.substring(0, 11).equalsIgnoreCase("KRB5CCNAME=")) continue;
                    string2 = string2.substring(11);
                    break;
                }
            } else {
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            return string2;
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    private static void ensureLoaded() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("j2krb5");
                return null;
            }
        });
        alreadyLoaded = true;
    }

    static {
        DEBUG = Krb5.DEBUG;
        alreadyLoaded = false;
        alreadyTried = false;
    }
}

