/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.GraphicsEnvironment;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;
import java.util.EventListener;
import sun.awt.AWTAccessor;

public class ScrollPaneAdjustable
implements Adjustable,
Serializable {
    private ScrollPane sp;
    private int orientation;
    private int value;
    private int minimum;
    private int maximum;
    private int visibleAmount;
    private transient boolean isAdjusting;
    private int unitIncrement = 1;
    private int blockIncrement = 1;
    private AdjustmentListener adjustmentListener;
    private static final String SCROLLPANE_ONLY = "Can be set by scrollpane only";
    private static final long serialVersionUID = -3359745691033257079L;

    private static native void initIDs();

    ScrollPaneAdjustable(ScrollPane sp, AdjustmentListener l, int orientation) {
        this.sp = sp;
        this.orientation = orientation;
        this.addAdjustmentListener(l);
    }

    void setSpan(int min, int max, int visible) {
        this.minimum = min;
        this.maximum = Math.max(max, this.minimum + 1);
        this.visibleAmount = Math.min(visible, this.maximum - this.minimum);
        this.visibleAmount = Math.max(this.visibleAmount, 1);
        this.blockIncrement = Math.max((int)((double)visible * 0.9), 1);
        this.setValue(this.value);
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public void setMinimum(int min) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMaximum(int max) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public synchronized void setUnitIncrement(int u) {
        if (u != this.unitIncrement) {
            this.unitIncrement = u;
            if (this.sp.peer != null) {
                ScrollPanePeer peer = (ScrollPanePeer)this.sp.peer;
                peer.setUnitIncrement(this, u);
            }
        }
    }

    @Override
    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    @Override
    public synchronized void setBlockIncrement(int b) {
        this.blockIncrement = b;
    }

    @Override
    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    @Override
    public void setVisibleAmount(int v) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    @Override
    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public void setValueIsAdjusting(boolean b) {
        if (this.isAdjusting != b) {
            this.isAdjusting = b;
            AdjustmentEvent e = new AdjustmentEvent(this, 601, 5, this.value, b);
            this.adjustmentListener.adjustmentValueChanged(e);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public void setValue(int v) {
        this.setTypedValue(v, 5);
    }

    private void setTypedValue(int v, int type) {
        v = Math.max(v, this.minimum);
        if ((v = Math.min(v, this.maximum - this.visibleAmount)) != this.value) {
            this.value = v;
            AdjustmentEvent e = new AdjustmentEvent(this, 601, type, this.value, this.isAdjusting);
            this.adjustmentListener.adjustmentValueChanged(e);
        }
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener l) {
        if (l == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener l) {
        if (l == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    public synchronized AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])AWTEventMulticaster.getListeners((EventListener)this.adjustmentListener, AdjustmentListener.class);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public String paramString() {
        return (this.orientation == 1 ? "vertical," : "horizontal,") + "[0.." + this.maximum + "],val=" + this.value + ",vis=" + this.visibleAmount + ",unit=" + this.unitIncrement + ",block=" + this.blockIncrement + ",isAdjusting=" + this.isAdjusting;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            ScrollPaneAdjustable.initIDs();
        }
        AWTAccessor.setScrollPaneAdjustableAccessor(new AWTAccessor.ScrollPaneAdjustableAccessor(){

            @Override
            public void setTypedValue(ScrollPaneAdjustable adj, int v, int type) {
                adj.setTypedValue(v, type);
            }
        });
    }
}

