/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.rowset.serial.SerialException;

public class SerialRef
implements Ref,
Serializable,
Cloneable {
    private String baseTypeName;
    private Object object;
    private Ref reference;
    static final long serialVersionUID = -4727123500609662274L;

    public SerialRef(Ref ref) throws SerialException, SQLException {
        if (ref == null) {
            throw new SQLException("Cannot instantiate a SerialRef object with a null Ref object");
        }
        this.reference = ref;
        this.object = ref;
        if (ref.getBaseTypeName() == null) {
            throw new SQLException("Cannot instantiate a SerialRef object that returns a null base type name");
        }
        this.baseTypeName = ref.getBaseTypeName();
    }

    @Override
    public String getBaseTypeName() throws SerialException {
        return this.baseTypeName;
    }

    @Override
    public Object getObject(Map<String, Class<?>> map) throws SerialException {
        map = new Hashtable(map);
        if (this.object != null) {
            return map.get(this.object);
        }
        throw new SerialException("The object is not set");
    }

    @Override
    public Object getObject() throws SerialException {
        if (this.reference != null) {
            try {
                return this.reference.getObject();
            }
            catch (SQLException e) {
                throw new SerialException("SQLException: " + e.getMessage());
            }
        }
        if (this.object != null) {
            return this.object;
        }
        throw new SerialException("The object is not set");
    }

    @Override
    public void setObject(Object obj) throws SerialException {
        try {
            this.reference.setObject(obj);
        }
        catch (SQLException e) {
            throw new SerialException("SQLException: " + e.getMessage());
        }
        this.object = obj;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SerialRef) {
            SerialRef ref = (SerialRef)obj;
            return this.baseTypeName.equals(ref.baseTypeName) && this.object.equals(ref.object);
        }
        return false;
    }

    public int hashCode() {
        return (31 + this.object.hashCode()) * 31 + this.baseTypeName.hashCode();
    }

    public Object clone() {
        try {
            SerialRef ref = (SerialRef)super.clone();
            ref.reference = null;
            return ref;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        this.object = fields.get("object", null);
        this.baseTypeName = (String)fields.get("baseTypeName", null);
        this.reference = (Ref)fields.get("reference", null);
    }

    private void writeObject(ObjectOutputStream s) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("baseTypeName", this.baseTypeName);
        fields.put("object", this.object);
        fields.put("reference", this.reference instanceof Serializable ? this.reference : null);
        s.writeFields();
    }
}

