/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class Oid {
    private ObjectIdentifier oid;
    private byte[] derEncoding;

    public Oid(String strOid) throws GSSException {
        try {
            this.oid = new ObjectIdentifier(strOid);
            this.derEncoding = null;
        }
        catch (Exception e) {
            throw new GSSException(11, "Improperly formatted Object Identifier String - " + strOid);
        }
    }

    public Oid(InputStream derOid) throws GSSException {
        try {
            DerValue derVal = new DerValue(derOid);
            this.derEncoding = derVal.toByteArray();
            this.oid = derVal.getOID();
        }
        catch (IOException e) {
            throw new GSSException(11, "Improperly formatted ASN.1 DER encoding for Oid");
        }
    }

    public Oid(byte[] data) throws GSSException {
        try {
            DerValue derVal = new DerValue(data);
            this.derEncoding = derVal.toByteArray();
            this.oid = derVal.getOID();
        }
        catch (IOException e) {
            throw new GSSException(11, "Improperly formatted ASN.1 DER encoding for Oid");
        }
    }

    static Oid getInstance(String strOid) {
        Oid retVal = null;
        try {
            retVal = new Oid(strOid);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return retVal;
    }

    public String toString() {
        return this.oid.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Oid) {
            return this.oid.equals((Object)((Oid)other).oid);
        }
        if (other instanceof ObjectIdentifier) {
            return this.oid.equals(other);
        }
        return false;
    }

    public byte[] getDER() throws GSSException {
        if (this.derEncoding == null) {
            DerOutputStream dout = new DerOutputStream();
            try {
                dout.putOID(this.oid);
            }
            catch (IOException e) {
                throw new GSSException(11, e.getMessage());
            }
            this.derEncoding = dout.toByteArray();
        }
        return (byte[])this.derEncoding.clone();
    }

    public boolean containedIn(Oid[] oids) {
        for (int i = 0; i < oids.length; ++i) {
            if (!oids[i].equals(this)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }
}

