/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOUtil;

class FileDispatcherImpl
extends FileDispatcher {
    private static final boolean fastFileTransfer;
    private final boolean append;

    FileDispatcherImpl(boolean append) {
        this.append = append;
    }

    FileDispatcherImpl() {
        this(false);
    }

    @Override
    boolean needsPositionLock() {
        return true;
    }

    @Override
    int read(FileDescriptor fd, long address, int len) throws IOException {
        return FileDispatcherImpl.read0(fd, address, len);
    }

    @Override
    int pread(FileDescriptor fd, long address, int len, long position) throws IOException {
        return FileDispatcherImpl.pread0(fd, address, len, position);
    }

    @Override
    long readv(FileDescriptor fd, long address, int len) throws IOException {
        return FileDispatcherImpl.readv0(fd, address, len);
    }

    @Override
    int write(FileDescriptor fd, long address, int len) throws IOException {
        return FileDispatcherImpl.write0(fd, address, len, this.append);
    }

    @Override
    int pwrite(FileDescriptor fd, long address, int len, long position) throws IOException {
        return FileDispatcherImpl.pwrite0(fd, address, len, position);
    }

    @Override
    long writev(FileDescriptor fd, long address, int len) throws IOException {
        return FileDispatcherImpl.writev0(fd, address, len, this.append);
    }

    @Override
    int force(FileDescriptor fd, boolean metaData) throws IOException {
        return FileDispatcherImpl.force0(fd, metaData);
    }

    @Override
    int truncate(FileDescriptor fd, long size) throws IOException {
        return FileDispatcherImpl.truncate0(fd, size);
    }

    @Override
    long size(FileDescriptor fd) throws IOException {
        return FileDispatcherImpl.size0(fd);
    }

    @Override
    int lock(FileDescriptor fd, boolean blocking, long pos, long size, boolean shared) throws IOException {
        return FileDispatcherImpl.lock0(fd, blocking, pos, size, shared);
    }

    @Override
    void release(FileDescriptor fd, long pos, long size) throws IOException {
        FileDispatcherImpl.release0(fd, pos, size);
    }

    @Override
    void close(FileDescriptor fd) throws IOException {
        FileDispatcherImpl.close0(fd);
    }

    @Override
    FileDescriptor duplicateForMapping(FileDescriptor fd) throws IOException {
        JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
        FileDescriptor result = new FileDescriptor();
        long handle = FileDispatcherImpl.duplicateHandle(fdAccess.getHandle(fd));
        fdAccess.setHandle(result, handle);
        return result;
    }

    @Override
    boolean canTransferToDirectly(SelectableChannel sc) {
        return fastFileTransfer && sc.isBlocking();
    }

    @Override
    boolean transferToDirectlyNeedsPositionLock() {
        return true;
    }

    static boolean isFastFileTransferRequested() {
        String fileTransferProp = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("jdk.nio.enableFastFileTransfer");
            }
        });
        boolean enable = "".equals(fileTransferProp) ? true : Boolean.parseBoolean(fileTransferProp);
        return enable;
    }

    static native int read0(FileDescriptor var0, long var1, int var3) throws IOException;

    static native int pread0(FileDescriptor var0, long var1, int var3, long var4) throws IOException;

    static native long readv0(FileDescriptor var0, long var1, int var3) throws IOException;

    static native int write0(FileDescriptor var0, long var1, int var3, boolean var4) throws IOException;

    static native int pwrite0(FileDescriptor var0, long var1, int var3, long var4) throws IOException;

    static native long writev0(FileDescriptor var0, long var1, int var3, boolean var4) throws IOException;

    static native int force0(FileDescriptor var0, boolean var1) throws IOException;

    static native int truncate0(FileDescriptor var0, long var1) throws IOException;

    static native long size0(FileDescriptor var0) throws IOException;

    static native int lock0(FileDescriptor var0, boolean var1, long var2, long var4, boolean var6) throws IOException;

    static native void release0(FileDescriptor var0, long var1, long var3) throws IOException;

    static native void close0(FileDescriptor var0) throws IOException;

    static native void closeByHandle(long var0) throws IOException;

    static native long duplicateHandle(long var0) throws IOException;

    static {
        IOUtil.load();
        fastFileTransfer = FileDispatcherImpl.isFastFileTransferRequested();
    }
}

