/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.util.concurrent.Future;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousFileChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.Groupable;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.Iocp;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.PendingIoCache;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.Util;

public class WindowsAsynchronousFileChannelImpl
extends AsynchronousFileChannelImpl
implements Iocp.OverlappedChannel,
Groupable {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private static final int ERROR_HANDLE_EOF = 38;
    private static final FileDispatcher nd = new FileDispatcherImpl();
    private final long handle;
    private final int completionKey;
    private final Iocp iocp;
    private final boolean isDefaultIocp;
    private final PendingIoCache ioCache;
    static final int NO_LOCK = -1;
    static final int LOCKED = 0;

    private WindowsAsynchronousFileChannelImpl(FileDescriptor fdObj, boolean reading, boolean writing, Iocp iocp, boolean isDefaultIocp) throws IOException {
        super(fdObj, reading, writing, iocp.executor());
        this.handle = fdAccess.getHandle(fdObj);
        this.iocp = iocp;
        this.isDefaultIocp = isDefaultIocp;
        this.ioCache = new PendingIoCache();
        this.completionKey = iocp.associate(this, this.handle);
    }

    public static AsynchronousFileChannel open(FileDescriptor fdo, boolean reading, boolean writing, ThreadPool pool) throws IOException {
        boolean isDefaultIocp;
        Iocp iocp;
        if (pool == null) {
            iocp = DefaultIocpHolder.defaultIocp;
            isDefaultIocp = true;
        } else {
            iocp = new Iocp(null, pool).start();
            isDefaultIocp = false;
        }
        try {
            return new WindowsAsynchronousFileChannelImpl(fdo, reading, writing, iocp, isDefaultIocp);
        }
        catch (IOException x) {
            if (!isDefaultIocp) {
                iocp.implClose();
            }
            throw x;
        }
    }

    @Override
    public <V, A> PendingFuture<V, A> getByOverlapped(long overlapped) {
        return this.ioCache.remove(overlapped);
    }

    @Override
    public void close() throws IOException {
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.invalidateAllLocks();
        WindowsAsynchronousFileChannelImpl.close0(this.handle);
        this.ioCache.close();
        this.iocp.disassociate(this.completionKey);
        if (!this.isDefaultIocp) {
            this.iocp.detachFromThreadPool();
        }
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.iocp;
    }

    private static IOException toIOException(Throwable x) {
        if (x instanceof IOException) {
            if (x instanceof ClosedChannelException) {
                x = new AsynchronousCloseException();
            }
            return (IOException)x;
        }
        return new IOException(x);
    }

    @Override
    public long size() throws IOException {
        try {
            this.begin();
            long l = nd.size(this.fdObj);
            return l;
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousFileChannel truncate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        try {
            this.begin();
            if (size > nd.size(this.fdObj)) {
                WindowsAsynchronousFileChannelImpl windowsAsynchronousFileChannelImpl = this;
                return windowsAsynchronousFileChannelImpl;
            }
            nd.truncate(this.fdObj, size);
        }
        finally {
            this.end();
        }
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        try {
            this.begin();
            nd.force(this.fdObj, metaData);
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <A> Future<FileLock> implLock(long position, long size, boolean shared, A attachment, CompletionHandler<FileLock, ? super A> handler) {
        if (shared && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!shared && !this.writing) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fli = this.addToFileLockTable(position, size, shared);
        if (fli == null) {
            ClosedChannelException exc = new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withFailure(exc);
            }
            Invoker.invoke(this, handler, attachment, null, exc);
            return null;
        }
        PendingFuture<FileLock, A> result = new PendingFuture<FileLock, A>(this, handler, attachment);
        LockTask<A> lockTask = new LockTask<A>(position, fli, result);
        result.setContext(lockTask);
        if (Iocp.supportsThreadAgnosticIo()) {
            lockTask.run();
        } else {
            boolean executed = false;
            try {
                Invoker.invokeOnThreadInThreadPool(this, lockTask);
                executed = true;
            }
            finally {
                if (!executed) {
                    this.removeFromFileLockTable(fli);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        if (shared && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!shared && !this.writing) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fli = this.addToFileLockTable(position, size, shared);
        if (fli == null) {
            throw new ClosedChannelException();
        }
        boolean gotLock = false;
        try {
            this.begin();
            int res = nd.lock(this.fdObj, false, position, size, shared);
            if (res == -1) {
                FileLock fileLock = null;
                return fileLock;
            }
            gotLock = true;
            FileLockImpl fileLockImpl = fli;
            return fileLockImpl;
        }
        finally {
            if (!gotLock) {
                this.removeFromFileLockTable(fli);
            }
            this.end();
        }
    }

    @Override
    protected void implRelease(FileLockImpl fli) throws IOException {
        nd.release(this.fdObj, fli.position(), fli.size());
    }

    @Override
    <A> Future<Integer> implRead(ByteBuffer dst, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        int rem;
        if (!this.reading) {
            throw new NonReadableChannelException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (!this.isOpen()) {
            ClosedChannelException exc = new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withFailure(exc);
            }
            Invoker.invoke(this, handler, attachment, null, exc);
            return null;
        }
        int pos = dst.position();
        int lim = dst.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (rem == 0) {
            if (handler == null) {
                return CompletedFuture.withResult(0);
            }
            Invoker.invoke(this, handler, attachment, 0, null);
            return null;
        }
        PendingFuture<Integer, A> result = new PendingFuture<Integer, A>(this, handler, attachment);
        ReadTask<A> readTask = new ReadTask<A>(dst, pos, rem, position, result);
        result.setContext(readTask);
        if (Iocp.supportsThreadAgnosticIo()) {
            readTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, readTask);
        }
        return result;
    }

    @Override
    <A> Future<Integer> implWrite(ByteBuffer src, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        int rem;
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.isOpen()) {
            ClosedChannelException exc = new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withFailure(exc);
            }
            Invoker.invoke(this, handler, attachment, null, exc);
            return null;
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (rem == 0) {
            if (handler == null) {
                return CompletedFuture.withResult(0);
            }
            Invoker.invoke(this, handler, attachment, 0, null);
            return null;
        }
        PendingFuture<Integer, A> result = new PendingFuture<Integer, A>(this, handler, attachment);
        WriteTask<A> writeTask = new WriteTask<A>(src, pos, rem, position, result);
        result.setContext(writeTask);
        if (Iocp.supportsThreadAgnosticIo()) {
            writeTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, writeTask);
        }
        return result;
    }

    private static native int readFile(long var0, long var2, int var4, long var5, long var7) throws IOException;

    private static native int writeFile(long var0, long var2, int var4, long var5, long var7) throws IOException;

    private static native int lockFile(long var0, long var2, long var4, boolean var6, long var7) throws IOException;

    private static native void close0(long var0);

    static {
        IOUtil.load();
    }

    private class WriteTask<A>
    implements Runnable,
    Iocp.ResultHandler {
        private final ByteBuffer src;
        private final int pos;
        private final int rem;
        private final long position;
        private final PendingFuture<Integer, A> result;
        private volatile ByteBuffer buf;

        WriteTask(ByteBuffer src, int pos, int rem, long position, PendingFuture<Integer, A> result) {
            this.src = src;
            this.pos = pos;
            this.rem = rem;
            this.position = position;
            this.result = result;
        }

        void releaseBufferIfSubstituted() {
            if (this.buf != this.src) {
                Util.releaseTemporaryDirectBuffer(this.buf);
            }
        }

        void updatePosition(int bytesTransferred) {
            if (bytesTransferred > 0) {
                try {
                    this.src.position(this.pos + bytesTransferred);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long overlapped;
            int n;
            block8: {
                long address;
                n = -1;
                overlapped = 0L;
                if (this.src instanceof DirectBuffer) {
                    this.buf = this.src;
                    address = ((DirectBuffer)((Object)this.src)).address() + (long)this.pos;
                } else {
                    this.buf = Util.getTemporaryDirectBuffer(this.rem);
                    this.buf.put(this.src);
                    this.buf.flip();
                    this.src.position(this.pos);
                    address = ((DirectBuffer)((Object)this.buf)).address();
                }
                WindowsAsynchronousFileChannelImpl.this.begin();
                overlapped = WindowsAsynchronousFileChannelImpl.this.ioCache.add(this.result);
                n = WindowsAsynchronousFileChannelImpl.writeFile(WindowsAsynchronousFileChannelImpl.this.handle, address, this.rem, this.position, overlapped);
                if (n != -2) break block8;
                WindowsAsynchronousFileChannelImpl.this.end();
                return;
            }
            try {
                try {
                    throw new InternalError("Unexpected result: " + n);
                }
                catch (Throwable x) {
                    this.result.setFailure(WindowsAsynchronousFileChannelImpl.toIOException(x));
                    if (overlapped != 0L) {
                        WindowsAsynchronousFileChannelImpl.this.ioCache.remove(overlapped);
                    }
                    this.releaseBufferIfSubstituted();
                    WindowsAsynchronousFileChannelImpl.this.end();
                }
            }
            catch (Throwable throwable) {
                WindowsAsynchronousFileChannelImpl.this.end();
                throw throwable;
            }
            Invoker.invoke(this.result);
        }

        @Override
        public void completed(int bytesTransferred, boolean canInvokeDirect) {
            this.updatePosition(bytesTransferred);
            this.releaseBufferIfSubstituted();
            this.result.setResult(bytesTransferred);
            if (canInvokeDirect) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        @Override
        public void failed(int error, IOException x) {
            this.releaseBufferIfSubstituted();
            if (WindowsAsynchronousFileChannelImpl.this.isOpen()) {
                this.result.setFailure(x);
            } else {
                this.result.setFailure(new AsynchronousCloseException());
            }
            Invoker.invoke(this.result);
        }
    }

    private class ReadTask<A>
    implements Runnable,
    Iocp.ResultHandler {
        private final ByteBuffer dst;
        private final int pos;
        private final int rem;
        private final long position;
        private final PendingFuture<Integer, A> result;
        private volatile ByteBuffer buf;

        ReadTask(ByteBuffer dst, int pos, int rem, long position, PendingFuture<Integer, A> result) {
            this.dst = dst;
            this.pos = pos;
            this.rem = rem;
            this.position = position;
            this.result = result;
        }

        void releaseBufferIfSubstituted() {
            if (this.buf != this.dst) {
                Util.releaseTemporaryDirectBuffer(this.buf);
            }
        }

        void updatePosition(int bytesTransferred) {
            if (bytesTransferred > 0) {
                if (this.buf == this.dst) {
                    try {
                        this.dst.position(this.pos + bytesTransferred);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    this.buf.position(bytesTransferred).flip();
                    try {
                        this.dst.put(this.buf);
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                long address;
                int n = -1;
                long overlapped = 0L;
                if (this.dst instanceof DirectBuffer) {
                    this.buf = this.dst;
                    address = ((DirectBuffer)((Object)this.dst)).address() + (long)this.pos;
                } else {
                    this.buf = Util.getTemporaryDirectBuffer(this.rem);
                    address = ((DirectBuffer)((Object)this.buf)).address();
                }
                boolean pending = false;
                try {
                    WindowsAsynchronousFileChannelImpl.this.begin();
                    overlapped = WindowsAsynchronousFileChannelImpl.this.ioCache.add(this.result);
                    n = WindowsAsynchronousFileChannelImpl.readFile(WindowsAsynchronousFileChannelImpl.this.handle, address, this.rem, this.position, overlapped);
                    if (n == -2) {
                        pending = true;
                        return;
                    }
                    if (n == -1) {
                        this.result.setResult(n);
                        break block12;
                    }
                    throw new InternalError("Unexpected result: " + n);
                }
                catch (Throwable x) {
                    this.result.setFailure(WindowsAsynchronousFileChannelImpl.toIOException(x));
                }
                finally {
                    if (!pending) {
                        if (overlapped != 0L) {
                            WindowsAsynchronousFileChannelImpl.this.ioCache.remove(overlapped);
                        }
                        this.releaseBufferIfSubstituted();
                    }
                    WindowsAsynchronousFileChannelImpl.this.end();
                }
            }
            Invoker.invoke(this.result);
        }

        @Override
        public void completed(int bytesTransferred, boolean canInvokeDirect) {
            this.updatePosition(bytesTransferred);
            this.releaseBufferIfSubstituted();
            this.result.setResult(bytesTransferred);
            if (canInvokeDirect) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        @Override
        public void failed(int error, IOException x) {
            if (error == 38) {
                this.completed(-1, false);
            } else {
                this.releaseBufferIfSubstituted();
                if (WindowsAsynchronousFileChannelImpl.this.isOpen()) {
                    this.result.setFailure(x);
                } else {
                    this.result.setFailure(new AsynchronousCloseException());
                }
                Invoker.invoke(this.result);
            }
        }
    }

    private class LockTask<A>
    implements Runnable,
    Iocp.ResultHandler {
        private final long position;
        private final FileLockImpl fli;
        private final PendingFuture<FileLock, A> result;

        LockTask(long position, FileLockImpl fli, PendingFuture<FileLock, A> result) {
            this.position = position;
            this.fli = fli;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long overlapped = 0L;
            boolean pending = false;
            try {
                WindowsAsynchronousFileChannelImpl.this.begin();
                overlapped = WindowsAsynchronousFileChannelImpl.this.ioCache.add(this.result);
                PendingFuture<FileLock, A> pendingFuture = this.result;
                synchronized (pendingFuture) {
                    block11: {
                        int n = WindowsAsynchronousFileChannelImpl.lockFile(WindowsAsynchronousFileChannelImpl.this.handle, this.position, this.fli.size(), this.fli.isShared(), overlapped);
                        if (n != -2) break block11;
                        pending = true;
                        return;
                    }
                    this.result.setResult(this.fli);
                }
            }
            catch (Throwable x) {
                WindowsAsynchronousFileChannelImpl.this.removeFromFileLockTable(this.fli);
                this.result.setFailure(WindowsAsynchronousFileChannelImpl.toIOException(x));
            }
            finally {
                if (!pending && overlapped != 0L) {
                    WindowsAsynchronousFileChannelImpl.this.ioCache.remove(overlapped);
                }
                WindowsAsynchronousFileChannelImpl.this.end();
            }
            Invoker.invoke(this.result);
        }

        @Override
        public void completed(int bytesTransferred, boolean canInvokeDirect) {
            this.result.setResult(this.fli);
            if (canInvokeDirect) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        @Override
        public void failed(int error, IOException x) {
            WindowsAsynchronousFileChannelImpl.this.removeFromFileLockTable(this.fli);
            if (WindowsAsynchronousFileChannelImpl.this.isOpen()) {
                this.result.setFailure(x);
            } else {
                this.result.setFailure(new AsynchronousCloseException());
            }
            Invoker.invoke(this.result);
        }
    }

    private static class DefaultIocpHolder {
        static final Iocp defaultIocp = DefaultIocpHolder.defaultIocp();

        private DefaultIocpHolder() {
        }

        private static Iocp defaultIocp() {
            try {
                return new Iocp(null, ThreadPool.createDefault()).start();
            }
            catch (IOException ioe) {
                throw new InternalError(ioe);
            }
        }
    }
}

