/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.HashMap;
import java.util.Map;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.ReplayCache;
import sun.security.krb5.internal.rcache.AuthList;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class MemoryCache
extends ReplayCache {
    private static final int lifespan = KerberosTime.getDefaultSkew();
    private static final boolean DEBUG = Krb5.DEBUG;
    private final Map<String, AuthList> content = new HashMap<String, AuthList>();

    @Override
    public synchronized void checkAndStore(KerberosTime currTime, AuthTimeWithHash time) throws KrbApErrException {
        String key = time.client + "|" + time.server;
        AuthList rc = this.content.get(key);
        if (DEBUG) {
            System.out.println("MemoryCache: add " + time + " to " + key);
        }
        if (rc == null) {
            rc = new AuthList(lifespan);
            rc.put(time, currTime);
            if (!rc.isEmpty()) {
                this.content.put(key, rc);
            }
        } else {
            if (DEBUG) {
                System.out.println("MemoryCache: Existing AuthList:\n" + rc);
            }
            rc.put(time, currTime);
            if (rc.isEmpty()) {
                this.content.remove(key);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AuthList rc : this.content.values()) {
            sb.append(rc.toString());
        }
        return sb.toString();
    }
}

