/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSPRequest;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

public final class OCSP {
    static final ObjectIdentifier NONCE_EXTENSION_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int CONNECT_TIMEOUT = OCSP.initializeTimeout();

    private static int initializeTimeout() {
        Integer tmp = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.timeout"));
        if (tmp == null || tmp < 0) {
            return 15000;
        }
        return tmp * 1000;
    }

    private OCSP() {
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert) throws IOException, CertPathValidatorException {
        CertId certId = null;
        URI responderURI = null;
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            responderURI = OCSP.getResponderURI(certImpl);
            if (responderURI == null) {
                throw new CertPathValidatorException("No OCSP Responder URI in certificate");
            }
            certId = new CertId(issuerCert, certImpl.getSerialNumberObject());
        }
        catch (IOException | CertificateException e) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", e);
        }
        OCSPResponse ocspResponse = OCSP.check(Collections.singletonList(certId), responderURI, issuerCert, null, null, Collections.emptyList());
        return ocspResponse.getSingleResponse(certId);
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert, URI responderURI, X509Certificate responderCert, Date date) throws IOException, CertPathValidatorException {
        return OCSP.check(cert, issuerCert, responderURI, responderCert, date, Collections.emptyList());
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert, URI responderURI, X509Certificate responderCert, Date date, List<Extension> extensions) throws IOException, CertPathValidatorException {
        CertId certId = null;
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            certId = new CertId(issuerCert, certImpl.getSerialNumberObject());
        }
        catch (IOException | CertificateException e) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", e);
        }
        OCSPResponse ocspResponse = OCSP.check(Collections.singletonList(certId), responderURI, issuerCert, responderCert, date, extensions);
        return ocspResponse.getSingleResponse(certId);
    }

    static OCSPResponse check(List<CertId> certIds, URI responderURI, X509Certificate issuerCert, X509Certificate responderCert, Date date, List<Extension> extensions) throws IOException, CertPathValidatorException {
        byte[] bytes = null;
        OCSPRequest request = null;
        try {
            request = new OCSPRequest(certIds, extensions);
            bytes = request.encodeBytes();
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ioe);
        }
        InputStream in = null;
        OutputStream out = null;
        byte[] response = null;
        try {
            int count;
            URL url = responderURI.toURL();
            if (debug != null) {
                debug.println("connecting to OCSP service at: " + url);
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(CONNECT_TIMEOUT);
            con.setReadTimeout(CONNECT_TIMEOUT);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            con.setRequestProperty("Content-length", String.valueOf(bytes.length));
            out = con.getOutputStream();
            out.write(bytes);
            out.flush();
            if (debug != null && con.getResponseCode() != 200) {
                debug.println("Received HTTP error: " + con.getResponseCode() + " - " + con.getResponseMessage());
            }
            in = con.getInputStream();
            int contentLength = con.getContentLength();
            if (contentLength == -1) {
                contentLength = Integer.MAX_VALUE;
            }
            response = new byte[contentLength > 2048 ? 2048 : contentLength];
            int total = 0;
            while (total < contentLength && (count = in.read(response, total, response.length - total)) >= 0) {
                if ((total += count) < response.length || total >= contentLength) continue;
                response = Arrays.copyOf(response, total * 2);
            }
            response = Arrays.copyOf(response, total);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Unable to determine revocation status due to network error", ioe, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        OCSPResponse ocspResponse = null;
        try {
            ocspResponse = new OCSPResponse(response);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException(ioe);
        }
        ocspResponse.verify(certIds, issuerCert, responderCert, date, request.getNonce());
        return ocspResponse;
    }

    public static URI getResponderURI(X509Certificate cert) {
        try {
            return OCSP.getResponderURI(X509CertImpl.toImpl(cert));
        }
        catch (CertificateException ce) {
            return null;
        }
    }

    static URI getResponderURI(X509CertImpl certImpl) {
        AuthorityInfoAccessExtension aia = certImpl.getAuthorityInfoAccessExtension();
        if (aia == null) {
            return null;
        }
        List<AccessDescription> descriptions = aia.getAccessDescriptions();
        for (AccessDescription description : descriptions) {
            GeneralName generalName;
            if (!description.getAccessMethod().equals((Object)AccessDescription.Ad_OCSP_Id) || (generalName = description.getAccessLocation()).getType() != 6) continue;
            URIName uri = (URIName)generalName.getName();
            return uri.getURI();
        }
        return null;
    }

    public static interface RevocationStatus {
        public CertStatus getCertStatus();

        public Date getRevocationTime();

        public CRLReason getRevocationReason();

        public Map<String, Extension> getSingleExtensions();

        public static enum CertStatus {
            GOOD,
            REVOKED,
            UNKNOWN;

        }
    }
}

