/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import sun.security.action.GetPropertyAction;
import sun.security.tools.policytool.CancelButtonListener;
import sun.security.tools.policytool.ErrorOKButtonListener;
import sun.security.tools.policytool.FileMenuListener;
import sun.security.tools.policytool.MainWindowListener;
import sun.security.tools.policytool.NoDisplayException;
import sun.security.tools.policytool.PolicyEntry;
import sun.security.tools.policytool.PolicyListListener;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.StatusOKButtonListener;
import sun.security.tools.policytool.ToolDialog;
import sun.security.tools.policytool.ToolWindowListener;

class ToolWindow
extends JFrame {
    private static final long serialVersionUID = 5682568601210376777L;
    static final KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
    public static final Insets TOP_PADDING = new Insets(25, 0, 0, 0);
    public static final Insets BOTTOM_PADDING = new Insets(0, 0, 25, 0);
    public static final Insets LITE_BOTTOM_PADDING = new Insets(0, 0, 10, 0);
    public static final Insets LR_PADDING = new Insets(0, 10, 0, 10);
    public static final Insets TOP_BOTTOM_PADDING = new Insets(15, 0, 15, 0);
    public static final Insets L_TOP_BOTTOM_PADDING = new Insets(5, 10, 15, 0);
    public static final Insets LR_TOP_BOTTOM_PADDING = new Insets(15, 4, 15, 4);
    public static final Insets LR_BOTTOM_PADDING = new Insets(0, 10, 5, 10);
    public static final Insets L_BOTTOM_PADDING = new Insets(0, 10, 5, 0);
    public static final Insets R_BOTTOM_PADDING = new Insets(0, 0, 25, 5);
    public static final Insets R_PADDING = new Insets(0, 0, 0, 5);
    public static final String NEW_POLICY_FILE = "New";
    public static final String OPEN_POLICY_FILE = "Open";
    public static final String SAVE_POLICY_FILE = "Save";
    public static final String SAVE_AS_POLICY_FILE = "Save.As";
    public static final String VIEW_WARNINGS = "View.Warning.Log";
    public static final String QUIT = "Exit";
    public static final String ADD_POLICY_ENTRY = "Add.Policy.Entry";
    public static final String EDIT_POLICY_ENTRY = "Edit.Policy.Entry";
    public static final String REMOVE_POLICY_ENTRY = "Remove.Policy.Entry";
    public static final String EDIT_KEYSTORE = "Edit";
    public static final String ADD_PUBKEY_ALIAS = "Add.Public.Key.Alias";
    public static final String REMOVE_PUBKEY_ALIAS = "Remove.Public.Key.Alias";
    public static final int MW_FILENAME_LABEL = 0;
    public static final int MW_FILENAME_TEXTFIELD = 1;
    public static final int MW_PANEL = 2;
    public static final int MW_ADD_BUTTON = 0;
    public static final int MW_EDIT_BUTTON = 1;
    public static final int MW_REMOVE_BUTTON = 2;
    public static final int MW_POLICY_LIST = 3;
    static final int TEXTFIELD_HEIGHT = new JComboBox<E>().getPreferredSize().height;
    private PolicyTool tool;
    private int shortCutModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    ToolWindow(PolicyTool tool) {
        this.tool = tool;
    }

    @Override
    public Component getComponent(int n) {
        Component c = this.getContentPane().getComponent(n);
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getView();
        }
        return c;
    }

    private void initWindow() {
        this.setDefaultCloseOperation(0);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu();
        ToolWindow.configureButton(menu, "File");
        ActionListener actionListener = new FileMenuListener(this.tool, this);
        this.addMenuItem(menu, NEW_POLICY_FILE, actionListener, "N");
        this.addMenuItem(menu, OPEN_POLICY_FILE, actionListener, "O");
        this.addMenuItem(menu, SAVE_POLICY_FILE, actionListener, "S");
        this.addMenuItem(menu, SAVE_AS_POLICY_FILE, actionListener, null);
        this.addMenuItem(menu, VIEW_WARNINGS, actionListener, null);
        this.addMenuItem(menu, QUIT, actionListener, null);
        menuBar.add(menu);
        menu = new JMenu();
        ToolWindow.configureButton(menu, "KeyStore");
        actionListener = new MainWindowListener(this.tool, this);
        this.addMenuItem(menu, EDIT_KEYSTORE, actionListener, null);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(6, 6, 6, 6));
        JLabel label = new JLabel(PolicyTool.getMessage("Policy.File."));
        this.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, LR_TOP_BOTTOM_PADDING);
        JTextField tf = new JTextField(50);
        tf.setPreferredSize(new Dimension(tf.getPreferredSize().width, TEXTFIELD_HEIGHT));
        tf.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Policy.File."));
        tf.setEditable(false);
        this.addNewComponent(this, tf, 1, 1, 0, 1, 1, 0.0, 0.0, 1, LR_TOP_BOTTOM_PADDING);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton button = new JButton();
        ToolWindow.configureButton(button, ADD_POLICY_ENTRY);
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        button = new JButton();
        ToolWindow.configureButton(button, EDIT_POLICY_ENTRY);
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 1, 1, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        button = new JButton();
        ToolWindow.configureButton(button, REMOVE_POLICY_ENTRY);
        button.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(panel, button, 2, 2, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        this.addNewComponent(this, panel, 2, 0, 2, 2, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        String policyFile = this.tool.getPolicyFileName();
        if (policyFile == null) {
            String userHome = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            policyFile = userHome + File.separatorChar + ".java.policy";
        }
        try {
            this.tool.openPolicy(policyFile);
            DefaultListModel<String> listModel = new DefaultListModel<String>();
            JList list = new JList(listModel);
            list.setVisibleRowCount(15);
            list.setSelectionMode(0);
            list.addMouseListener(new PolicyListListener(this.tool, this));
            PolicyEntry[] entries = this.tool.getEntry();
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    listModel.addElement(entries[i].headerToString());
                }
            }
            JTextField newFilename = (JTextField)this.getComponent(1);
            newFilename.setText(policyFile);
            this.initPolicyList(list);
        }
        catch (FileNotFoundException fnfe) {
            JList list = new JList(new DefaultListModel());
            list.setVisibleRowCount(15);
            list.setSelectionMode(0);
            list.addMouseListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(list);
            this.tool.setPolicyFileName(null);
            this.tool.modified = false;
            this.tool.warnings.addElement(fnfe.toString());
        }
        catch (Exception e) {
            JList list = new JList(new DefaultListModel());
            list.setVisibleRowCount(15);
            list.setSelectionMode(0);
            list.addMouseListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(list);
            this.tool.setPolicyFileName(null);
            this.tool.modified = false;
            MessageFormat form = new MessageFormat(PolicyTool.getMessage("Could.not.open.policy.file.policyFile.e.toString."));
            Object[] source = new Object[]{policyFile, e.toString()};
            this.displayErrorDialog(null, form.format(source));
        }
    }

    private void addMenuItem(JMenu menu, String key, ActionListener actionListener, String accelerator) {
        JMenuItem menuItem = new JMenuItem();
        ToolWindow.configureButton(menuItem, key);
        if (PolicyTool.rb.containsKey(key + ".accelerator")) {
            accelerator = PolicyTool.getMessage(key + ".accelerator");
        }
        if (accelerator != null && !accelerator.isEmpty()) {
            KeyStroke keyStroke = accelerator.length() == 1 ? KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(accelerator.charAt(0)), this.shortCutModifier) : KeyStroke.getKeyStroke(accelerator);
            menuItem.setAccelerator(keyStroke);
        }
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
    }

    static void configureButton(AbstractButton button, String key) {
        button.setText(PolicyTool.getMessage(key));
        button.setActionCommand(key);
        int mnemonicInt = PolicyTool.getMnemonicInt(key);
        if (mnemonicInt > 0) {
            button.setMnemonic(mnemonicInt);
            button.setDisplayedMnemonicIndex(PolicyTool.getDisplayedMnemonicIndex(key));
        }
    }

    static void configureLabelFor(JLabel label, JComponent component, String key) {
        label.setText(PolicyTool.getMessage(key));
        label.setLabelFor(component);
        int mnemonicInt = PolicyTool.getMnemonicInt(key);
        if (mnemonicInt > 0) {
            label.setDisplayedMnemonic(mnemonicInt);
            label.setDisplayedMnemonicIndex(PolicyTool.getDisplayedMnemonicIndex(key));
        }
    }

    void addNewComponent(Container container, JComponent component, int index, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill, Insets is) {
        if (container instanceof JFrame) {
            container = ((JFrame)container).getContentPane();
        } else if (container instanceof JDialog) {
            container = ((JDialog)container).getContentPane();
        }
        container.add((Component)component, index);
        GridBagLayout gbl = (GridBagLayout)container.getLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.fill = fill;
        if (is != null) {
            gbc.insets = is;
        }
        gbl.setConstraints(component, gbc);
    }

    void addNewComponent(Container container, JComponent component, int index, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill) {
        this.addNewComponent(container, component, index, gridx, gridy, gridwidth, gridheight, weightx, weighty, fill, null);
    }

    void initPolicyList(JList policyList) {
        JScrollPane scrollPane = new JScrollPane(policyList);
        this.addNewComponent(this, scrollPane, 3, 0, 3, 2, 1, 1.0, 1.0, 1);
    }

    void replacePolicyList(JList policyList) {
        JList list = (JList)this.getComponent(3);
        list.setModel(policyList.getModel());
    }

    void displayToolWindow(String[] args) {
        this.setTitle(PolicyTool.getMessage("Policy.Tool"));
        this.setResizable(true);
        this.addWindowListener(new ToolWindowListener(this.tool, this));
        this.getContentPane().setLayout(new GridBagLayout());
        this.initWindow();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        if (this.tool.newWarning) {
            this.displayStatusDialog(this, PolicyTool.getMessage("Errors.have.occurred.while.opening.the.policy.configuration.View.the.Warning.Log.for.more.information."));
        }
    }

    void displayErrorDialog(Window w, String error) {
        ToolDialog ed = new ToolDialog(PolicyTool.getMessage("Error"), this.tool, this, true);
        Point location = w == null ? this.getLocationOnScreen() : w.getLocationOnScreen();
        ed.setLayout(new GridBagLayout());
        JLabel label = new JLabel(error);
        this.addNewComponent(ed, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        JButton okButton = new JButton(PolicyTool.getMessage("OK"));
        ErrorOKButtonListener okListener = new ErrorOKButtonListener(ed);
        okButton.addActionListener(okListener);
        this.addNewComponent(ed, okButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        ed.getRootPane().setDefaultButton(okButton);
        ed.getRootPane().registerKeyboardAction(okListener, escKey, 2);
        ed.pack();
        ed.setLocationRelativeTo(w);
        ed.setVisible(true);
    }

    void displayErrorDialog(Window w, Throwable t) {
        if (t instanceof NoDisplayException) {
            return;
        }
        this.displayErrorDialog(w, t.toString());
    }

    void displayStatusDialog(Window w, String status) {
        ToolDialog sd = new ToolDialog(PolicyTool.getMessage("Status"), this.tool, this, true);
        Point location = w == null ? this.getLocationOnScreen() : w.getLocationOnScreen();
        sd.setLayout(new GridBagLayout());
        JLabel label = new JLabel(status);
        this.addNewComponent(sd, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        JButton okButton = new JButton(PolicyTool.getMessage("OK"));
        StatusOKButtonListener okListener = new StatusOKButtonListener(sd);
        okButton.addActionListener(okListener);
        this.addNewComponent(sd, okButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        sd.getRootPane().setDefaultButton(okButton);
        sd.getRootPane().registerKeyboardAction(okListener, escKey, 2);
        sd.pack();
        sd.setLocationRelativeTo(w);
        sd.setVisible(true);
    }

    void displayWarningLog(Window w) {
        ToolDialog wd = new ToolDialog(PolicyTool.getMessage("Warning"), this.tool, this, true);
        Point location = w == null ? this.getLocationOnScreen() : w.getLocationOnScreen();
        wd.setLayout(new GridBagLayout());
        JTextArea ta = new JTextArea();
        ta.setEditable(false);
        for (int i = 0; i < this.tool.warnings.size(); ++i) {
            ta.append(this.tool.warnings.elementAt(i));
            ta.append(PolicyTool.getMessage("NEWLINE"));
        }
        this.addNewComponent(wd, ta, 0, 0, 0, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        ta.setFocusable(false);
        JButton okButton = new JButton(PolicyTool.getMessage("OK"));
        CancelButtonListener okListener = new CancelButtonListener(wd);
        okButton.addActionListener(okListener);
        this.addNewComponent(wd, okButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        wd.getRootPane().setDefaultButton(okButton);
        wd.getRootPane().registerKeyboardAction(okListener, escKey, 2);
        wd.pack();
        wd.setLocationRelativeTo(w);
        wd.setVisible(true);
    }

    char displayYesNoDialog(Window w, String title, String prompt, String yes, String no) {
        final ToolDialog tw = new ToolDialog(title, this.tool, this, true);
        Point location = w == null ? this.getLocationOnScreen() : w.getLocationOnScreen();
        tw.setLayout(new GridBagLayout());
        JTextArea ta = new JTextArea(prompt, 10, 50);
        ta.setEditable(false);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(ta, 20, 31);
        this.addNewComponent(tw, scrollPane, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        ta.setFocusable(false);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        final StringBuffer chooseResult = new StringBuffer();
        JButton button = new JButton(yes);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooseResult.append('Y');
                tw.setVisible(false);
                tw.dispose();
            }
        });
        this.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        button = new JButton(no);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooseResult.append('N');
                tw.setVisible(false);
                tw.dispose();
            }
        });
        this.addNewComponent(panel, button, 1, 1, 0, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        this.addNewComponent(tw, panel, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        tw.pack();
        tw.setLocationRelativeTo(w);
        tw.setVisible(true);
        if (chooseResult.length() > 0) {
            return chooseResult.charAt(0);
        }
        return 'N';
    }
}

