/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.ProviderException;
import java.security.interfaces.DSAParams;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class AlgIdDSA
extends AlgorithmId
implements DSAParams {
    private static final long serialVersionUID = 3437177836797504046L;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    @Override
    public BigInteger getP() {
        return this.p;
    }

    @Override
    public BigInteger getQ() {
        return this.q;
    }

    @Override
    public BigInteger getG() {
        return this.g;
    }

    @Deprecated
    public AlgIdDSA() {
    }

    AlgIdDSA(DerValue val) throws IOException {
        super(val.getOID());
    }

    public AlgIdDSA(byte[] encodedAlg) throws IOException {
        super(new DerValue(encodedAlg).getOID());
    }

    public AlgIdDSA(byte[] p, byte[] q, byte[] g) throws IOException {
        this(new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, g));
    }

    public AlgIdDSA(BigInteger p, BigInteger q, BigInteger g) {
        super(DSA_oid);
        if (p != null || q != null || g != null) {
            if (p == null || q == null || g == null) {
                throw new ProviderException("Invalid parameters for DSS/DSA Algorithm ID");
            }
            try {
                this.p = p;
                this.q = q;
                this.g = g;
                this.initializeParams();
            }
            catch (IOException e) {
                throw new ProviderException("Construct DSS/DSA Algorithm ID");
            }
        }
    }

    @Override
    public String getName() {
        return "DSA";
    }

    private void initializeParams() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putInteger(this.p);
        out.putInteger(this.q);
        out.putInteger(this.g);
        this.params = new DerValue(48, out.toByteArray());
    }

    @Override
    protected void decodeParams() throws IOException {
        if (this.params == null) {
            throw new IOException("DSA alg params are null");
        }
        if (this.params.tag != 48) {
            throw new IOException("DSA alg parsing error");
        }
        this.params.data.reset();
        this.p = this.params.data.getBigInteger();
        this.q = this.params.data.getBigInteger();
        this.g = this.params.data.getBigInteger();
        if (this.params.data.available() != 0) {
            throw new IOException("AlgIdDSA params, extra=" + this.params.data.available());
        }
    }

    @Override
    public String toString() {
        return this.paramsToString();
    }

    @Override
    protected String paramsToString() {
        if (this.params == null) {
            return " null\n";
        }
        return "\n    p:\n" + Debug.toHexString(this.p) + "\n    q:\n" + Debug.toHexString(this.q) + "\n    g:\n" + Debug.toHexString(this.g) + "\n";
    }
}

