/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.util.Calendar;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.spi.CalendarProvider;

public class CalendarProviderImpl
extends CalendarProvider
implements AvailableLanguageTags {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public CalendarProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        this.type = type;
        this.langtags = langtags;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return true;
    }

    @Override
    public Calendar getInstance(TimeZone zone, Locale locale) {
        return new Calendar.Builder().setLocale(locale).setTimeZone(zone).setInstant(System.currentTimeMillis()).build();
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }
}

