/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamControllerActionSetHandle;
import com.codedisaster.steamworks.SteamControllerAnalogActionData;
import com.codedisaster.steamworks.SteamControllerAnalogActionHandle;
import com.codedisaster.steamworks.SteamControllerDigitalActionData;
import com.codedisaster.steamworks.SteamControllerDigitalActionHandle;
import com.codedisaster.steamworks.SteamControllerHandle;
import com.codedisaster.steamworks.SteamControllerMotionData;
import com.codedisaster.steamworks.SteamInterface;

public class SteamController
extends SteamInterface {
    public static final int STEAM_CONTROLLER_MAX_COUNT = 16;
    public static final int STEAM_CONTROLLER_MAX_ANALOG_ACTIONS = 16;
    public static final int STEAM_CONTROLLER_MAX_DIGITAL_ACTIONS = 128;
    public static final int STEAM_CONTROLLER_MAX_ORIGINS = 8;
    public static final long STEAM_CONTROLLER_HANDLE_ALL_CONTROLLERS = -1L;
    public static final float STEAM_CONTROLLER_MIN_ANALOG_ACTION_DATA = -1.0f;
    public static final float STEAM_CONTROLLER_MAX_ANALOG_ACTION_DATA = 1.0f;
    private long[] controllerHandles = new long[16];
    private int[] actionOrigins = new int[8];

    public SteamController() {
        super(SteamAPI.getSteamControllerPointer());
    }

    public boolean init() {
        return SteamController.init(this.pointer);
    }

    public boolean shutdown() {
        return SteamController.shutdown(this.pointer);
    }

    public void runFrame() {
        SteamController.runFrame(this.pointer);
    }

    public int getConnectedControllers(SteamControllerHandle[] handlesOut) {
        if (handlesOut.length < 16) {
            throw new IllegalArgumentException("Array size must be at least STEAM_CONTROLLER_MAX_COUNT");
        }
        int count = SteamController.getConnectedControllers(this.pointer, this.controllerHandles);
        for (int i = 0; i < count; ++i) {
            handlesOut[i] = new SteamControllerHandle(this.controllerHandles[i]);
        }
        return count;
    }

    public boolean showBindingPanel(SteamControllerHandle controller) {
        return SteamController.showBindingPanel(this.pointer, controller.handle);
    }

    public SteamControllerActionSetHandle getActionSetHandle(String actionSetName) {
        return new SteamControllerActionSetHandle(SteamController.getActionSetHandle(this.pointer, actionSetName));
    }

    public void activateActionSet(SteamControllerHandle controller, SteamControllerActionSetHandle actionSet) {
        SteamController.activateActionSet(this.pointer, controller.handle, actionSet.handle);
    }

    public SteamControllerActionSetHandle getCurrentActionSet(SteamControllerHandle controller) {
        return new SteamControllerActionSetHandle(SteamController.getCurrentActionSet(this.pointer, controller.handle));
    }

    public SteamControllerDigitalActionHandle getDigitalActionHandle(String actionName) {
        return new SteamControllerDigitalActionHandle(SteamController.getDigitalActionHandle(this.pointer, actionName));
    }

    public void getDigitalActionData(SteamControllerHandle controller, SteamControllerDigitalActionHandle digitalAction, SteamControllerDigitalActionData digitalActionData) {
        SteamController.getDigitalActionData(this.pointer, controller.handle, digitalAction.handle, digitalActionData);
    }

    public int getDigitalActionOrigins(SteamControllerHandle controller, SteamControllerActionSetHandle actionSet, SteamControllerDigitalActionHandle digitalAction, ActionOrigin[] originsOut) {
        if (originsOut.length < 8) {
            throw new IllegalArgumentException("Array size must be at least STEAM_CONTROLLER_MAX_ORIGINS");
        }
        int count = SteamController.getDigitalActionOrigins(this.pointer, controller.handle, actionSet.handle, digitalAction.handle, this.actionOrigins);
        for (int i = 0; i < count; ++i) {
            originsOut[i] = ActionOrigin.byOrdinal(this.actionOrigins[i]);
        }
        return count;
    }

    public SteamControllerAnalogActionHandle getAnalogActionHandle(String actionName) {
        return new SteamControllerAnalogActionHandle(SteamController.getAnalogActionHandle(this.pointer, actionName));
    }

    public void getAnalogActionData(SteamControllerHandle controller, SteamControllerAnalogActionHandle analogAction, SteamControllerAnalogActionData analoglActionData) {
        SteamController.getAnalogActionData(this.pointer, controller.handle, analogAction.handle, analoglActionData);
    }

    public int getAnalogActionOrigins(SteamControllerHandle controller, SteamControllerActionSetHandle actionSet, SteamControllerAnalogActionHandle analogAction, ActionOrigin[] originsOut) {
        if (originsOut.length < 8) {
            throw new IllegalArgumentException("Array size must be at least STEAM_CONTROLLER_MAX_ORIGINS");
        }
        int count = SteamController.getAnalogActionOrigins(this.pointer, controller.handle, actionSet.handle, analogAction.handle, this.actionOrigins);
        for (int i = 0; i < count; ++i) {
            originsOut[i] = ActionOrigin.byOrdinal(this.actionOrigins[i]);
        }
        return count;
    }

    public void stopAnalogActionMomentum(SteamControllerHandle controller, SteamControllerAnalogActionHandle analogAction) {
        SteamController.stopAnalogActionMomentum(this.pointer, controller.handle, analogAction.handle);
    }

    public void triggerHapticPulse(SteamControllerHandle controller, Pad targetPad, int durationMicroSec) {
        SteamController.triggerHapticPulse(this.pointer, controller.handle, targetPad.ordinal(), durationMicroSec);
    }

    public void triggerRepeatedHapticPulse(SteamControllerHandle controller, Pad targetPad, int durationMicroSec, int offMicroSec, int repeat, int flags) {
        SteamController.triggerRepeatedHapticPulse(this.pointer, controller.handle, targetPad.ordinal(), durationMicroSec, offMicroSec, repeat, flags);
    }

    public int getGamepadIndexForController(SteamControllerHandle controller) {
        return SteamController.getGamepadIndexForController(this.pointer, controller.handle);
    }

    public SteamControllerHandle getControllerForGamepadIndex(int index) {
        return new SteamControllerHandle(SteamController.getControllerForGamepadIndex(this.pointer, index));
    }

    public void getMotionData(SteamControllerHandle controller, SteamControllerMotionData motionData) {
        SteamController.getMotionData(this.pointer, controller.handle, motionData.data);
    }

    public boolean showDigitalActionOrigins(SteamControllerHandle controller, SteamControllerDigitalActionHandle digitalActionHandle, float scale, float xPosition, float yPosition) {
        return SteamController.showDigitalActionOrigins(this.pointer, controller.handle, digitalActionHandle.handle, scale, xPosition, yPosition);
    }

    public boolean showAnalogActionOrigins(SteamControllerHandle controller, SteamControllerAnalogActionHandle analogActionHandle, float scale, float xPosition, float yPosition) {
        return SteamController.showAnalogActionOrigins(this.pointer, controller.handle, analogActionHandle.handle, scale, xPosition, yPosition);
    }

    private static native boolean init(long var0);

    private static native boolean shutdown(long var0);

    private static native void runFrame(long var0);

    private static native int getConnectedControllers(long var0, long[] var2);

    private static native boolean showBindingPanel(long var0, long var2);

    private static native long getActionSetHandle(long var0, String var2);

    private static native void activateActionSet(long var0, long var2, long var4);

    private static native long getCurrentActionSet(long var0, long var2);

    private static native long getDigitalActionHandle(long var0, String var2);

    private static native void getDigitalActionData(long var0, long var2, long var4, SteamControllerDigitalActionData var6);

    private static native int getDigitalActionOrigins(long var0, long var2, long var4, long var6, int[] var8);

    private static native long getAnalogActionHandle(long var0, String var2);

    private static native void getAnalogActionData(long var0, long var2, long var4, SteamControllerAnalogActionData var6);

    private static native int getAnalogActionOrigins(long var0, long var2, long var4, long var6, int[] var8);

    private static native void stopAnalogActionMomentum(long var0, long var2, long var4);

    private static native void triggerHapticPulse(long var0, long var2, int var4, int var5);

    private static native void triggerRepeatedHapticPulse(long var0, long var2, int var4, int var5, int var6, int var7, int var8);

    private static native int getGamepadIndexForController(long var0, long var2);

    private static native long getControllerForGamepadIndex(long var0, int var2);

    private static native void getMotionData(long var0, long var2, float[] var4);

    private static native boolean showDigitalActionOrigins(long var0, long var2, long var4, float var6, float var7, float var8);

    private static native boolean showAnalogActionOrigins(long var0, long var2, long var4, float var6, float var7, float var8);

    public static enum ActionOrigin {
        None,
        A,
        B,
        X,
        Y,
        LeftBumper,
        RightBumper,
        LeftGrip,
        RightGrip,
        Start,
        Back,
        LeftPad_Touch,
        LeftPad_Swipe,
        LeftPad_Click,
        LeftPad_DPadNorth,
        LeftPad_DPadSouth,
        LeftPad_DPadWest,
        LeftPad_DPadEast,
        RightPad_Touch,
        RightPad_Swipe,
        RightPad_Click,
        RightPad_DPadNorth,
        RightPad_DPadSouth,
        RightPad_DPadWest,
        RightPad_DPadEast,
        LeftTrigger_Pull,
        LeftTrigger_Click,
        RightTrigger_Pull,
        RightTrigger_Click,
        LeftStick_Move,
        LeftStick_Click,
        LeftStick_DPadNorth,
        LeftStick_DPadSouth,
        LeftStick_DPadWest,
        LeftStick_DPadEast,
        Gyro_Move,
        Gyro_Pitch,
        Gyro_Yaw,
        Gyro_Roll;

        private static final ActionOrigin[] values;

        static ActionOrigin byOrdinal(int ordinal) {
            return values[ordinal];
        }

        static {
            values = ActionOrigin.values();
        }
    }

    public static enum SourceMode {
        None,
        Dpad,
        Buttons,
        FourButtons,
        AbsoluteMouse,
        RelativeMouse,
        JoystickMove,
        JoystickCamera,
        ScrollWheel,
        Trigger,
        TouchMenu,
        MouseJoystick,
        MouseRegion,
        RadialMenu,
        Switches;

        private static final SourceMode[] values;

        static SourceMode byOrdinal(int ordinal) {
            return values[ordinal];
        }

        static {
            values = SourceMode.values();
        }
    }

    public static enum Source {
        None,
        LeftTrackpad,
        RightTrackpad,
        Joystick,
        ABXY,
        Switch,
        LeftTrigger,
        RightTrigger,
        Gyro;

    }

    public static enum Pad {
        Left,
        Right;

    }
}

