/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class SteamSharedLibraryLoader {
    private final String libraryPath;
    static boolean alreadyLoaded = false;
    static File librarySystemPath;
    private static final String extractSubFolder = "steamworks4j/";

    private SteamSharedLibraryLoader(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    private String getLibNameWindows(String sharedLibName, boolean is64Bit) {
        return sharedLibName + (is64Bit ? "64" : "") + ".dll";
    }

    private String getLibNameLinux(String sharedLibName, boolean is64Bit) {
        return "lib" + sharedLibName + (is64Bit ? "64" : "") + ".so";
    }

    private String getLibNameMac(String sharedLibName) {
        return "lib" + sharedLibName + ".dylib";
    }

    private void loadLibraries(String ... libraryNames) throws IOException {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        boolean isWindows = osName.contains("Windows");
        boolean isLinux = osName.contains("Linux");
        boolean isMac = osName.contains("Mac");
        boolean is64Bit = osArch.equals("amd64") || osArch.equals("x86_64");
        String[] librarySystemNames = new String[libraryNames.length];
        for (int i = 0; i < libraryNames.length; ++i) {
            if (isWindows) {
                librarySystemNames[i] = this.getLibNameWindows(libraryNames[i], is64Bit);
                continue;
            }
            if (isLinux) {
                librarySystemNames[i] = this.getLibNameLinux(libraryNames[i], is64Bit);
                continue;
            }
            if (isMac) {
                librarySystemNames[i] = this.getLibNameMac(libraryNames[i]);
                continue;
            }
            throw new IOException("Unrecognized system architecture: " + osName + ", " + osArch);
        }
        if (this.libraryPath == null) {
            String libraryCrc = ".nohash";
            CRC32 crc = new CRC32();
            for (String librarySystemName : librarySystemNames) {
                libraryCrc = this.crc(crc, this.getClass().getResourceAsStream("/" + librarySystemName));
            }
            librarySystemPath = SteamSharedLibraryLoader.discoverExtractLocation(extractSubFolder + libraryCrc, UUID.randomUUID().toString());
            if (librarySystemPath == null) {
                throw new IOException("Failed to create temp folder to extract native libraries");
            }
            librarySystemPath = librarySystemPath.getParentFile();
        } else {
            librarySystemPath = new File(this.libraryPath);
        }
        for (String librarySystemName : librarySystemNames) {
            String fullPath = this.libraryPath == null ? this.extractLibrary(librarySystemPath, librarySystemName) : librarySystemPath + "/" + librarySystemName;
            String absolutePath = new File(fullPath).getCanonicalPath();
            System.load(absolutePath);
        }
    }

    private String extractLibrary(File nativesPath, String sharedLibName) throws IOException {
        int length;
        InputStream input;
        File nativeFile = new File(nativesPath, sharedLibName);
        ZipFile zip = null;
        if (this.libraryPath != null) {
            zip = new ZipFile(this.libraryPath);
            ZipEntry entry = zip.getEntry(sharedLibName);
            input = zip.getInputStream(entry);
        } else {
            input = SteamSharedLibraryLoader.class.getResourceAsStream("/" + sharedLibName);
        }
        if (input == null) {
            throw new IOException("Error extracting " + sharedLibName + " from " + (this.libraryPath != null ? this.libraryPath : "resources"));
        }
        FileOutputStream output = new FileOutputStream(nativeFile);
        byte[] buffer = new byte[4096];
        while ((length = input.read(buffer)) != -1) {
            output.write(buffer, 0, length);
        }
        output.close();
        input.close();
        if (zip != null) {
            zip.close();
        }
        return nativeFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String crc(CRC32 crc, InputStream input) {
        byte[] buffer = new byte[4096];
        try {
            int length;
            while ((length = input.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return Long.toHexString(crc.getValue());
    }

    static boolean loadLibraries(String libraryPath) throws SteamException {
        if (alreadyLoaded) {
            return true;
        }
        SteamSharedLibraryLoader loader = new SteamSharedLibraryLoader(libraryPath);
        try {
            loader.loadLibraries("steam_api", "steamworks4j");
        }
        catch (Throwable t) {
            throw new SteamException(t);
        }
        alreadyLoaded = true;
        return true;
    }

    private static File discoverExtractLocation(String folderName, String fileName) {
        File path = new File(System.getProperty("java.io.tmpdir") + "/" + folderName, fileName);
        if (SteamSharedLibraryLoader.canWrite(path)) {
            return path;
        }
        try {
            File file = File.createTempFile(folderName, null);
            if (file.delete() && SteamSharedLibraryLoader.canWrite(path = new File(file, fileName))) {
                return path;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        path = new File(System.getProperty("user.home") + "/." + folderName, fileName);
        if (SteamSharedLibraryLoader.canWrite(path)) {
            return path;
        }
        path = new File(".tmp/" + folderName, fileName);
        if (SteamSharedLibraryLoader.canWrite(path)) {
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File file) {
        File folder = file.getParentFile();
        if (file.exists()) {
            if (!file.canWrite() || !SteamSharedLibraryLoader.canExecute(file)) {
                return false;
            }
        } else {
            if (!folder.exists() && !folder.mkdirs()) {
                return false;
            }
            if (!folder.isDirectory()) {
                return false;
            }
        }
        File testFile = new File(folder, UUID.randomUUID().toString());
        try {
            new FileOutputStream(testFile).close();
            boolean bl = SteamSharedLibraryLoader.canExecute(testFile);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            testFile.delete();
        }
    }

    private static boolean canExecute(File file) {
        try {
            if (file.canExecute()) {
                return true;
            }
            if (file.setExecutable(true)) {
                return file.canExecute();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

