/*
 * Decompiled with CFR 0.152.
 */
package controller.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.Design;
import simulator.Parser;

public class DesignRepo {
    public static Map<String, Design> designMap = new HashMap<String, Design>();
    public static Map<String, Integer> statsMap = new HashMap<String, Integer>();
    public static Map<String, String> altImplMap = new HashMap<String, String>();
    public static Map<String, List<String>> dependencyMap = new HashMap<String, List<String>>();

    public static boolean addDesign(Design d) {
        if (designMap.containsKey(d.name)) {
            return false;
        }
        designMap.put(d.name, d);
        return true;
    }

    public static void calcStatsAndDependencies(Design d) {
        String deviceType;
        switch (deviceType = d.name) {
            case "NAND4B": {
                dependencyMap.put(deviceType, Arrays.asList("NAND"));
                break;
            }
            case "NAND16B": {
                dependencyMap.put(deviceType, Arrays.asList("NAND4B"));
                break;
            }
            case "NOT16B": {
                dependencyMap.put(deviceType, Arrays.asList("NOT4B"));
                break;
            }
            case "AND16B": {
                dependencyMap.put(deviceType, Arrays.asList("AND4B"));
                break;
            }
            case "OR4B": {
                dependencyMap.put(deviceType, Arrays.asList("OR"));
                break;
            }
            case "OR16B": {
                dependencyMap.put(deviceType, Arrays.asList("OR4B"));
                break;
            }
            case "OR16W": {
                dependencyMap.put(deviceType, Arrays.asList("OR4W"));
                break;
            }
            case "XOR4B": {
                dependencyMap.put(deviceType, Arrays.asList("XOR"));
                break;
            }
            case "XOR16B": {
                dependencyMap.put(deviceType, Arrays.asList("XOR4B"));
                break;
            }
            case "MUX16B": {
                dependencyMap.put(deviceType, Arrays.asList("MUX4B"));
                break;
            }
            case "MUX4W16B": {
                dependencyMap.put(deviceType, Arrays.asList("MUX16B"));
                break;
            }
            case "ADDER16B": {
                dependencyMap.put(deviceType, Arrays.asList("ADDER4B"));
                break;
            }
            case "ALU16B": {
                dependencyMap.put(deviceType, Arrays.asList("ALU4B"));
                break;
            }
            case "REGISTER16B": {
                dependencyMap.put(deviceType, Arrays.asList("REGISTER4B"));
                break;
            }
            case "COUNTER16B": {
                dependencyMap.put(deviceType, Arrays.asList("COUNTER4B"));
                break;
            }
            case "RAM64KW16B": {
                dependencyMap.put(deviceType, Arrays.asList("RAM4W16B", "DEMUX4W", "MUX4W16B"));
                break;
            }
            default: {
                List<String> usedDeviceTypes = Parser.parseDeviceTypes(d.code);
                dependencyMap.put(deviceType, usedDeviceTypes);
            }
        }
        switch (deviceType) {
            case "NAND": {
                statsMap.put(deviceType, 1);
                break;
            }
            case "DFF": {
                statsMap.put(deviceType, 5);
                break;
            }
            default: {
                DesignRepo.refreshStats(deviceType);
            }
        }
    }

    private static void refreshStats(String deviceType) {
        int nandCount = 0;
        int startCount = 0;
        if (statsMap.containsKey(deviceType)) {
            startCount = DesignRepo.getNandCount(deviceType);
        }
        switch (deviceType) {
            case "NAND4B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("NAND") * 4);
                break;
            }
            case "NAND16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("NAND4B") * 4);
                break;
            }
            case "NOT16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("NOT4B") * 4);
                break;
            }
            case "AND4B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("AND") * 4);
                break;
            }
            case "AND16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("AND4B") * 4);
                break;
            }
            case "OR4B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("OR") * 4);
                break;
            }
            case "OR16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("OR4B") * 4);
                break;
            }
            case "OR16W": {
                statsMap.put(deviceType, (int)Math.ceil((double)DesignRepo.getNandCount("OR4W") / 3.0) * 15);
                break;
            }
            case "XOR4B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("XOR") * 4);
                break;
            }
            case "XOR16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("XOR4B") * 4);
                break;
            }
            case "MUX16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("MUX4B") * 4);
                break;
            }
            case "MUX4W16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("MUX16B") * 3);
                break;
            }
            case "ADDER16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("ADDER4B") * 4);
                break;
            }
            case "ALU16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("ALU4B") * 4);
                break;
            }
            case "REGISTER16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("REGISTER4B") * 4);
                break;
            }
            case "COUNTER16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("COUNTER4B") * 4);
                break;
            }
            case "RAM64KW16B": {
                statsMap.put(deviceType, DesignRepo.getNandCount("RAM4W16B") * 16364 + DesignRepo.getNandCount("DEMUX4W") * 16363 + DesignRepo.getNandCount("MUX4W16B") * 16363);
                break;
            }
            default: {
                List<String> usedDeviceTypes = dependencyMap.get(deviceType);
                for (String devType : usedDeviceTypes) {
                    nandCount += DesignRepo.getNandCount(devType);
                }
                statsMap.put(deviceType, nandCount);
            }
        }
        if (startCount != nandCount) {
            for (Map.Entry<String, List<String>> e : dependencyMap.entrySet()) {
                if (!e.getValue().contains(deviceType)) continue;
                DesignRepo.refreshStats(e.getKey());
            }
        }
    }

    public static int calcStats(String designCode) {
        List<String> usedDeviceTypes = Parser.parseDeviceTypes(designCode);
        int nandCount = 0;
        for (String devType : usedDeviceTypes) {
            nandCount += DesignRepo.getNandCount(devType);
        }
        return nandCount;
    }

    public static int getNandCount(String devType) {
        if (statsMap.get(devType) == null) {
            return 0;
        }
        return statsMap.get(devType);
    }

    public static String getAltImpl(String name) {
        if (!altImplMap.containsKey(name)) {
            altImplMap.put(name, DesignRepo.designMap.get((Object)name).code);
        }
        return altImplMap.get(name);
    }
}

