/*
 * Decompiled with CFR 0.152.
 */
package controller.data;

import java.util.ArrayList;
import java.util.List;
import model.Design;
import model.File;
import model.Folder;

public class FileSystemRoot {
    public static List<File> root = new ArrayList<File>();

    static {
        FileSystemRoot.reset();
    }

    public static Folder getOrCreateFolder(String path) {
        String[] pathElements = path.split("/");
        List<File> files = root;
        Folder result = null;
        String[] stringArray = pathElements;
        int n = pathElements.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            boolean found = false;
            for (File f : files) {
                if (!(f instanceof Folder) || !f.getName().equals(s)) continue;
                found = true;
                result = (Folder)f;
                files = result.files;
                break;
            }
            if (!found) {
                result = new Folder(s);
                files.add(result);
                files = result.files;
            }
            ++n2;
        }
        if (result.getName().equals(pathElements[pathElements.length - 1])) {
            return result;
        }
        return null;
    }

    public static void moveFile(String oldPath, String newPath) {
        Design d = FileSystemRoot.getAndRemove(oldPath);
        if (d != null) {
            FileSystemRoot.getOrCreateFolder(newPath).addFile(d);
        }
    }

    private static Design getAndRemove(String path) {
        String[] pathElements = path.split("/");
        List<File> files = root;
        Folder result = null;
        String[] stringArray = pathElements;
        int n = pathElements.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int i = 0;
            while (i < files.size()) {
                File f = files.get(i);
                if (f instanceof Folder && f.getName().equals(s)) {
                    result = (Folder)f;
                    files = result.files;
                    break;
                }
                if (f instanceof Design && f.getName().equals(s)) {
                    files.remove(f);
                    return (Design)f;
                }
                ++i;
            }
            ++n2;
        }
        return null;
    }

    public static void collapseFolder(String path) {
        String[] pathElements = path.split("/");
        List<File> goal = root;
        Folder folder = null;
        int i = 0;
        while (i < pathElements.length) {
            for (File f : goal) {
                if (!(f instanceof Folder) || !((Folder)f).name.equals(pathElements[i])) continue;
                folder = (Folder)f;
                goal = folder.files;
                break;
            }
            ++i;
        }
        folder.collapsed = true;
    }

    public static void reset() {
        FileSystemRoot.getOrCreateFolder("Documents\\");
        FileSystemRoot.getOrCreateFolder("Documents\\/Briefings\\");
        FileSystemRoot.getOrCreateFolder("Documents\\/Manual\\");
        FileSystemRoot.getOrCreateFolder("Tasks\\");
        FileSystemRoot.getOrCreateFolder("Completed\\");
        Design d = new Design();
        d.name = "Settings";
        root.add(d);
    }
}

