/*
 * Decompiled with CFR 0.152.
 */
package controller.data;

import controller.data.DesignRepo;
import controller.data.FileSystemRoot;
import controller.data.MissionControl;
import controller.ui.Options;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.Design;
import utils.Logger;
import utils.Resources;
import utils.ScoreUtil;

public class MemorySystem {
    private static boolean loaded = false;

    public static void save() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(String.valueOf(Resources.getUserHome()) + "savestate"));
            oos.writeObject(DesignRepo.designMap);
            oos.writeObject(FileSystemRoot.root);
            oos.writeObject(Options.colorMode);
            oos.writeObject(Options.soundMute);
            oos.writeObject(MissionControl.multiLogicCompleted);
            oos.writeObject(MissionControl.multiOrCompleted);
            oos.writeObject(MissionControl.multiNotCompleted);
            oos.writeObject(MissionControl.muxesCompleted);
            oos.writeObject(MissionControl.demuxesCompleted);
            oos.writeObject(MissionControl.adderCompleted);
            oos.writeObject(MissionControl.aluCompleted);
            oos.writeObject(MissionControl.registerCompleted);
            oos.writeObject(MissionControl.ramCompleted);
            oos.writeObject(MissionControl.counterCompleted);
            oos.writeObject(MissionControl.introducedTed);
            oos.writeObject(Options.dispMode);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static boolean load() {
        try {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(String.valueOf(Resources.getUserHome()) + "savestate"));
                DesignRepo.designMap = (Map)ois.readObject();
                FileSystemRoot.root = (List)ois.readObject();
                Options.setColorMode((Integer)ois.readObject());
                Options.setSoundMute((Boolean)ois.readObject());
                MissionControl.multiLogicCompleted = (Boolean)ois.readObject();
                MissionControl.multiOrCompleted = (Boolean)ois.readObject();
                MissionControl.multiNotCompleted = (Boolean)ois.readObject();
                MissionControl.muxesCompleted = (Boolean)ois.readObject();
                MissionControl.demuxesCompleted = (Boolean)ois.readObject();
                MissionControl.adderCompleted = (Boolean)ois.readObject();
                MissionControl.aluCompleted = (Boolean)ois.readObject();
                MissionControl.registerCompleted = (Boolean)ois.readObject();
                MissionControl.ramCompleted = (Boolean)ois.readObject();
                MissionControl.counterCompleted = (Boolean)ois.readObject();
                try {
                    MissionControl.introducedTed = (Boolean)ois.readObject();
                }
                catch (Exception e) {
                    Logger.log("Found old savestate... fixing to new version");
                    MissionControl.introducedTed = MissionControl.multiLogicCompleted | MissionControl.multiOrCompleted | MissionControl.multiNotCompleted;
                }
                if (DesignRepo.designMap.get("XOR4B") != null) {
                    DesignRepo.designMap.get((Object)"XOR4B").code = null;
                }
                if (DesignRepo.designMap.get("OR4B") != null) {
                    DesignRepo.designMap.get((Object)"OR4B").code = null;
                }
                try {
                    int newDispMode = (Integer)ois.readObject();
                    if (Options.dispMode != newDispMode) {
                        Options.setDispMode(newDispMode);
                    }
                }
                catch (Exception e) {
                    Logger.log("Found old savestate...");
                }
                int i = 0;
                while (i < 2) {
                    for (Design d : DesignRepo.designMap.values()) {
                        if (!d.completed) continue;
                        DesignRepo.calcStatsAndDependencies(d);
                    }
                    ++i;
                }
                for (Design d : DesignRepo.designMap.values()) {
                    if (!d.completed) continue;
                    ScoreUtil.uploadScore(d.name, DesignRepo.getNandCount(d.name));
                    ScoreUtil.updateAllScores();
                }
                ois.close();
            }
            catch (Exception e) {
                Logger.log("Couldn't find savestate... creating new one");
                MissionControl.startGame();
                Options.setColorMode(0);
                Options.setSoundMute(false);
                loaded = true;
            }
        }
        finally {
            loaded = true;
        }
        return false;
    }

    public static void reset() {
        DesignRepo.designMap = new HashMap<String, Design>();
        DesignRepo.statsMap = new HashMap<String, Integer>();
        DesignRepo.dependencyMap = new HashMap<String, List<String>>();
        DesignRepo.altImplMap = new HashMap<String, String>();
        FileSystemRoot.root = new ArrayList<model.File>();
        Options.setColorMode(0);
        Options.setSoundMute(false);
        MissionControl.counterCompleted = false;
        MissionControl.introducedTed = false;
        MissionControl.ramCompleted = false;
        MissionControl.registerCompleted = false;
        MissionControl.aluCompleted = false;
        MissionControl.adderCompleted = false;
        MissionControl.demuxesCompleted = false;
        MissionControl.muxesCompleted = false;
        MissionControl.multiNotCompleted = false;
        MissionControl.multiOrCompleted = false;
        MissionControl.multiLogicCompleted = false;
        FileSystemRoot.reset();
        MissionControl.startGame();
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean saveStateExists() {
        File file = new File(String.valueOf(Resources.getUserHome()) + "savestate");
        File fileOld = new File(String.valueOf(Resources.defaultUserHome) + "savestate");
        if (file.exists()) {
            return true;
        }
        if (fileOld.exists()) {
            try {
                Files.copy(fileOld.toPath(), file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Logger.log(e);
            }
            return file.exists();
        }
        return false;
    }

    public static void loadColorOnly() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(String.valueOf(Resources.getUserHome()) + "savestate"));){
                ois.readObject();
                ois.readObject();
                Options.setColorMode((Integer)ois.readObject());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            Logger.log(e);
        }
    }

    public static void loadDispModeOnly() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(String.valueOf(Resources.getUserHome()) + "savestate"));
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            ois.readObject();
            try {
                ois.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Options.dispMode = (Integer)ois.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

