/*
 * Decompiled with CFR 0.152.
 */
package controller.data;

import controller.data.DesignRepo;
import controller.data.FileSystemRoot;
import controller.ui.FileExplorer;
import controller.ui.GlobalUIController;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import model.Design;
import utils.AchievementUtil;
import utils.Resources;
import utils.ScoreUtil;

public class MissionControl
implements Serializable {
    public static final List<String> MISSION_LIST = Arrays.asList("NAND", "NOT", "AND", "OR", "XOR", "NOT4B", "AND4B", "OR4W", "DEMUX", "DEMUX4W", "MUX", "MUX4B", "HALFADDER", "FULLADDER", "ADDER4B", "ALU4B", "DFF", "REGISTER", "REGISTER4B", "RAM4W16B", "COUNTER4B", "DECODER", "CPU");
    public static boolean multiLogicCompleted = false;
    public static boolean multiOrCompleted = false;
    public static boolean multiNotCompleted = false;
    public static boolean muxesCompleted = false;
    public static boolean demuxesCompleted = false;
    public static boolean adderCompleted = false;
    public static boolean aluCompleted = false;
    public static boolean introducedTed = false;
    public static boolean registerCompleted;
    public static boolean ramCompleted;
    public static boolean counterCompleted;

    public static void completeMission(String name) {
        Design d = DesignRepo.designMap.get(name);
        if (d != null && d.completed) {
            return;
        }
        if (d != null) {
            d.completed = true;
        }
        FileSystemRoot.moveFile("Tasks\\/" + name, "Completed\\/");
        switch (name) {
            case "NOT": {
                MissionControl.addTask(Resources.getDesign("AND"));
                AchievementUtil.complete(AchievementUtil.FIRST_DESIGN);
                break;
            }
            case "AND": {
                MissionControl.addTask(Resources.getDesign("OR"));
                break;
            }
            case "OR": {
                MissionControl.addTask(Resources.getDesign("XOR"));
                break;
            }
            case "XOR": {
                MissionControl.addTask(Resources.getDesign("NOT4B"));
                MissionControl.addTask(Resources.getDesign("AND4B"));
                MissionControl.addTask(Resources.getDesign("OR4W"));
                MissionControl.addBriefing(Resources.getDesign("BRIEFING1"));
                break;
            }
            case "AND4B": {
                multiLogicCompleted = true;
                DesignRepo.designMap.get((Object)"AND4B").completed = true;
                FileSystemRoot.moveFile("Tasks\\/AND4B", "Completed\\/");
                MissionControl.addCompleted(Resources.getDesign("OR4B"));
                MissionControl.addCompleted(Resources.getDesign("XOR4B"));
                MissionControl.selectTask();
                MissionControl.completeLogicSection();
                break;
            }
            case "NOT4B": {
                multiNotCompleted = true;
                MissionControl.selectTask();
                MissionControl.completeLogicSection();
                break;
            }
            case "OR4W": {
                multiOrCompleted = true;
                MissionControl.selectTask();
                MissionControl.completeLogicSection();
                break;
            }
            case "MUX": {
                FileSystemRoot.moveFile("Completed\\/MUX", "Completed\\/Advanced Circuits\\/");
                MissionControl.addTask(Resources.getDesign("MUX4B"));
                break;
            }
            case "DEMUX": {
                FileSystemRoot.moveFile("Completed\\/DEMUX", "Completed\\/Advanced Circuits\\/");
                MissionControl.addTask(Resources.getDesign("DEMUX4W"));
                break;
            }
            case "MUX4B": {
                FileSystemRoot.moveFile("Completed\\/MUX4B", "Completed\\/Advanced Circuits\\/");
                muxesCompleted = true;
                MissionControl.selectTask();
                MissionControl.completeMuxes();
                MissionControl.completeAdvancedLogic();
                break;
            }
            case "DEMUX4W": {
                FileSystemRoot.moveFile("Completed\\/DEMUX4W", "Completed\\/Advanced Circuits\\/");
                demuxesCompleted = true;
                MissionControl.selectTask();
                MissionControl.completeMuxes();
                MissionControl.completeAdvancedLogic();
                break;
            }
            case "HALFADDER": {
                FileSystemRoot.moveFile("Completed\\/HALFADDER", "Completed\\/Advanced Circuits\\/");
                MissionControl.addTask(Resources.getDesign("FULLADDER"));
                break;
            }
            case "FULLADDER": {
                FileSystemRoot.moveFile("Completed\\/FULLADDER", "Completed\\/Advanced Circuits\\/");
                MissionControl.addTask(Resources.getDesign("ADDER4B"));
                break;
            }
            case "ADDER4B": {
                FileSystemRoot.moveFile("Completed\\/ADDER4B", "Completed\\/Advanced Circuits\\/");
                adderCompleted = true;
                MissionControl.selectTask();
                MissionControl.completeAdder();
                MissionControl.completeAdvancedLogic();
                break;
            }
            case "ALU4B": {
                FileSystemRoot.moveFile("Completed\\/ALU4B", "Completed\\/Advanced Circuits\\/");
                aluCompleted = true;
                MissionControl.selectTask();
                MissionControl.completeAlu();
                break;
            }
            case "REGISTER": {
                FileSystemRoot.moveFile("Completed\\/REGISTER", "Completed\\/Memory\\/");
                MissionControl.addTask(Resources.getDesign("REGISTER4B"));
                break;
            }
            case "REGISTER4B": {
                FileSystemRoot.moveFile("Completed\\/REGISTER4B", "Completed\\/Memory\\/");
                MissionControl.addTask(Resources.getDesign("RAM4W16B"));
                registerCompleted = true;
                MissionControl.completeRegister();
                break;
            }
            case "RAM4W16B": {
                FileSystemRoot.moveFile("Completed\\/RAM4W16B", "Completed\\/Memory\\/");
                ramCompleted = true;
                MissionControl.selectTask();
                MissionControl.completeRam();
                break;
            }
            case "COUNTER4B": {
                FileSystemRoot.moveFile("Completed\\/COUNTER4B", "Completed\\/Memory\\/");
                counterCompleted = true;
                MissionControl.selectTask();
                MissionControl.completeCounter();
                break;
            }
            case "DECODER": {
                MissionControl.selectTask();
                FileExplorer.collapseLevel3();
                break;
            }
            case "CPU": {
                AchievementUtil.complete(AchievementUtil.CPU);
                FileExplorer.collapseLevel3();
                MissionControl.addBriefing(Resources.getDesign("BRIEFING7"));
                FileSystemRoot.root.remove(1);
                return;
            }
        }
    }

    private static void selectTask() {
        if (FileSystemRoot.getOrCreateFolder((String)"Tasks\\/").files.size() > 0) {
            FileExplorer.selectDesign(FileSystemRoot.getOrCreateFolder((String)"Tasks\\/").files.get(0).getName());
        }
        FileExplorer.previewInWorkspace();
        GlobalUIController.switchToExplorer();
    }

    private static void completeCounter() {
        if (aluCompleted && ramCompleted && counterCompleted) {
            MissionControl.addTask(Resources.getDesign("DECODER"));
            MissionControl.addTask(Resources.getDesign("CPU"));
        }
        FileSystemRoot.moveFile("Completed\\/Memory\\/COUNTER4B", "Completed\\/Memory\\/Counter\\/");
        MissionControl.addCompleted(Resources.getDesign("COUNTER16B"), "Completed\\/Memory\\/Counter\\/");
        MissionControl.addBriefing(Resources.getDesign("BRIEFING6"));
        FileExplorer.collapseLevel3();
    }

    private static void completeRam() {
        AchievementUtil.complete(AchievementUtil.MEMORY);
        if (aluCompleted && ramCompleted && counterCompleted) {
            MissionControl.addTask(Resources.getDesign("DECODER"));
            MissionControl.addTask(Resources.getDesign("CPU"));
        }
        FileSystemRoot.moveFile("Completed\\/Memory\\/RAM4W16B", "Completed\\/Memory\\/Ram\\/");
        MissionControl.addCompleted(Resources.getDesign("RAM64KW16B"), "Completed\\/Memory\\/Ram\\/");
        FileExplorer.collapseLevel3();
    }

    private static void completeRegister() {
        if (adderCompleted && registerCompleted) {
            MissionControl.addTask(Resources.getDesign("COUNTER4B"));
        }
        FileSystemRoot.moveFile("Completed\\/Memory\\/REGISTER", "Completed\\/Memory\\/Register\\/");
        FileSystemRoot.moveFile("Completed\\/Memory\\/REGISTER4B", "Completed\\/Memory\\/Register\\/");
        MissionControl.addCompleted(Resources.getDesign("REGISTER16B"), "Completed\\/Memory\\/Register\\/");
        FileExplorer.collapseLevel3();
    }

    private static void completeAlu() {
        AchievementUtil.complete(AchievementUtil.ALU);
        if (aluCompleted && ramCompleted && counterCompleted) {
            MissionControl.addTask(Resources.getDesign("DECODER"));
            MissionControl.addTask(Resources.getDesign("CPU"));
        }
        FileSystemRoot.moveFile("Completed\\/Advanced Circuits\\/ALU4B", "Completed\\/Advanced Circuits\\/Alu\\/");
        MissionControl.addCompleted(Resources.getDesign("ALU16B"), "Completed\\/Advanced Circuits\\/Alu\\/");
        FileExplorer.collapseLevel3();
    }

    private static void completeAdvancedLogic() {
        if (!(muxesCompleted && demuxesCompleted && adderCompleted)) {
            return;
        }
        AchievementUtil.complete(AchievementUtil.ADVANCED_LOGIC);
        MissionControl.addTask(Resources.getDesign("ALU4B"));
        MissionControl.addBriefing(Resources.getDesign("BRIEFING4"));
    }

    private static void completeAdder() {
        if (adderCompleted && registerCompleted) {
            MissionControl.addTask(Resources.getDesign("COUNTER4B"));
        }
        FileSystemRoot.moveFile("Completed\\/Advanced Circuits\\/HALFADDER", "Completed\\/Advanced Circuits\\/Adder\\/");
        FileSystemRoot.moveFile("Completed\\/Advanced Circuits\\/FULLADDER", "Completed\\/Advanced Circuits\\/Adder\\/");
        FileSystemRoot.moveFile("Completed\\/Advanced Circuits\\/ADDER4B", "Completed\\/Advanced Circuits\\/Adder\\/");
        MissionControl.addCompleted(Resources.getDesign("ADDER16B"), "Completed\\/Advanced Circuits\\/Adder\\/");
        FileExplorer.collapseLevel3();
    }

    private static void completeMuxes() {
        if (!muxesCompleted || !demuxesCompleted) {
            return;
        }
        MissionControl.addCompleted(Resources.getDesign("DFF"), "Completed\\/Memory\\/");
        MissionControl.addTask(Resources.getDesign("REGISTER"));
        FileSystemRoot.moveFile("Completed\\/Advanced Circuits\\/MUX", "Completed\\/Advanced Circuits\\/Mux\\/");
        FileSystemRoot.moveFile("Completed\\/Advanced Circuits\\/MUX4B", "Completed\\/Advanced Circuits\\/Mux\\/");
        MissionControl.addCompleted(Resources.getDesign("MUX16B"), "Completed\\/Advanced Circuits\\/Mux\\/");
        MissionControl.addCompleted(Resources.getDesign("MUX4W16B"), "Completed\\/Advanced Circuits\\/Mux\\/");
        FileSystemRoot.moveFile("Completed\\/Advanced Circuits\\/DEMUX", "Completed\\/Advanced Circuits\\/Demux\\/");
        FileSystemRoot.moveFile("Completed\\/Advanced Circuits\\/DEMUX4W", "Completed\\/Advanced Circuits\\/Demux\\/");
        MissionControl.addBriefing(Resources.getDesign("BRIEFING5"));
        FileExplorer.collapseLevel3();
    }

    private static void completeLogicSection() {
        if (!introducedTed) {
            MissionControl.addBriefing(Resources.getDesign("BRIEFING2"));
            introducedTed = true;
            AchievementUtil.complete(AchievementUtil.TED);
        }
        if (!(multiLogicCompleted && multiNotCompleted && multiOrCompleted)) {
            return;
        }
        AchievementUtil.complete(AchievementUtil.BASIC_LOGIC);
        MissionControl.addTask(Resources.getDesign("MUX"));
        MissionControl.addTask(Resources.getDesign("DEMUX"));
        MissionControl.addTask(Resources.getDesign("HALFADDER"));
        FileSystemRoot.moveFile("Completed\\/NAND", "Completed\\/Logic Circuits\\/Nand\\/");
        MissionControl.addCompleted(Resources.getDesign("NAND4B"), "Completed\\/Logic Circuits\\/Nand\\/");
        MissionControl.addCompleted(Resources.getDesign("NAND16B"), "Completed\\/Logic Circuits\\/Nand\\/");
        FileSystemRoot.moveFile("Completed\\/NOT", "Completed\\/Logic Circuits\\/Not\\/");
        FileSystemRoot.moveFile("Completed\\/NOT4B", "Completed\\/Logic Circuits\\/Not\\/");
        MissionControl.addCompleted(Resources.getDesign("NOT16B"), "Completed\\/Logic Circuits\\/Not\\/");
        FileSystemRoot.moveFile("Completed\\/AND", "Completed\\/Logic Circuits\\/And\\/");
        FileSystemRoot.moveFile("Completed\\/AND4B", "Completed\\/Logic Circuits\\/And\\/");
        MissionControl.addCompleted(Resources.getDesign("AND16B"), "Completed\\/Logic Circuits\\/And\\/");
        FileSystemRoot.moveFile("Completed\\/OR", "Completed\\/Logic Circuits\\/Or\\/");
        FileSystemRoot.moveFile("Completed\\/OR4B", "Completed\\/Logic Circuits\\/Or\\/");
        MissionControl.addCompleted(Resources.getDesign("OR16B"), "Completed\\/Logic Circuits\\/Or\\/");
        FileSystemRoot.moveFile("Completed\\/OR4W", "Completed\\/Logic Circuits\\/Or\\/");
        MissionControl.addCompleted(Resources.getDesign("OR16W"), "Completed\\/Logic Circuits\\/Or\\/");
        FileSystemRoot.moveFile("Completed\\/XOR", "Completed\\/Logic Circuits\\/Xor\\/");
        FileSystemRoot.moveFile("Completed\\/XOR4B", "Completed\\/Logic Circuits\\/Xor\\/");
        MissionControl.addCompleted(Resources.getDesign("XOR16B"), "Completed\\/Logic Circuits\\/Xor\\/");
        FileExplorer.collapseLevel3();
    }

    public static void startGame() {
        MissionControl.addTask(Resources.getDesign("NOT"));
        MissionControl.addCompleted(Resources.getDesign("NAND"));
        MissionControl.addBriefing(Resources.getDesign("BRIEFING0"));
        FileSystemRoot.getOrCreateFolder("Documents\\/Manual\\").addFile(Resources.getDesign("INTRODUCTION"));
        FileSystemRoot.getOrCreateFolder("Documents\\/Manual\\/Tutorials\\").addFile(Resources.getDesign("TUTORIAL1"));
        FileSystemRoot.getOrCreateFolder("Documents\\/Manual\\/Tutorials\\").addFile(Resources.getDesign("TUTORIAL2"));
        FileSystemRoot.getOrCreateFolder("Documents\\/Manual\\").addFile(Resources.getDesign("SYNTAX"));
        FileSystemRoot.getOrCreateFolder("Documents\\/Manual\\").addFile(Resources.getDesign("SEQUENTIALLOGIC"));
        FileSystemRoot.getOrCreateFolder("Documents\\/Manual\\").addFile(Resources.getDesign("NOTATIONALSYSTEMS"));
        FileSystemRoot.getOrCreateFolder((String)"Documents\\/Manual\\").collapsed = true;
    }

    private static void addBriefing(Design d) {
        d.spec = null;
        d.code = null;
        if (!d.name.equals("BRIEFING0")) {
            GlobalUIController.createDialog("NEW BRIEFING UNLOCKED", "You unlocked a new briefing: " + String.format("%-10s", d.getName()));
        }
        DesignRepo.addDesign(d);
        FileSystemRoot.getOrCreateFolder("Documents\\/Briefings\\/").addFile(d);
        FileExplorer.selectDesign(d);
        FileExplorer.previewInWorkspace();
        GlobalUIController.switchToExplorer();
    }

    public static void addCompleted(Design d) {
        MissionControl.addCompleted(d, "Completed\\/");
    }

    private static void addCompleted(Design d, String path) {
        d.stats = null;
        d.completed = true;
        d.custom = false;
        if (!d.name.equals("NAND")) {
            GlobalUIController.createDialog("NEW DESIGN UNLOCKED", "Ted finished a design: " + String.format("%-10s", d.name));
        }
        DesignRepo.addDesign(d);
        DesignRepo.calcStatsAndDependencies(d);
        ScoreUtil.uploadScore(d.name, DesignRepo.getNandCount(d.name));
        FileSystemRoot.getOrCreateFolder(path).addFile(d);
    }

    public static void addTask(Design d) {
        d.stats = null;
        d.completed = false;
        d.custom = false;
        if (!d.name.equals("NOT")) {
            GlobalUIController.createDialog("NEW TASK UNLOCKED", "You unlocked a new task: " + String.format("%-10s", d.name));
        }
        DesignRepo.addDesign(d);
        FileSystemRoot.getOrCreateFolder("Tasks\\/").addFile(d);
        MissionControl.selectTask();
    }
}

