/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.data.DesignRepo;
import controller.data.MissionControl;
import controller.ui.Cursor;
import controller.ui.Dialog;
import controller.ui.GlobalUIController;
import controller.ui.QuickHelp;
import controller.ui.UIController;
import controller.ui.VerificationDialog;
import controller.ui.Workspace;
import engine.GameObject;
import engine.GraphicsSystem;
import engine.InputSystem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import model.Design;
import simulator.Parser;
import utils.ScoreUtil;

public class CodeEditor
extends UIController
implements GameObject {
    public static boolean active = false;
    static CodeEditor instance;
    private static boolean firstActiveFrame;
    private List<String> autoCompleteSuggestions;
    public static boolean autoCompleteActive;
    private static boolean editable;
    private int autoCompleteSelection = 0;
    private int autoCompleteMaxSize = 10;
    private int autoCompleteOffset;
    private boolean autoCompleteAtCursor = false;
    private static final int CTRL_X = 24;
    private static final int CTRL_C = 3;
    private static final int CTRL_V = 22;
    private static final int CTRL_A = 1;
    private static final int CTRL_Z = 26;
    private static final int CTRL_Y = 25;
    public Cursor textCursor;
    private String clipboard = "";
    int historySize = 100;
    char[][][] oldState;
    int[][] oldCursor;
    int historyIndex = 1;
    int minHistory = 2;
    int maxHistory = 1;
    public char[][] displayBuffer;

    static {
        autoCompleteActive = false;
        editable = true;
    }

    public CodeEditor(int x, int y, int w, int h) {
        super(x, y, w, h);
        instance = this;
        this.textCursor = new Cursor(0, 0, this.x, this.y, this);
        this.reset();
    }

    @Override
    public boolean step(float td) {
        boolean draw = false;
        if (!GlobalUIController.dialogs.isEmpty()) {
            return draw;
        }
        if (active && !CodeEditor.isActive()) {
            return false;
        }
        if (!CodeEditor.isActive() || !editable) {
            this.textCursor.setActive(false);
            return draw;
        }
        if (firstActiveFrame) {
            firstActiveFrame = false;
            return true;
        }
        boolean history = false;
        for (KeyEvent e : InputSystem.eventQueue) {
            if (!autoCompleteActive) {
                if (e.getKeyCode() == 38) {
                    draw = this.textCursor.up(e.isShiftDown());
                    continue;
                }
                if (e.getKeyCode() == 32 && e.isControlDown()) {
                    if (this.autoCompleteSuggestions == null || this.autoCompleteSuggestions.isEmpty()) continue;
                    CodeEditor.toggleAutoCompleteActive();
                    draw = true;
                    continue;
                }
                if (e.getKeyCode() == 40) {
                    draw = this.textCursor.down(e.isShiftDown());
                    continue;
                }
                if (e.getKeyCode() == 37) {
                    draw = this.textCursor.left(e.isShiftDown(), e.isControlDown());
                    continue;
                }
                if (e.getKeyCode() == 39) {
                    draw = this.textCursor.right(e.isShiftDown(), e.isControlDown());
                    continue;
                }
                if (e.getKeyCode() == 35) {
                    draw = this.textCursor.end(e.isShiftDown());
                    continue;
                }
                if (e.getKeyCode() == 36) {
                    draw = this.textCursor.home(e.isShiftDown());
                    continue;
                }
                if (e.getKeyCode() == 127) {
                    draw = this.textCursor.delete(e.isControlDown());
                    continue;
                }
                if (!(e.getKeyChar() < ' ' || e.getKeyChar() > '~' || e.getKeyChar() >= 'a' && e.getKeyChar() <= 'z' && e.isControlDown())) {
                    draw = this.textCursor.write(e.getKeyChar());
                    continue;
                }
                if (e.getKeyChar() == '\n' && !e.isControlDown()) {
                    String lastLine;
                    draw = this.textCursor.newLine();
                    if (!draw || (lastLine = this.textCursor.bufferToString(this.displayBuffer[this.textCursor.y - 1]).trim()).isEmpty() || lastLine.charAt(lastLine.length() - 1) != ':' && lastLine.charAt(lastLine.length() - 1) != ',') continue;
                    this.textCursor.write("  ");
                    continue;
                }
                if (e.getKeyCode() == 10 && e.isControlDown()) {
                    Workspace.setCurrentDesignCode(CodeEditor.getCode());
                    final Design currentDesign = Workspace.getCurrentDesign();
                    final String designCode = currentDesign.completed ? DesignRepo.getAltImpl(currentDesign.name) : currentDesign.code;
                    VerificationDialog verificationDialog = new VerificationDialog(designCode, new Dialog.OnDialogListener(){

                        @Override
                        public void onFinish(int buttonIndex) {
                            if (buttonIndex == 1) {
                                if (!currentDesign.completed) {
                                    DesignRepo.calcStatsAndDependencies(currentDesign);
                                    ScoreUtil.uploadScore(currentDesign.name, DesignRepo.getNandCount(currentDesign.name));
                                    MissionControl.completeMission(currentDesign.name);
                                } else {
                                    int newNandCount = DesignRepo.calcStats(designCode);
                                    if (DesignRepo.getNandCount(currentDesign.name) >= newNandCount) {
                                        currentDesign.code = designCode;
                                        DesignRepo.calcStatsAndDependencies(currentDesign);
                                        GlobalUIController.createDialog("DESIGN UPDATED", "Your solution for " + currentDesign.name + " has been updated!");
                                        for (Design d : DesignRepo.designMap.values()) {
                                            if (!d.completed) continue;
                                            ScoreUtil.uploadScore(d.name, DesignRepo.getNandCount(d.name));
                                        }
                                    }
                                }
                            }
                        }
                    });
                    GlobalUIController.createDialog(verificationDialog);
                    continue;
                }
                if (e.getKeyChar() == '\b') {
                    draw = this.textCursor.backspace(e.isControlDown());
                    continue;
                }
                if (e.getKeyChar() == '\u0018' && this.textCursor.selection.active) {
                    this.clipboard = this.textCursor.copy();
                    draw = this.textCursor.delete(false);
                    continue;
                }
                if (e.getKeyChar() == '\u0003' && this.textCursor.selection.active) {
                    this.clipboard = this.textCursor.copy();
                    continue;
                }
                if (e.getKeyChar() == '\u0016') {
                    draw = this.textCursor.write(this.clipboard);
                    continue;
                }
                if (e.getKeyChar() == '\u001a') {
                    draw = this.undo();
                    history = true;
                    continue;
                }
                if (e.getKeyChar() != '\u0019') continue;
                draw = this.redo();
                history = true;
                continue;
            }
            draw = true;
            if (e.getKeyCode() == 38) {
                this.autoCompleteSelection = this.autoCompleteSelection > 0 ? this.autoCompleteSelection - 1 : this.autoCompleteSuggestions.size() - 1;
                continue;
            }
            if (e.getKeyCode() == 40) {
                this.autoCompleteSelection = this.autoCompleteSelection < this.autoCompleteSuggestions.size() - 1 ? this.autoCompleteSelection + 1 : 0;
                continue;
            }
            if (e.getKeyChar() != '\n') continue;
            String suggestion = this.autoCompleteSuggestions.get(this.autoCompleteSelection);
            String token = this.textCursor.getCurrentToken();
            suggestion = suggestion.replaceFirst(token, "");
            this.textCursor.write(suggestion);
            CodeEditor.toggleAutoCompleteActive();
        }
        if (draw && !history) {
            this.saveState();
        }
        if (draw) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.h && i < this.textCursor.y) {
                sb.append(this.textCursor.bufferToString(this.displayBuffer[i])).append("\n");
                ++i;
            }
            i = 0;
            while (i < this.textCursor.x) {
                sb.append(this.displayBuffer[this.textCursor.y][i]);
                ++i;
            }
            this.autoCompleteSuggestions = this.removeDuplicates(Parser.autoComplete(sb.toString()));
            if (this.autoCompleteSuggestions != null) {
                Collections.sort(this.autoCompleteSuggestions);
            }
        }
        return draw | this.textCursor.step(td);
    }

    private List<String> removeDuplicates(List<String> autoComplete) {
        if (autoComplete == null) {
            return null;
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : autoComplete) {
            if (newList.contains(s)) continue;
            newList.add(s);
        }
        return newList;
    }

    public static void toggleAutoCompleteActive() {
        boolean bl = autoCompleteActive = !autoCompleteActive;
        if (autoCompleteActive) {
            CodeEditor.instance.autoCompleteSelection = 0;
            QuickHelp.addShortcut("ESC", "Quit Auto Complete");
            CodeEditor.removeQH();
        } else {
            CodeEditor.addQH();
            CodeEditor.instance.autoCompleteSelection = 0;
            QuickHelp.removeShortcut("ESC");
        }
    }

    public static String bufferToString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < CodeEditor.instance.h) {
            sb.append(CodeEditor.instance.textCursor.bufferToString(CodeEditor.instance.displayBuffer[i])).append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void draw(Graphics2D g) {
        if (!active) {
            return;
        }
        g.setColor(GraphicsSystem.BRIGHT);
        int i = 0;
        while (i < this.displayBuffer.length) {
            String s = this.textCursor.bufferToString(this.displayBuffer[i]);
            int cStart = s.indexOf("//");
            if (cStart >= 0) {
                g.drawString(s.substring(0, cStart), (0 + this.x) * GraphicsSystem.charW, (i + this.y + 1) * GraphicsSystem.charH);
                g.setColor(GraphicsSystem.DARK);
                g.drawString(s.substring(cStart), (0 + this.x + cStart) * GraphicsSystem.charW, (i + this.y + 1) * GraphicsSystem.charH);
                g.setColor(GraphicsSystem.BRIGHT);
            } else {
                g.drawString(s, (0 + this.x) * GraphicsSystem.charW, (i + this.y + 1) * GraphicsSystem.charH);
            }
            ++i;
        }
        this.textCursor.draw(g);
        if (this.autoCompleteSuggestions != null && !this.autoCompleteSuggestions.isEmpty()) {
            if (this.autoCompleteSelection < this.autoCompleteOffset) {
                this.autoCompleteOffset = this.autoCompleteSelection;
            } else if (this.autoCompleteSelection >= this.autoCompleteOffset + this.autoCompleteMaxSize) {
                this.autoCompleteOffset = this.autoCompleteSelection - this.autoCompleteMaxSize + 1;
            }
            List<String> autoCompleteSuggestions = this.autoCompleteSuggestions;
            if (autoCompleteSuggestions.size() > this.autoCompleteMaxSize) {
                if (this.autoCompleteOffset + this.autoCompleteMaxSize > autoCompleteSuggestions.size()) {
                    this.autoCompleteOffset = autoCompleteSuggestions.size() - this.autoCompleteMaxSize;
                }
                autoCompleteSuggestions = autoCompleteSuggestions.subList(this.autoCompleteOffset, this.autoCompleteOffset + this.autoCompleteMaxSize);
            }
            if (CodeEditor.isActive() && !autoCompleteActive) {
                QuickHelp.addShortcut("CTRL + SPACE", "Auto-Complete");
            } else {
                QuickHelp.removeShortcut("CTRL + SPACE");
            }
            int width = "AUTO COMPLETE SUGGESTIONS".length();
            int acx = 1 + this.x + this.textCursor.x - 2;
            int acy = 1 + this.y + this.textCursor.y;
            if (!this.autoCompleteAtCursor) {
                this.drawFrame(autoCompleteActive, "AUTO COMPLETE SUGGESTIONS", g, this.x + this.w - width - 2, this.y + this.h - 4 - autoCompleteSuggestions.size(), width + 2, autoCompleteSuggestions.size() + 4);
                if (this.autoCompleteSuggestions.size() > this.autoCompleteMaxSize) {
                    this.drawAutoCompleteScrollBar(g, this.x + this.w - 2, this.y + this.h - 1 - autoCompleteSuggestions.size());
                }
            } else {
                int maxW = 0;
                for (String s : this.autoCompleteSuggestions) {
                    int n = maxW = s.length() > maxW ? s.length() : maxW;
                }
                this.drawSlimFrame(autoCompleteActive, g, acx, acy, ++maxW + 2, autoCompleteSuggestions.size() + 4);
                if (this.autoCompleteSuggestions.size() > this.autoCompleteMaxSize) {
                    this.drawAutoCompleteScrollBar(g, acx + maxW, acy + 1);
                }
            }
            g.setColor(GraphicsSystem.MEDIUM);
            int i2 = this.y + this.h - autoCompleteSuggestions.size();
            int j = 0;
            while (i2 < this.y + this.h) {
                if (j == this.autoCompleteSelection - this.autoCompleteOffset && autoCompleteActive) {
                    g.setColor(GraphicsSystem.BRIGHT);
                    g.fillRect((this.x + this.w - width - 1) * GraphicsSystem.charW, (i2 - 1) * GraphicsSystem.charH + GraphicsSystem.charOff, GraphicsSystem.charW * (width - 1), GraphicsSystem.charH);
                    g.setColor(Color.BLACK);
                    g.drawString(autoCompleteSuggestions.get(j), (this.x + this.w - width) * GraphicsSystem.charW, i2 * GraphicsSystem.charH);
                    g.setColor(GraphicsSystem.MEDIUM);
                } else {
                    g.drawString(autoCompleteSuggestions.get(j), (this.x + this.w - width) * GraphicsSystem.charW, i2 * GraphicsSystem.charH);
                }
                ++i2;
                ++j;
            }
        } else {
            QuickHelp.removeShortcut("CTRL + SPACE");
        }
    }

    private void drawAutoCompleteScrollBar(Graphics2D g, int x, int y) {
        int scrollBarOffset = this.autoCompleteMaxSize * this.autoCompleteOffset / this.autoCompleteSuggestions.size();
        int scrollBarHeigth = this.autoCompleteMaxSize * this.autoCompleteMaxSize / this.autoCompleteSuggestions.size() + 1;
        String scrollBar = "";
        int i = 0;
        while (i < scrollBarHeigth && scrollBarOffset + i < this.autoCompleteMaxSize) {
            scrollBar = String.valueOf(scrollBar) + "|\n";
            ++i;
        }
        CodeEditor.drawStringWithLineBreaks(g, scrollBar, x, y + scrollBarOffset);
    }

    private void drawSlimFrame(boolean autoCompleteActive2, Graphics2D g, int x, int y, int w, int h) {
        if (active) {
            g.setColor(GraphicsSystem.BRIGHT);
        } else {
            g.setColor(GraphicsSystem.MEDIUM);
        }
        StringBuilder sb = new StringBuilder();
        this.append(sb.append('+'), '-', w - 2).append("+\n");
        int i = 0;
        while (i < h - 4) {
            this.append(sb.append('|'), ' ', w - 2).append("|\n");
            ++i;
        }
        this.append(sb.append('+'), '-', w - 2).append("+\n");
        Color c = g.getColor();
        g.setColor(Color.BLACK);
        g.fillRect(x * GraphicsSystem.charW, y * GraphicsSystem.charH + GraphicsSystem.charOff, w * GraphicsSystem.charW, (h - 2) * GraphicsSystem.charH);
        g.setColor(c);
        CodeEditor.drawStringWithLineBreaks(g, sb.toString(), x, y);
    }

    public static boolean isActive() {
        boolean a = active && Workspace.isActive();
        return a;
    }

    public static void setActive(boolean b) {
        active = b;
        CodeEditor.instance.textCursor.setActive(b);
        firstActiveFrame = true;
        if (b) {
            CodeEditor.addQH();
        } else {
            CodeEditor.removeQH();
        }
    }

    private static void removeQH() {
        QuickHelp.removeShortcut("HOLD SHIFT");
        QuickHelp.removeShortcut("HOLD CTRL");
        QuickHelp.removeShortcut("CTRL + ENTER");
        QuickHelp.removeShortcut("CTRL + Z/Y");
        QuickHelp.removeShortcut("CTRL + C/V");
    }

    private static void addQH() {
        QuickHelp.addShortcut("HOLD SHIFT", "Create Selection");
        QuickHelp.addShortcut("HOLD CTRL", "Navigate Words");
        QuickHelp.addShortcut("CTRL + ENTER", "Run Simulation");
        QuickHelp.addShortcut("CTRL + Z/Y", "Undo / Redo");
        QuickHelp.addShortcut("CTRL + C/V", "Copy / Paste");
    }

    private void saveState() {
        int x;
        boolean changed = false;
        int y = 0;
        block0: while (y < this.displayBuffer.length) {
            x = 0;
            while (x < this.displayBuffer[0].length) {
                if (this.oldState[this.historyIndex][y][x] != this.displayBuffer[y][x]) {
                    changed = true;
                    break block0;
                }
                ++x;
            }
            ++y;
        }
        if (changed) {
            this.historyIndex = (this.historyIndex + 1) % this.historySize;
            y = 0;
            while (y < this.displayBuffer.length) {
                x = 0;
                while (x < this.displayBuffer[0].length) {
                    this.oldState[this.historyIndex][y][x] = this.displayBuffer[y][x];
                    ++x;
                }
                ++y;
            }
            this.oldCursor[this.historyIndex][0] = this.textCursor.y;
            this.oldCursor[this.historyIndex][1] = this.textCursor.x;
            this.maxHistory = this.historyIndex;
            if (this.minHistory == this.historyIndex) {
                this.minHistory = (this.minHistory + 1) % this.historySize;
            }
        }
    }

    private boolean redo() {
        if (this.historyIndex == this.maxHistory) {
            return false;
        }
        this.historyIndex = (this.historyIndex + 1) % this.historySize;
        int y = 0;
        while (y < this.displayBuffer.length) {
            int x = 0;
            while (x < this.displayBuffer[0].length) {
                this.displayBuffer[y][x] = this.oldState[this.historyIndex][y][x];
                ++x;
            }
            ++y;
        }
        this.textCursor.y = this.oldCursor[this.historyIndex][0];
        this.textCursor.x = this.oldCursor[this.historyIndex][1];
        return true;
    }

    private boolean undo() {
        if (this.historyIndex == this.minHistory) {
            return false;
        }
        this.historyIndex = (this.historyIndex - 1 + this.historySize) % this.historySize;
        int y = 0;
        while (y < this.displayBuffer.length) {
            int x = 0;
            while (x < this.displayBuffer[0].length) {
                this.displayBuffer[y][x] = this.oldState[this.historyIndex][y][x];
                ++x;
            }
            ++y;
        }
        this.textCursor.y = this.oldCursor[this.historyIndex][0];
        this.textCursor.x = this.oldCursor[this.historyIndex][1];
        return true;
    }

    public void reset() {
        this.displayBuffer = new char[this.h][this.w];
        this.oldState = new char[this.historySize][this.h][this.w];
        this.historyIndex = 1;
        this.minHistory = 2;
        this.maxHistory = 1;
        this.saveState();
        this.minHistory = 2;
        this.textCursor.y = 0;
        this.textCursor.x = 0;
        this.textCursor.selection.clear();
        this.oldCursor = new int[this.historySize][2];
        this.textCursor.displayBuffer = this.displayBuffer;
    }

    public static void setCode(String code) {
        instance.reset();
        int iy = 0;
        while (iy < CodeEditor.instance.h) {
            int ix = 0;
            while (ix < CodeEditor.instance.w) {
                CodeEditor.instance.displayBuffer[iy][ix] = '\u0000';
                ++ix;
            }
            ++iy;
        }
        String[] ss = code.split("\n");
        int y = 0;
        while (y < ss.length && y < CodeEditor.instance.h) {
            int x = 0;
            while (x < ss[y].length() && x < CodeEditor.instance.w) {
                CodeEditor.instance.displayBuffer[y][x] = ss[y].charAt(x);
                ++x;
            }
            ++y;
        }
        CodeEditor.instance.textCursor.x = 0;
        CodeEditor.instance.textCursor.y = 0;
        CodeEditor.instance.autoCompleteSuggestions = null;
        instance.saveState();
        CodeEditor.instance.minHistory = 2;
    }

    public static String getCode() {
        return CodeEditor.bufferToString();
    }

    public static void disableTextCursor() {
        CodeEditor.instance.textCursor.setActive(false);
    }

    public static void setEditable(boolean b) {
        editable = b;
    }
}

