/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.ui.CodeEditor;
import controller.ui.Selection;
import engine.GameObject;
import engine.GraphicsSystem;
import java.awt.Color;
import java.awt.Graphics2D;

public class Cursor
implements GameObject {
    float blinkTime = 0.5f;
    float timer = 0.0f;
    boolean visible = false;
    public int x;
    public int y;
    public char[][] displayBuffer;
    public Selection selection = new Selection(this);
    public int xOff = 0;
    public int yOff = 0;
    private boolean redrawOnce;

    public Cursor(int x, int y, CodeEditor editor) {
        this.displayBuffer = editor.displayBuffer;
        this.x = x;
        this.y = y;
    }

    public Cursor(int x, int y, int xOffset, int yOffset, CodeEditor editor) {
        this(x, y, editor);
        this.xOff = xOffset;
        this.yOff = yOffset;
    }

    @Override
    public boolean step(float td) {
        this.timer += td;
        if (this.timer > this.blinkTime) {
            this.visible = !this.visible;
            this.timer = 0.0f;
            return true;
        }
        if (this.redrawOnce) {
            this.redrawOnce = false;
            return true;
        }
        return false;
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.visible) {
            g.drawString("_", (this.x + this.xOff) * GraphicsSystem.charW, (this.y + this.yOff + 1) * GraphicsSystem.charH);
        }
        if (this.selection.active) {
            Color oldColor = g.getColor();
            g.setColor(GraphicsSystem.BRIGHT);
            Selection s = this.selection.normalize();
            g.fillRect((s.startX + this.xOff) * GraphicsSystem.charW, GraphicsSystem.charOff + (this.yOff + s.startY) * GraphicsSystem.charH, s.endY == s.startY ? (s.endX - s.startX) * GraphicsSystem.charW : (this.length(this.displayBuffer[s.startY]) - s.startX) * GraphicsSystem.charW, GraphicsSystem.charH);
            g.setColor(Color.BLACK);
            g.drawString(new String(this.displayBuffer[s.startY]).substring(s.startX, s.endY == s.startY ? s.endX : this.displayBuffer[this.y].length), (this.xOff + s.startX) * GraphicsSystem.charW, (s.startY + this.yOff + 1) * GraphicsSystem.charH);
            if (s.endY - s.startY > 1) {
                int i = s.startY + 1;
                while (i < s.endY) {
                    g.setColor(GraphicsSystem.BRIGHT);
                    g.fillRect(this.xOff * GraphicsSystem.charW, GraphicsSystem.charOff + (i + this.yOff) * GraphicsSystem.charH, this.length(this.displayBuffer[i]) * GraphicsSystem.charW, GraphicsSystem.charH);
                    g.setColor(Color.BLACK);
                    g.drawString(this.bufferToString(this.displayBuffer[i]), this.xOff * GraphicsSystem.charW, (i + this.yOff + 1) * GraphicsSystem.charH);
                    ++i;
                }
            }
            if (s.endY > s.startY) {
                g.setColor(GraphicsSystem.BRIGHT);
                g.fillRect(this.xOff * GraphicsSystem.charW, GraphicsSystem.charOff + (this.yOff + s.endY) * GraphicsSystem.charH, s.endX * GraphicsSystem.charW, GraphicsSystem.charH);
                g.setColor(Color.BLACK);
                g.drawString(new String(this.displayBuffer[s.endY]).substring(0, s.endX), this.xOff * GraphicsSystem.charW, (this.yOff + s.endY + 1) * GraphicsSystem.charH);
            }
            g.setColor(oldColor);
        }
    }

    public String bufferToString(char[] cs) {
        return new String(cs).substring(0, this.length(cs));
    }

    int length(char[] cs) {
        int i = 0;
        while (i < cs.length) {
            if (cs[i] == '\u0000') {
                return i;
            }
            ++i;
        }
        return cs.length;
    }

    public boolean up(boolean shiftDown) {
        boolean moved = false;
        this.selection.start();
        if (this.y > 0) {
            --this.y;
            int i = 0;
            while (i < this.displayBuffer[this.y].length && this.displayBuffer[this.y][i] != '\u0000' && i < this.x) {
                ++i;
            }
            this.x = i;
            this.setVisible();
            moved = true;
        }
        this.selection.update(!shiftDown);
        return moved;
    }

    public boolean down(boolean shiftDown) {
        boolean moved = false;
        this.selection.start();
        if (this.y < this.displayBuffer.length - 1) {
            ++this.y;
            int i = 0;
            while (i < this.displayBuffer[this.y].length && this.displayBuffer[this.y][i] != '\u0000' && i < this.x) {
                ++i;
            }
            this.x = i;
            this.setVisible();
            moved = true;
        }
        this.selection.update(!shiftDown);
        return moved;
    }

    public boolean left(boolean shiftDown, boolean ctrlDown) {
        boolean moved = false;
        this.selection.start();
        if (this.x > 0) {
            --this.x;
            while (ctrlDown && this.x > 0 && Character.isWhitespace(this.displayBuffer[this.y][this.x])) {
                --this.x;
            }
            while (ctrlDown && this.x > 0 && !Character.isWhitespace(this.displayBuffer[this.y][this.x])) {
                --this.x;
            }
            if (ctrlDown && Character.isWhitespace(this.displayBuffer[this.y][this.x])) {
                ++this.x;
            }
            this.setVisible();
            moved = true;
        } else if (this.up(shiftDown)) {
            moved |= this.end(shiftDown);
        }
        this.selection.update(!shiftDown);
        return moved;
    }

    public boolean right(boolean shiftDown, boolean ctrlDown) {
        boolean moved = false;
        this.selection.start();
        if (this.x < this.displayBuffer[this.y].length - 1 && (this.displayBuffer[this.y][this.x] != '\u0000' || this.displayBuffer[this.y][this.x + 1] != '\u0000')) {
            ++this.x;
            while (ctrlDown && this.x < this.displayBuffer[this.y].length - 1 && !Character.isWhitespace(this.displayBuffer[this.y][this.x]) && this.displayBuffer[this.y][this.x] != '\u0000') {
                ++this.x;
            }
            while (ctrlDown && this.x < this.displayBuffer[this.y].length - 1 && Character.isWhitespace(this.displayBuffer[this.y][this.x]) && this.displayBuffer[this.y][this.x] != '\u0000') {
                ++this.x;
            }
            this.setVisible();
            moved = true;
        } else {
            moved |= this.down(shiftDown);
            moved |= this.home(shiftDown);
        }
        this.selection.update(!shiftDown);
        return moved;
    }

    private void setVisible() {
        this.visible = true;
        this.timer = 0.0f;
    }

    public boolean write(char c) {
        if (this.selection.active) {
            this.delete(this.selection);
        }
        if (this.displayBuffer[this.y][this.displayBuffer[this.y].length - 1] != '\u0000') {
            return false;
        }
        int ix = this.displayBuffer[this.y].length - 1;
        while (ix > this.x) {
            this.displayBuffer[this.y][ix] = this.displayBuffer[this.y][ix - 1];
            --ix;
        }
        this.displayBuffer[this.y][this.x] = c;
        this.right(false, false);
        return true;
    }

    public boolean end(boolean shiftDown) {
        this.selection.start();
        int i = 0;
        while (i < this.displayBuffer[this.y].length - 1 && this.displayBuffer[this.y][i] != '\u0000') {
            ++i;
        }
        if (this.x == i) {
            this.selection.update(!shiftDown);
            return false;
        }
        this.x = i;
        this.setVisible();
        this.selection.update(!shiftDown);
        return true;
    }

    public boolean home(boolean shiftDown) {
        this.selection.start();
        if (this.x == 0) {
            this.selection.update(!shiftDown);
            return false;
        }
        this.x = 0;
        this.setVisible();
        this.selection.update(!shiftDown);
        return true;
    }

    public boolean newLine() {
        if (this.selection.active) {
            this.delete(this.selection);
        }
        if (this.y == this.displayBuffer.length - 1 || this.displayBuffer[this.displayBuffer.length - 1][0] != '\u0000') {
            return false;
        }
        int iy = this.displayBuffer.length - 1;
        while (iy > this.y + 1) {
            this.displayBuffer[iy] = this.displayBuffer[iy - 1];
            --iy;
        }
        this.displayBuffer[this.y + 1] = new char[this.displayBuffer[0].length];
        int ix = this.x;
        while (ix < this.displayBuffer[0].length) {
            this.displayBuffer[this.y + 1][ix - this.x] = this.displayBuffer[this.y][ix];
            this.displayBuffer[this.y][ix] = '\u0000';
            ++ix;
        }
        this.down(false);
        this.home(false);
        return true;
    }

    public boolean backspace(boolean ctrlDown) {
        if (this.selection.active) {
            this.delete(this.selection);
            return true;
        }
        if (this.x == 0 && this.y == 0) {
            return false;
        }
        if (this.x > 0) {
            int oldX = this.x;
            this.left(false, ctrlDown);
            int i = 0;
            while (i < oldX - this.x) {
                int ix = this.x;
                while (ix < this.displayBuffer[this.y].length) {
                    this.displayBuffer[this.y][ix] = ix == this.displayBuffer[this.y].length - 1 ? (char)'\u0000' : this.displayBuffer[this.y][ix + 1];
                    ++ix;
                }
                ++i;
            }
        } else {
            int curLength;
            int prevLength = this.length(this.displayBuffer[this.y - 1]);
            if (prevLength + (curLength = this.length(this.displayBuffer[this.y])) > this.displayBuffer[this.y - 1].length) {
                return false;
            }
            int ix1 = prevLength;
            int ix2 = 0;
            while (ix2 < curLength) {
                this.displayBuffer[this.y - 1][ix1] = this.displayBuffer[this.y][ix2];
                ++ix1;
                ++ix2;
            }
            this.up(false);
            this.x = prevLength;
            int iy = this.y + 1;
            while (iy < this.displayBuffer.length - 1) {
                this.displayBuffer[iy] = this.displayBuffer[iy + 1];
                ++iy;
            }
            this.displayBuffer[this.displayBuffer.length - 1] = new char[this.displayBuffer[0].length];
        }
        return true;
    }

    public boolean delete(boolean ctrlDown) {
        if (this.selection.active) {
            this.delete(this.selection);
            return true;
        }
        int oldX = this.x;
        int oldY = this.y;
        if (this.displayBuffer[this.y][this.x] != '\u0000') {
            if (this.x == this.displayBuffer[0].length - 1) {
                this.displayBuffer[this.y][this.x] = '\u0000';
            } else {
                this.right(false, ctrlDown);
                int xDif = this.x - oldX;
                int i = 0;
                while (i < xDif) {
                    this.backspace(false);
                    ++i;
                }
                this.x = oldX;
            }
        } else {
            ++this.y;
            this.x = 0;
            if (!this.backspace(ctrlDown)) {
                this.y = oldY;
                this.x = oldX;
                return false;
            }
            this.x = oldX;
        }
        return true;
    }

    private void delete(Selection selection) {
        selection.active = false;
        Selection s = selection.normalize();
        selection.active = false;
        this.x = s.startX;
        this.y = s.startY;
        if (s.endY == s.startY) {
            int deletes = s.endX - s.startX;
            int i = 0;
            while (i < deletes) {
                this.delete(false);
                ++i;
            }
        } else {
            int deletes = this.length(this.displayBuffer[s.startY]) - s.startX;
            int i = 0;
            while (i < deletes) {
                this.delete(false);
                ++i;
            }
            i = s.startY + 1;
            while (i < s.endY) {
                int j = s.startY + 1;
                while (j < this.displayBuffer.length - 1) {
                    this.displayBuffer[j] = this.displayBuffer[j + 1];
                    ++j;
                }
                this.displayBuffer[this.displayBuffer.length - 1] = new char[this.displayBuffer[0].length];
                ++i;
            }
            this.y = s.startY + 1;
            this.x = 0;
            i = 0;
            while (i < s.endX) {
                this.delete(false);
                ++i;
            }
            this.y = s.startY;
            this.x = 0;
            this.end(false);
            this.delete(false);
        }
    }

    public boolean write(String string) {
        boolean redraw = false;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            redraw = c == '\n' ? this.newLine() || redraw : this.write(c) || redraw;
            ++n2;
        }
        return redraw;
    }

    public String copy() {
        StringBuilder sb = new StringBuilder();
        Selection s = this.selection.normalize();
        if (s.startY == s.endY) {
            int i = s.startX;
            while (i < s.endX) {
                sb.append(this.displayBuffer[s.startY][i]);
                ++i;
            }
        } else {
            int i = s.startX;
            while (i < this.length(this.displayBuffer[s.startY])) {
                sb.append(this.displayBuffer[s.startY][i]);
                ++i;
            }
            sb.append('\n');
            int j = s.startY + 1;
            while (j < s.endY) {
                int i2 = 0;
                while (i2 < this.length(this.displayBuffer[j])) {
                    sb.append(this.displayBuffer[j][i2]);
                    ++i2;
                }
                sb.append('\n');
                ++j;
            }
            i = 0;
            while (i < s.endX) {
                sb.append(this.displayBuffer[s.endY][i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public boolean selectAll() {
        this.x = 0;
        this.y = 0;
        while (this.down(true)) {
        }
        while (this.right(true, false)) {
        }
        return true;
    }

    public void setActive(boolean b) {
        this.visible = b;
        this.timer = 0.0f;
        this.redrawOnce = true;
    }

    public String getCurrentToken() {
        StringBuffer sb = new StringBuffer();
        int i = this.x - 1;
        while (i >= 0 && this.displayBuffer[this.y][i] != ' ' && this.displayBuffer[this.y][i] != '>' && this.displayBuffer[this.y][i] != ',') {
            sb.append(this.displayBuffer[this.y][i]);
            --i;
        }
        return sb.reverse().toString();
    }
}

