/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.ui.GlobalUIController;
import controller.ui.UIController;
import engine.GameObject;
import engine.GameState;
import engine.GraphicsSystem;
import engine.InputSystem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;

public class Dialog
extends UIController
implements GameObject {
    String[] content;
    protected List<String> buttons;
    public int buttonIndex;
    private int buttonWidth;
    protected OnDialogListener onDialogListener;
    protected boolean drawOnce = true;
    private String title;

    public Dialog(String title, String contentText, List<String> buttonCaptions, OnDialogListener onDialogListener) {
        super(0, 0, 0, 0);
        this.title = title;
        this.onDialogListener = onDialogListener;
        this.content = contentText.split("\n");
        this.buttons = buttonCaptions;
        this.determineDimensions();
    }

    void determineDimensions() {
        int maxWidth = this.title.length() + 4;
        int xOffset = (GraphicsSystem.getScreenWidth() - 120 * GraphicsSystem.charW) / 2 / GraphicsSystem.charW;
        int yOffset = (GraphicsSystem.getScreenHeight() - 45 * GraphicsSystem.charH) / 2 / GraphicsSystem.charH;
        this.buttonWidth = this.buttons.size() * 6 - (this.buttons.size() - 1);
        for (String s : this.buttons) {
            this.buttonWidth += s.length();
        }
        maxWidth = Math.max(maxWidth, this.buttonWidth);
        int contentWidth = 0;
        String[] stringArray = this.content;
        int n = this.content.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            contentWidth = Math.max(s.length(), contentWidth);
            ++n2;
        }
        maxWidth = Math.max(maxWidth, contentWidth += 4);
        int height = this.content.length + 9;
        this.x = xOffset + (120 - maxWidth) / 2;
        this.y = yOffset + (45 - height) / 2;
        this.w = maxWidth;
        this.h = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean step(float td) {
        Class<Dialog> clazz = Dialog.class;
        synchronized (Dialog.class) {
            if (GlobalUIController.getTopDialog() == null) {
                GameState.deleteGameObject(this);
            } else if (GlobalUIController.getTopDialog() != this) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            boolean draw = this.drawOnce;
            if (this.drawOnce) {
                this.drawOnce = false;
            }
            Iterator<KeyEvent> iterator = InputSystem.eventQueue.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return draw;
                }
                KeyEvent e = iterator.next();
                if (e.getKeyCode() == 37) {
                    this.buttonIndex = this.buttonIndex == 0 ? this.buttons.size() - 1 : this.buttonIndex - 1;
                    draw = true;
                    continue;
                }
                if (e.getKeyCode() == 39) {
                    this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                    draw = true;
                    continue;
                }
                if (e.getKeyCode() == 10) break;
            }
            GlobalUIController.closeDialog(this);
            if (this.onDialogListener != null) {
                this.onDialogListener.onFinish(this.buttonIndex);
            }
            GameState.deleteGameObject(this);
            return true;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.BLACK);
        g.fillRect(this.x * GraphicsSystem.charW, this.y * GraphicsSystem.charH + GraphicsSystem.charOff, this.w * GraphicsSystem.charW, this.h * GraphicsSystem.charH);
        g.setColor(GraphicsSystem.BRIGHT);
        this.drawFrame(true, this.title, g);
        this.drawContent(g);
        this.drawButtons(g);
    }

    private void drawButtons(Graphics2D g) {
        int i = 0;
        int x = this.x + (this.w - this.buttonWidth) / 2 + 1;
        int y = this.y + this.h - 4;
        for (String s : this.buttons) {
            StringBuilder sb = new StringBuilder();
            this.append(sb, '-', s.length() + 4).append("\n| ").append(s).append(" |\n");
            this.append(sb, '-', s.length() + 4);
            Dialog.drawStringWithLineBreaks(g, sb.toString(), x, y);
            if (i == this.buttonIndex) {
                g.fillRect((x + 1) * GraphicsSystem.charW, (y + 1) * GraphicsSystem.charH + GraphicsSystem.charOff, GraphicsSystem.charW * (s.length() + 2), GraphicsSystem.charH);
                g.setColor(Color.BLACK);
                g.drawString(s, (x + 2) * GraphicsSystem.charW, (y + 2) * GraphicsSystem.charH);
                g.setColor(GraphicsSystem.BRIGHT);
            }
            ++i;
            x += s.length() + 5;
        }
    }

    void drawContent(Graphics2D g) {
        int y = this.y + 5;
        String[] stringArray = this.content;
        int n = this.content.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int x = this.x + 2;
            g.drawString(s, x * GraphicsSystem.charW, GraphicsSystem.charH * y++);
            ++n2;
        }
    }

    public static interface OnDialogListener {
        public void onFinish(int var1);
    }
}

