/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.data.FileSystemRoot;
import controller.ui.GlobalUIController;
import controller.ui.QuickHelp;
import controller.ui.UIController;
import controller.ui.Workspace;
import engine.GameObject;
import engine.GraphicsSystem;
import engine.InputSystem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import model.Design;
import model.File;
import model.Folder;

public class FileExplorer
extends UIController
implements GameObject {
    static int selectionY = 0;
    private static List<File> fakeList = Arrays.asList(new Folder("<"), new Folder("<"), new Folder("<"), new Folder("<"), new Folder("<"), new Folder("<"), new Folder("<"));
    static FileExplorer instance;
    private int offset;

    public FileExplorer(int x, int y, int w, int h) {
        super(x, y, w, h);
        instance = this;
    }

    @Override
    public boolean step(float td) {
        if (!GlobalUIController.dialogs.isEmpty()) {
            return false;
        }
        if (!this.active) {
            return false;
        }
        boolean redraw = false;
        int i = 0;
        while (i < InputSystem.eventQueue.size()) {
            File f;
            KeyEvent e = InputSystem.eventQueue.get(i);
            if (e.getKeyCode() == 38) {
                selectionY = selectionY > 0 ? --selectionY : this.fileTreeHeight() - 1;
                if (!(instance.getSelection() instanceof Folder) && !(instance.getSelection() instanceof Design)) {
                    --selectionY;
                }
                FileExplorer.previewInWorkspace();
                redraw = true;
            } else if (e.getKeyCode() == 40) {
                selectionY = selectionY < this.fileTreeHeight() - 1 ? ++selectionY : 0;
                if (!(instance.getSelection() instanceof Folder) && !(instance.getSelection() instanceof Design)) {
                    ++selectionY;
                }
                FileExplorer.previewInWorkspace();
                redraw = true;
            } else if (e.getKeyCode() == 39 || e.getKeyCode() == 521) {
                redraw = true;
                f = this.getSelection();
                if (f instanceof Folder) {
                    ((Folder)f).collapsed = false;
                }
            } else if (e.getKeyCode() == 37 || e.getKeyCode() == 45) {
                redraw = true;
                f = this.getSelection();
                if (f instanceof Folder) {
                    ((Folder)f).collapsed = true;
                }
            } else if (e.getKeyCode() == 10) {
                redraw = true;
                f = this.getSelection();
                if (f instanceof Folder) {
                    ((Folder)f).collapsed = !((Folder)f).collapsed;
                    FileExplorer.previewInWorkspace();
                } else if (f instanceof Design) {
                    Workspace.setCurrentDesign((Design)f);
                    GlobalUIController.switchToWorkspace();
                }
            }
            ++i;
        }
        return redraw;
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawFrame(this.active, "EXPLORER", g);
        this.drawFiles(FileSystemRoot.root, g, this.y + 4, this.x + 2);
    }

    private void drawFiles(List<File> root, Graphics2D g, int iy, int ix) {
        int height;
        StringBuilder sb = new StringBuilder();
        g.setColor(GraphicsSystem.MEDIUM);
        int i = 0;
        while (i < root.size()) {
            sb.append(root.get(i).toString(i == root.size() - 1));
            ++i;
        }
        String[] lines = sb.toString().split("\n");
        if (lines.length > (height = this.h - 4)) {
            if (this.offset + height <= selectionY) {
                this.offset = selectionY - height + 1;
            }
            if (selectionY < this.offset) {
                this.offset = selectionY;
            }
            int scrollBarOffset = height * this.offset / lines.length;
            int scrollBarHeigth = height * height / lines.length + 1;
            g.setColor(this.active ? GraphicsSystem.BRIGHT : GraphicsSystem.MEDIUM);
            String scrollBar = "";
            int i2 = 0;
            while (i2 < scrollBarHeigth && scrollBarOffset + i2 < height) {
                scrollBar = String.valueOf(scrollBar) + "|\n";
                ++i2;
            }
            FileExplorer.drawStringWithLineBreaks(g, scrollBar, this.x + this.w - 2, this.y + 3 + scrollBarOffset);
            g.setColor(GraphicsSystem.MEDIUM);
            lines = Arrays.copyOfRange(lines, this.offset, this.offset + (lines.length - this.offset > height ? height : lines.length - this.offset));
        } else {
            this.offset = 0;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (iy == selectionY - this.offset + this.y + 1 + 3) {
                if (FileExplorer.isActive()) {
                    g.setColor(GraphicsSystem.BRIGHT);
                    g.fillRect((this.x + 1) * GraphicsSystem.charW, (iy - 1) * GraphicsSystem.charH + GraphicsSystem.charOff, (this.w - 2) * GraphicsSystem.charW, GraphicsSystem.charH);
                    g.setColor(Color.BLACK);
                    g.drawString(s, ix * GraphicsSystem.charW, iy++ * GraphicsSystem.charH);
                    g.setColor(GraphicsSystem.MEDIUM);
                } else {
                    g.setColor(GraphicsSystem.BRIGHT);
                    g.drawString(s, ix * GraphicsSystem.charW, iy++ * GraphicsSystem.charH);
                    g.setColor(GraphicsSystem.MEDIUM);
                }
            } else {
                g.drawString(s, ix * GraphicsSystem.charW, iy++ * GraphicsSystem.charH);
            }
            ++n2;
        }
    }

    public static void selectDesign(String name) {
        Design d = new Design();
        d.name = name;
        FileExplorer.selectDesign(d);
    }

    public static void selectDesign(Design d) {
        ArrayList<File> path = new ArrayList<File>();
        for (File f : FileSystemRoot.root) {
            path.add(f);
            if (FileExplorer.searchFile(path, d)) break;
            path.remove(f);
        }
        for (File f : path) {
            if (!(f instanceof Folder)) continue;
            ((Folder)f).collapsed = false;
        }
        selectionY = FileExplorer.count(FileSystemRoot.root, path, 0);
    }

    private static boolean searchFile(List<File> path, Design d) {
        File f = path.get(path.size() - 1);
        if (f instanceof Design && f.getName().equals(d.getName())) {
            return true;
        }
        if (f instanceof Folder) {
            for (File dir : ((Folder)f).files) {
                path.add(dir);
                if (FileExplorer.searchFile(path, d)) {
                    return true;
                }
                path.remove(dir);
            }
        }
        return false;
    }

    private static int count(List<File> root, List<File> path, int i) {
        int count = 0;
        for (File f : root) {
            if (!f.equals(path.get(i))) {
                if (f instanceof Folder && ((Folder)f).collapsed) {
                    ++count;
                    continue;
                }
                if (f instanceof Design) {
                    ++count;
                    continue;
                }
                count += FileExplorer.count(((Folder)f).files, fakeList, i + 1) + 1;
                if (root.get(root.size() - 1).equals(f)) continue;
                ++count;
                continue;
            }
            if (f instanceof Design) {
                return count;
            }
            return count + 1 + FileExplorer.count(((Folder)f).files, path, i + 1);
        }
        return count;
    }

    private static File count(List<File> root, int i) {
        int count = 0;
        for (File f : root) {
            if (count == i) {
                return f;
            }
            if (f instanceof Folder && ((Folder)f).collapsed) {
                ++count;
                continue;
            }
            if (f instanceof Design) {
                ++count;
                continue;
            }
            int count2 = FileExplorer.count(((Folder)f).files, fakeList, 0) + 1;
            if (count2 > i - count) {
                return FileExplorer.count(((Folder)f).files, i - count - 1);
            }
            count += count2;
            if (root.get(root.size() - 1).equals(f)) continue;
            ++count;
        }
        return null;
    }

    private File getSelection() {
        return FileExplorer.count(FileSystemRoot.root, selectionY);
    }

    private int fileTreeHeight() {
        return FileExplorer.count(FileSystemRoot.root, fakeList, 0);
    }

    public static boolean isActive() {
        return FileExplorer.instance.active;
    }

    public static void toggleActive() {
        boolean bl = FileExplorer.instance.active = !FileExplorer.instance.active;
        if (FileExplorer.isActive()) {
            QuickHelp.addShortcut("ESC", "Exit Program");
            FileExplorer.previewInWorkspace();
        }
    }

    public static void collapseLevel3() {
        List<File> files = FileSystemRoot.root;
        for (File f : files) {
            if (f instanceof Design) continue;
            for (File f1 : ((Folder)f).files) {
                if (f1 instanceof Design) continue;
                for (File f2 : ((Folder)f1).files) {
                    if (f2 instanceof Design) continue;
                    ((Folder)f2).collapsed = true;
                }
            }
        }
    }

    public static void previewInWorkspace() {
        File f = instance.getSelection();
        if (f instanceof Design) {
            Workspace.setCurrentDesign((Design)f);
        } else {
            Workspace.clear();
        }
        if (f instanceof Folder && ((Folder)f).collapsed) {
            QuickHelp.addShortcut("ENTER", "Expand Folder");
        } else if (f instanceof Folder && !((Folder)f).collapsed) {
            QuickHelp.addShortcut("ENTER", "Collapse Folder");
        } else if (f instanceof File) {
            QuickHelp.addShortcut("ENTER", "Activate Workspace");
        } else {
            QuickHelp.removeShortcut("ENTER");
        }
    }

    public static void setActive(boolean b) {
        if (FileExplorer.isActive() != b) {
            FileExplorer.toggleActive();
        }
    }
}

