/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import com.codedisaster.steamworks.SteamAPI;
import controller.data.MemorySystem;
import controller.ui.CodeEditor;
import controller.ui.Dialog;
import controller.ui.FileExplorer;
import controller.ui.QuickHelp;
import controller.ui.Workspace;
import engine.GameObject;
import engine.GameState;
import engine.GraphicsSystem;
import engine.InputSystem;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GlobalUIController
implements GameObject {
    public static List<Dialog> dialogs = new ArrayList<Dialog>();

    public GlobalUIController() {
        FileExplorer.toggleActive();
    }

    @Override
    public boolean step(float td) {
        if (!dialogs.isEmpty()) {
            return false;
        }
        boolean redraw = false;
        int i = 0;
        while (i < InputSystem.eventQueue.size()) {
            KeyEvent e = InputSystem.eventQueue.get(i);
            if (e.getKeyCode() == 27) {
                redraw = true;
                if (Workspace.isActive()) {
                    if (CodeEditor.isActive() && CodeEditor.autoCompleteActive) {
                        CodeEditor.toggleAutoCompleteActive();
                    } else {
                        GlobalUIController.switchToExplorer();
                    }
                } else {
                    Dialog d = new Dialog("EXIT MICROHARD DEVELOPMENT ENVIRONMENT", "Are you sure you want to quit Microhard Development Environment?", Arrays.asList("YES", "NO"), new Dialog.OnDialogListener(){

                        @Override
                        public void onFinish(int buttonIndex) {
                            if (buttonIndex == 0) {
                                MemorySystem.save();
                                if (SteamAPI.isSteamRunning()) {
                                    SteamAPI.shutdown();
                                }
                                System.exit(0);
                            }
                        }
                    });
                    d.buttonIndex = 1;
                    GlobalUIController.createDialog(d);
                }
            } else if (e.getKeyCode() == 10 && e.isAltDown()) {
                if (GraphicsSystem.fullScreen) {
                    GraphicsSystem.switchToWindow();
                } else if (GraphicsSystem.borderless) {
                    GraphicsSystem.switchToBorderless();
                } else {
                    GraphicsSystem.switchToFullscreen();
                }
                redraw = true;
            }
            ++i;
        }
        return redraw;
    }

    public static void switchToWorkspace() {
        QuickHelp.clear();
        Workspace.toggleActive();
        FileExplorer.toggleActive();
    }

    public static void switchToExplorer() {
        QuickHelp.clear();
        Workspace.setActive(false);
        FileExplorer.setActive(true);
    }

    @Override
    public void draw(Graphics2D g) {
    }

    public static void createDialog(Dialog dialog) {
        dialogs.add(dialog);
        GameState.addGameObject(dialog);
    }

    public static synchronized void closeDialog(Dialog dialog) {
        dialogs.remove(dialog);
    }

    public static void createDialog(String title, String content) {
        Dialog d = new Dialog(title, content, Arrays.asList("OK"), null);
        dialogs.add(d);
        GameState.addGameObject(d);
    }

    public static Dialog getTopDialog() {
        if (dialogs.size() > 0) {
            return dialogs.get(dialogs.size() - 1);
        }
        return null;
    }
}

