/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.data.MemorySystem;
import controller.ui.Dialog;
import controller.ui.FileExplorer;
import controller.ui.GlobalUIController;
import controller.ui.UIController;
import controller.ui.Workspace;
import engine.AudioEngineSystem;
import engine.GameObject;
import engine.GraphicsSystem;
import engine.InputSystem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.Arrays;

public class Options
extends UIController
implements GameObject {
    public static boolean soundMute = false;
    public static int colorMode = 0;
    public static int dispMode = 0;
    private static Options instance;
    private static int selectionY;

    static {
        selectionY = 0;
    }

    public Options(int x, int y, int w, int h) {
        super(x, y, w, h);
        instance = this;
    }

    public static void setActive(boolean b) {
        Options.instance.active = b;
    }

    @Override
    public boolean step(float td) {
        if (!this.active || !Workspace.isActive()) {
            return false;
        }
        if (!GlobalUIController.dialogs.isEmpty()) {
            return false;
        }
        boolean draw = false;
        for (KeyEvent e : InputSystem.eventQueue) {
            if (e.getKeyCode() == 37) {
                if (selectionY == 0) {
                    this.toggleSoundMute();
                } else if (selectionY == 1) {
                    Options.setColorMode(colorMode == 0 ? 2 : colorMode - 1);
                } else if (selectionY == 2) {
                    Options.setDispMode(dispMode == 0 ? 2 : dispMode - 1);
                }
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 39) {
                if (selectionY == 0) {
                    this.toggleSoundMute();
                } else if (selectionY == 1) {
                    Options.setColorMode((colorMode + 1) % 3);
                } else if (selectionY == 2) {
                    Options.setDispMode((dispMode + 1) % 3);
                }
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 40) {
                selectionY = (selectionY + 1) % 4;
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 38) {
                selectionY = selectionY == 0 ? 3 : selectionY - 1;
                draw = true;
                continue;
            }
            if (e.getKeyCode() != 10) continue;
            if (selectionY == 3) {
                Dialog d = new Dialog("RESET GAME", "Are you sure you want to reset the game? All progress will be lost!", Arrays.asList("YES", "NO"), new Dialog.OnDialogListener(){

                    @Override
                    public void onFinish(int buttonIndex) {
                        if (buttonIndex == 0) {
                            selectionY = 0;
                            MemorySystem.reset();
                            FileExplorer.previewInWorkspace();
                            GlobalUIController.switchToExplorer();
                            GlobalUIController.createDialog("RESET GAME", "The game has been reset!");
                        }
                    }
                });
                d.buttonIndex = 1;
                GlobalUIController.createDialog(d);
            }
            draw = true;
        }
        return draw;
    }

    public static void setDispMode(int i) {
        if (i == 0) {
            GraphicsSystem.switchToFullscreen();
        } else if (i == 1) {
            GraphicsSystem.switchToBorderless();
        } else if (i == 2) {
            GraphicsSystem.switchToWindow();
        }
        if (GraphicsSystem.fullScreen && !GraphicsSystem.borderless) {
            dispMode = 0;
        } else if (GraphicsSystem.fullScreen && GraphicsSystem.borderless) {
            dispMode = 1;
        } else if (!GraphicsSystem.fullScreen) {
            dispMode = 2;
        }
    }

    public static void setColorMode(int i) {
        colorMode = i;
        GraphicsSystem.setColorMode(i);
    }

    private void toggleSoundMute() {
        soundMute = !soundMute;
        AudioEngineSystem.setMute(soundMute);
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.active) {
            return;
        }
        g.setColor(GraphicsSystem.BRIGHT);
        int x = this.x + 1;
        int y = this.y + 1;
        Options.drawStringWithLineBreaks(g, "Sound: ", x, y + 1);
        this.drawButton(g, "ON", x + 12, y, !soundMute, selectionY == 0);
        this.drawButton(g, "OFF", x + 12 + 7, y, soundMute, selectionY == 0);
        Options.drawStringWithLineBreaks(g, "Color: ", x, (y += 4) + 1);
        this.drawButton(g, "OFF", x + 12, y, colorMode == 0, selectionY == 1);
        this.drawButton(g, "MODE 1", x + 12 + 8, y, colorMode == 1, selectionY == 1);
        this.drawButton(g, "MODE 2", x + 12 + 8 + 11, y, colorMode == 2, selectionY == 1);
        Options.drawStringWithLineBreaks(g, "Display: ", x, (y += 4) + 1);
        this.drawButton(g, "FULLSCREEN", x + 12, y, GraphicsSystem.fullScreen && !GraphicsSystem.borderless, selectionY == 2);
        this.drawButton(g, "BORDERLESS", x + 12 + 8 + 7, y, GraphicsSystem.fullScreen && GraphicsSystem.borderless, selectionY == 2);
        this.drawButton(g, "WINDOW", x + 12 + 8 + 7 + 11 + 4, y, !GraphicsSystem.fullScreen, selectionY == 2);
        Options.drawStringWithLineBreaks(g, "Reset: ", x, (y += 4) + 1);
        this.drawButton(g, "PRESS ENTER", x + 12, y, true, selectionY == 3);
        y += 4;
    }

    private void drawButton(Graphics2D g, String s, int x, int y, boolean active, boolean highlight) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, '-', s.length() + 4).append("\n| ").append(s).append(" |\n");
        this.append(sb, '-', s.length() + 4);
        Options.drawStringWithLineBreaks(g, sb.toString(), x, y);
        if (highlight && active && Workspace.isActive()) {
            g.fillRect((x + 1) * GraphicsSystem.charW, (y + 1) * GraphicsSystem.charH + GraphicsSystem.charOff, GraphicsSystem.charW * (s.length() + 2), GraphicsSystem.charH);
            g.setColor(Color.BLACK);
            g.drawString(s, (x + 2) * GraphicsSystem.charW, (y + 2) * GraphicsSystem.charH);
            g.setColor(GraphicsSystem.BRIGHT);
        }
        if (!active) {
            g.setColor(Color.BLACK);
            g.fillRect((x + 1) * GraphicsSystem.charW, (y + 1) * GraphicsSystem.charH + GraphicsSystem.charOff, GraphicsSystem.charW * (s.length() + 2), GraphicsSystem.charH);
            g.setColor(GraphicsSystem.DARK);
            g.drawString(s, (x + 2) * GraphicsSystem.charW, (y + 2) * GraphicsSystem.charH);
            g.setColor(GraphicsSystem.BRIGHT);
        }
    }

    public static void setSoundMute(boolean s) {
        soundMute = s;
        AudioEngineSystem.setMute(s);
    }
}

