/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.ui.UIController;
import engine.GameObject;
import engine.GraphicsSystem;
import java.awt.Graphics2D;
import java.util.Map;
import java.util.TreeMap;

public class QuickHelp
extends UIController
implements GameObject {
    Map<String, String> shortcuts = new TreeMap<String, String>();
    private static QuickHelp instance;

    public QuickHelp(int x, int y, int w, int h) {
        super(x, y, w, h);
        instance = this;
    }

    @Override
    public boolean step(float td) {
        return false;
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawFrame(false, "QUICK HELP", g);
        int i = this.y + 4;
        for (Map.Entry<String, String> e : QuickHelp.instance.shortcuts.entrySet()) {
            String key = e.getKey();
            g.drawString(key, GraphicsSystem.charW * (this.x + 2), i * GraphicsSystem.charH);
            QuickHelp.drawStringWithLineBreaks(g, (" - " + e.getValue()).replaceAll("\n", "\n   "), this.x + 2 + "CTRL + SPACE".length(), i - 1);
            i += e.getValue().contains("\n") ? 2 : 1;
        }
    }

    public static void addShortcut(String key, String value) {
        QuickHelp.instance.shortcuts.put(key, value);
    }

    public static void removeShortcut(String key) {
        QuickHelp.instance.shortcuts.remove(key);
    }

    public static void clear() {
        QuickHelp.instance.shortcuts.clear();
    }
}

