/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.ui.Cursor;

public class Selection {
    Cursor cur;
    int startX;
    int startY;
    int endX;
    int endY;
    public boolean active = false;

    public Selection(Cursor textCursor) {
        this.cur = textCursor;
    }

    public void update(boolean clear) {
        this.endX = this.cur.x;
        this.endY = this.cur.y;
        if (this.endX == this.startX && this.endY == this.startY || clear) {
            this.active = false;
        }
    }

    public void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.startX = this.endX = this.cur.x;
        this.startY = this.endY = this.cur.y;
    }

    public boolean isEmpty() {
        return !this.active;
    }

    public void clear() {
        this.active = false;
    }

    public Selection normalize() {
        Selection s = new Selection(null);
        s.startX = this.startX;
        s.endX = this.endX;
        s.startY = this.startY;
        s.endY = this.endY;
        if (s.startY > s.endY) {
            s.startY = s.endY;
            s.endY = this.startY;
            s.startX = s.endX;
            s.endX = this.startX;
        } else if (s.startY == s.endY && s.startX > s.endX) {
            s.startX = s.endX;
            s.endX = this.startX;
        }
        return s;
    }
}

