/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.data.DesignRepo;
import controller.ui.GlobalUIController;
import controller.ui.UIController;
import controller.ui.Workspace;
import engine.GameObject;
import engine.GraphicsSystem;
import engine.InputSystem;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.List;
import utils.ScoreUtil;

public class Statistics
extends UIController
implements GameObject {
    private static Statistics instance;
    private static List<String> logicCircuits;
    private static List<String> advancedCircuits;
    private static List<String> memoryCircuits;
    private static List<String> cpuCircuits;
    private int offset = 0;
    private String[] content = null;
    int height;
    private String header;
    private boolean firstRun = true;
    private long lastUpdate = 0L;

    static {
        logicCircuits = Arrays.asList("NAND", "NAND4B", "NAND16B", "NOT", "NOT4B", "NOT16B", "AND", "AND4B", "AND16B", "OR", "OR4B", "OR16B", "OR4W", "OR16W", "XOR", "XOR4B", "XOR16B");
        advancedCircuits = Arrays.asList("MUX", "MUX4B", "MUX16B", "MUX4W16B", "DEMUX", "DEMUX4W", "HALFADDER", "FULLADDER", "ADDER4B", "ADDER16B", "ALU4B", "ALU16B");
        memoryCircuits = Arrays.asList("DFF", "REGISTER", "REGISTER4B", "REGISTER16B", "RAM4W16B", "RAM64KW16B", "COUNTER4B", "COUNTER16B");
        cpuCircuits = Arrays.asList("DECODER", "CPU");
    }

    public Statistics(int x, int y, int w, int h) {
        super(x, y, w, h);
        instance = this;
        this.height = h - 2;
        StringBuilder sb = new StringBuilder();
        this.append(sb, ' ', 20).append("Your Top Score");
        sb.append("  Top Score (Friend)");
        sb.append("  Top Score (Global)").append("\n");
        this.append(sb, ' ', 20).append("--------------");
        sb.append("  ------------------");
        sb.append("  ------------------").append("\n\n");
        this.header = sb.toString();
    }

    public static void setActive(boolean b) {
        Statistics.instance.active = b;
    }

    @Override
    public boolean step(float td) {
        if (!this.active) {
            this.firstRun = true;
            return false;
        }
        boolean draw = false;
        if (ScoreUtil.updateAvailable) {
            ScoreUtil.updateAvailable = false;
            draw = true;
        }
        if (System.currentTimeMillis() - this.lastUpdate > 10000L) {
            this.lastUpdate = System.currentTimeMillis();
            ScoreUtil.updateAllScores();
        }
        if (draw || this.firstRun) {
            this.firstRun = false;
            StringBuilder sb = new StringBuilder();
            sb = this.buildSection("Logic Circuits", logicCircuits, sb);
            sb = this.buildSection("Advanced Circuits", advancedCircuits, sb);
            sb = this.buildSection("Memory Circuits", memoryCircuits, sb);
            sb = this.buildSection("CPU Circuits", cpuCircuits, sb);
            this.content = sb.toString().split("\n");
        }
        if (!GlobalUIController.dialogs.isEmpty() || !Workspace.isActive()) {
            return draw;
        }
        for (KeyEvent e : InputSystem.eventQueue) {
            if (e.getKeyChar() == '\t' && !e.isShiftDown() && !e.isControlDown()) {
                this.nextTab();
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 38) {
                this.offset = this.offset == 0 ? 0 : this.offset - 1;
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 40) {
                if (this.content == null) continue;
                if (this.offset + this.height < this.content.length) {
                    ++this.offset;
                }
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 33) {
                this.offset = this.offset <= this.height ? 0 : this.offset - this.height;
                draw = true;
                continue;
            }
            if (e.getKeyCode() != 34 || this.content == null) continue;
            this.offset = this.offset + this.height * 2 < this.content.length ? (this.offset += this.height) : this.content.length - this.height;
            if (this.offset < 0) {
                this.offset = 0;
            }
            draw = true;
        }
        return draw;
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.active) {
            return;
        }
        g.setColor(GraphicsSystem.BRIGHT);
        int headerSize = this.header.split("\n").length;
        Statistics.drawStringWithLineBreaks(g, this.header, this.x, this.y);
        if (this.content != null) {
            StringBuilder sb = new StringBuilder();
            int i = this.offset;
            while (i < this.offset + this.height && i < this.content.length) {
                sb.append(this.content[i]).append('\n');
                ++i;
            }
            Statistics.drawStringWithLineBreaks(g, sb.toString(), this.x + 1, this.y + headerSize);
            if (this.content.length > this.height) {
                int scrollBarOffset = this.height * this.offset / this.content.length;
                int scrollBarHeigth = this.height * this.height / this.content.length + 1;
                String scrollBar = "";
                int i2 = 0;
                while (i2 < scrollBarHeigth && scrollBarOffset + i2 < this.height) {
                    scrollBar = String.valueOf(scrollBar) + "|\n";
                    ++i2;
                }
                Statistics.drawStringWithLineBreaks(g, scrollBar, this.x + this.w - 2, this.y + headerSize + scrollBarOffset);
            }
        }
    }

    private StringBuilder buildSection(String title, List<String> circuits, StringBuilder sb) {
        boolean sectionEmpty = true;
        for (String s : circuits) {
            if (!DesignRepo.statsMap.containsKey(s)) continue;
            sectionEmpty = false;
            break;
        }
        if (sectionEmpty) {
            return sb;
        }
        this.append(sb.append(String.valueOf(title) + "\n"), '-', title.length()).append('\n');
        for (String s : circuits) {
            if (!DesignRepo.statsMap.containsKey(s)) continue;
            sb = this.buildStatLine(sb, s);
        }
        sb.append('\n');
        return sb;
    }

    private StringBuilder buildStatLine(StringBuilder sb, String deviceType) {
        this.append(sb.append("  " + deviceType), ' ', 18 - ("  " + deviceType).length());
        String count = "" + DesignRepo.getNandCount(deviceType);
        this.append(sb, ' ', 15 - count.length()).append(count);
        ScoreUtil.Score score = ScoreUtil.getScore(deviceType, true);
        count = score.getScore();
        String name = score.getName();
        if (!name.isEmpty()) {
            name = "(" + name.substring(0, Math.min(name.length(), 18 - count.length() - 3)) + ") ";
        }
        String composed = String.valueOf(name) + count;
        this.append(sb, ' ', 20 - composed.length()).append(composed);
        score = ScoreUtil.getScore(deviceType, false);
        count = score.getScore();
        name = score.getName();
        if (!name.isEmpty()) {
            name = "(" + name.substring(0, Math.min(name.length(), 18 - count.length() - 3)) + ") ";
        }
        composed = String.valueOf(name) + count;
        this.append(sb, ' ', 20 - composed.length()).append(composed).append("\n");
        return sb;
    }
}

