/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.ui.CodeEditor;
import controller.ui.Options;
import controller.ui.QuickHelp;
import controller.ui.Statistics;
import engine.GraphicsSystem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class UIController {
    boolean active = false;
    public int x;
    public int y;
    public int w;
    public int h;
    public List<String> tabs = new ArrayList<String>();
    int activeTabElement = 0;

    public UIController(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public void drawFrame(boolean active, String title, Graphics2D g) {
        this.drawFrame(active, title, g, this.x, this.y, this.w, this.h);
    }

    protected void drawFrame(boolean active, String title, Graphics2D g, int x, int y, int w, int h) {
        if (active) {
            g.setColor(GraphicsSystem.BRIGHT);
        } else {
            g.setColor(GraphicsSystem.MEDIUM);
        }
        StringBuilder sb = new StringBuilder();
        this.append(sb.append('+'), '-', w - 2).append("+\n");
        this.append(sb.append('|'), ' ', w - 2).append("|\n");
        this.append(sb.append('+'), '-', w - 2).append("+\n");
        int i = 0;
        while (i < h - 4) {
            this.append(sb.append('|'), ' ', w - 2).append("|\n");
            ++i;
        }
        this.append(sb.append('+'), '-', w - 2).append("+\n");
        UIController.drawStringWithLineBreaks(g, sb.toString(), x, y);
        g.drawString(title, (x + w / 2 - title.length() / 2) * GraphicsSystem.charW, (y + 2) * GraphicsSystem.charH);
    }

    public static void drawStringWithLineBreaks(Graphics2D g, String string, int x, int y) {
        String[] lines = string.split("\n");
        int i = 0;
        while (i < lines.length) {
            g.drawString(lines[i], x * GraphicsSystem.charW, (y + 1 + i) * GraphicsSystem.charH);
            ++i;
        }
    }

    protected StringBuilder append(StringBuilder sb, char c, int n) {
        int i = 0;
        while (i < n) {
            sb.append(c);
            ++i;
        }
        return sb;
    }

    public void drawTabRow(Graphics2D g) {
        g.setColor(GraphicsSystem.MEDIUM);
        int ix = this.x + 1;
        int activeXStart = 0;
        int activeXEnd = 0;
        int i = 0;
        while (i < this.tabs.size()) {
            String s = this.activeTabElement == i && i == 0 ? " " + this.tabs.get(i) + " \\" : (this.activeTabElement == i && i > 0 ? "/ " + this.tabs.get(i) + " \\" : (this.activeTabElement == i + 1 ? " " + this.tabs.get(i) + " " : " " + this.tabs.get(i) + " \\"));
            if (this.activeTabElement == i) {
                activeXStart = ix;
                activeXEnd = ix + s.length();
                if (this.active) {
                    g.setColor(GraphicsSystem.BRIGHT);
                    g.fillRect((activeXStart + 1 + (i == 0 ? 0 : 1)) * GraphicsSystem.charW, (this.y + 3) * GraphicsSystem.charH + GraphicsSystem.charOff, (s.length() - 3 - (i == 0 ? 0 : 1)) * GraphicsSystem.charW, GraphicsSystem.charH);
                    g.drawString(s.substring(0, 1), ix * GraphicsSystem.charW, (this.y + 4) * GraphicsSystem.charH);
                    g.drawString("\\", (ix + s.length() - 1) * GraphicsSystem.charW, (this.y + 4) * GraphicsSystem.charH);
                    g.setColor(Color.BLACK);
                    g.drawString(s.substring(1, s.length() - 2), (ix + 1) * GraphicsSystem.charW, (this.y + 4) * GraphicsSystem.charH);
                    g.setColor(GraphicsSystem.MEDIUM);
                } else {
                    g.setColor(GraphicsSystem.BRIGHT);
                    g.drawString(s, ix * GraphicsSystem.charW, (this.y + 4) * GraphicsSystem.charH);
                    g.setColor(GraphicsSystem.MEDIUM);
                }
            } else {
                g.drawString(s, ix * GraphicsSystem.charW, (this.y + 4) * GraphicsSystem.charH);
            }
            ix += s.length();
            ++i;
        }
        g.setColor(GraphicsSystem.BRIGHT);
        StringBuilder sb = new StringBuilder();
        this.append(sb, '-', activeXStart - (this.x + 1));
        this.append(sb, ' ', activeXEnd - activeXStart);
        this.append(sb, '-', this.x + 1 + this.w - 2 - activeXEnd);
        g.drawString(sb.toString(), (this.x + 1) * GraphicsSystem.charW, (this.y + 5) * GraphicsSystem.charH);
    }

    public void prevTab() {
        this.activeTabElement = this.activeTabElement - 1 < 0 ? this.tabs.size() - 1 : this.activeTabElement - 1;
        this.updateTabPaneStatus();
    }

    public void nextTab() {
        if (this.tabs.size() > 0) {
            this.activeTabElement = (this.activeTabElement + 1) % this.tabs.size();
            this.updateTabPaneStatus();
        }
    }

    public String getActiveTab() {
        return this.tabs.size() > 0 ? this.tabs.get(this.activeTabElement) : "";
    }

    public void setActiveTab(String string) {
        int i = 0;
        while (i < this.tabs.size()) {
            if (this.tabs.get(i).equals(string)) {
                this.activeTabElement = i;
                this.updateTabPaneStatus();
                return;
            }
            ++i;
        }
    }

    private void updateTabPaneStatus() {
        if (CodeEditor.autoCompleteActive) {
            CodeEditor.toggleAutoCompleteActive();
            QuickHelp.addShortcut("ESC", "Activate Explorer");
        }
        CodeEditor.setActive(this.getActiveTab().equals("Design") || this.getActiveTab().equals("Working Design"));
        Options.setActive(this.getActiveTab().equals("Options"));
        Statistics.setActive(this.getActiveTab().equals("Statistics"));
    }
}

