/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.data.DesignRepo;
import controller.ui.Dialog;
import controller.ui.GlobalUIController;
import controller.ui.Workspace;
import engine.GameState;
import engine.GraphicsSystem;
import engine.InputSystem;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import model.Design;
import simulator.HardwareDesign;
import simulator.Parser;
import simulator.TestExecution;
import simulator.TestReport;
import simulator.devices.CustomDevice;
import utils.StopWatch;

public class VerificationDialog
extends Dialog {
    private TestReport testReport;
    private int offset;
    private int height = 27;
    private HardwareDesign hwd;
    private boolean showingActualResults = true;
    private int nandCount;

    public VerificationDialog(String designCode, Dialog.OnDialogListener onDialogListener) {
        super("VERIFICATION", "", Arrays.asList("OK"), onDialogListener);
        Design currentDesign = Workspace.getCurrentDesign();
        this.hwd = Parser.parseDesign(currentDesign);
        if (currentDesign.completed && this.hwd.compilationProblems.isEmpty()) {
            List<String> parseDeviceTypes = Parser.parseDeviceTypes(DesignRepo.getAltImpl(currentDesign.name));
            String dependencyPath = null;
            for (String partName : parseDeviceTypes) {
                dependencyPath = this.findCircularDependency(currentDesign.name, partName, new HashSet<String>());
                if (dependencyPath == null) continue;
                this.hwd.compilationProblems.add("Design contains circular dependency:\n  " + currentDesign.name + "->" + dependencyPath);
                break;
            }
        }
        if (!this.hwd.compilationProblems.isEmpty()) {
            return;
        }
        this.testReport = this.createTestReport(this.hwd);
        if (!this.testReport.success) {
            this.buttons = Arrays.asList("OK", "SHOW EXPECTED OUTPUTS");
            this.determineDimensions();
        } else {
            this.nandCount = DesignRepo.calcStats(designCode);
        }
        if (!this.testReport.success && this.testReport.exes.size() > this.height) {
            this.buttons = Arrays.asList("OK", "SHOW EXPECTED OUTPUTS", "JUMP TO NEXT FAILED TEST");
            this.determineDimensions();
        }
    }

    private String findCircularDependency(String device, String candidate, HashSet<String> hashSet) {
        if (device.equals(candidate)) {
            return device;
        }
        hashSet.add(candidate);
        for (String s : DesignRepo.dependencyMap.get(candidate)) {
            String result;
            if (hashSet.contains(s) || (result = this.findCircularDependency(device, s, hashSet)) == null) continue;
            return String.valueOf(candidate) + "->" + result;
        }
        return null;
    }

    @Override
    public boolean step(float td) {
        boolean draw = false;
        if (this.drawOnce) {
            this.drawOnce = false;
            draw = true;
        }
        for (KeyEvent e : InputSystem.eventQueue) {
            if (e.getKeyCode() == 38) {
                this.offset = this.offset == 0 ? 0 : this.offset - 1;
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 37) {
                this.buttonIndex = this.buttonIndex == 0 ? this.buttons.size() - 1 : this.buttonIndex - 1;
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 39) {
                this.buttonIndex = (this.buttonIndex + 1) % this.buttons.size();
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 40) {
                if (this.testReport == null) continue;
                if (this.offset + this.height < this.testReport.exes.size()) {
                    ++this.offset;
                }
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 33) {
                this.offset = this.offset <= this.height ? 0 : this.offset - this.height;
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 34) {
                if (this.testReport == null) continue;
                this.offset = this.offset + this.height * 2 < this.testReport.exes.size() ? (this.offset += this.height) : this.testReport.exes.size() - this.height;
                if (this.offset < 0) {
                    this.offset = 0;
                }
                draw = true;
                continue;
            }
            if (e.getKeyCode() != 10) continue;
            if (this.buttonIndex == 0) {
                GlobalUIController.closeDialog(this);
                if (this.onDialogListener != null) {
                    this.onDialogListener.onFinish(this.testReport != null && this.testReport.success ? 1 : 0);
                }
                GameState.deleteGameObject(this);
            } else if (this.buttonIndex == 1) {
                this.showingActualResults = !this.showingActualResults;
                this.buttons.set(1, this.showingActualResults ? "SHOW EXPECTED OUTPUTS" : "SHOW ACTUAL OUTPUTS");
            } else if (this.buttonIndex == 2) {
                int i = this.offset + 1;
                while (i < this.testReport.exes.size()) {
                    if (!this.testReport.exes.get((int)i).success) {
                        this.offset = i;
                        break;
                    }
                    ++i;
                }
            }
            draw = true;
        }
        if (draw) {
            if (!this.hwd.compilationProblems.isEmpty()) {
                this.createCompilationErrorDialog();
            } else {
                this.createTestReportDialog();
            }
            this.determineDimensions();
            --this.x;
            this.w += 2;
        }
        return draw;
    }

    private void createTestReportDialog() {
        int size;
        StringBuilder sbTitle = new StringBuilder();
        if (this.testReport.success) {
            sbTitle.append("VERIFICATION PASSED!\n\n");
        } else {
            int failedN = 0;
            for (TestExecution tx : this.testReport.exes) {
                if (tx.success) continue;
                ++failedN;
            }
            sbTitle.append("VERIFICATION FAILED!\n(" + failedN + " of " + this.testReport.exes.size() + " tests failed)\n\n");
        }
        if (this.testReport.success) {
            sbTitle.append("Total NAND count: " + this.nandCount + "\n\n");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Test# ||");
        int inputsLength = this.determineInputIdLength();
        if (inputsLength > " Inputs ".length()) {
            int spaces = inputsLength - "Inputs".length();
            this.append(sb, ' ', spaces / 2).append("Inputs");
            this.append(sb, ' ', spaces - spaces / 2).append("||");
        } else {
            sb.append(" Inputs ||");
        }
        int outputsLength = this.determineOutputIdLength();
        String outStr = this.showingActualResults ? "Actual Outputs  " : "Expected Outputs";
        String string = outStr = this.testReport.success ? "Outputs" : outStr;
        if (outputsLength > outStr.length() + 2) {
            int spaces = outputsLength - outStr.length();
            this.append(sb, ' ', spaces / 2).append(outStr);
            this.append(sb, ' ', spaces - spaces / 2).append("||");
        } else {
            sb.append(" " + outStr + " ||");
        }
        sb.append(" Result\n");
        int lineWidth = sb.length() - 1;
        this.append(sb, ' ', "Test# ".length());
        sb.append("||");
        this.append(sb, '-', Math.max(inputsLength, " Inputs ".length())).append("||");
        this.append(sb, '-', Math.max(outputsLength, outStr.length() + 2)).append("||");
        this.append(sb, ' ', " Result".length());
        sb.append('\n');
        this.append(sb, ' ', "Test# ".length());
        sb.append("|");
        for (String s : this.testReport.getInputPinsOnly()) {
            sb.append("| " + s + " ");
        }
        for (String s : this.testReport.getInputBussesOnly().keySet()) {
            size = this.testReport.getInputBussesOnly().get(s);
            int n = size = size > 8 ? 6 : size;
            if (size > s.length()) {
                sb.append('|');
                sb.append(' ').append(s);
                this.append(sb, ' ', size - s.length() + 1);
                continue;
            }
            sb.append("| " + s + " ");
        }
        if (inputsLength < " Inputs ".length()) {
            int spaces = " Inputs ".length() - inputsLength;
            this.append(sb, ' ', spaces);
        }
        sb.append('|');
        for (String s : this.testReport.getOutputPinsOnly()) {
            sb.append("| " + s + " ");
        }
        for (String s : this.testReport.getOutputBussesOnly().keySet()) {
            size = this.testReport.getOutputBussesOnly().get(s);
            int n = size = size > 8 ? 6 : size;
            if (size > s.length()) {
                sb.append("| ").append(s);
                this.append(sb, ' ', size - s.length() + 1);
                continue;
            }
            sb.append("| " + s + " ");
        }
        if (outputsLength < outStr.length() + 2) {
            int spaces = outStr.length() - outputsLength + 2;
            this.append(sb, ' ', spaces);
        }
        sb.append("||");
        this.append(sb, ' ', " Result".length());
        sb.append('\n');
        this.append(sb, '-', lineWidth);
        sb.append('\n');
        int testNo = this.offset + 1;
        while (testNo - this.offset <= this.height && testNo <= this.testReport.exes.size()) {
            int i;
            StringBuilder sbNumber;
            TestExecution tx = this.testReport.exes.get(testNo - 1);
            sb.append(String.format("%-5s", String.valueOf(testNo))).append(" |");
            for (String s : this.testReport.getInputPinsOnly()) {
                sb.append("| " + tx.preCond.get(s));
                this.append(sb, ' ', s.length() - 1);
                sb.append(" ");
            }
            for (String s : this.testReport.getInputBussesOnly().keySet()) {
                sb.append("| ");
                sbNumber = new StringBuilder();
                i = 0;
                while (i < this.testReport.getInputBussesOnly().get(s)) {
                    sbNumber.append(tx.preCond.get(String.valueOf(s) + "\u00a7" + (i + 1)));
                    ++i;
                }
                sbNumber = this.transform(sbNumber);
                sb.append((CharSequence)sbNumber);
                if (sbNumber.length() < s.length()) {
                    this.append(sb, ' ', s.length() - sbNumber.length());
                }
                sb.append(" ");
            }
            if (inputsLength < " Inputs ".length()) {
                int spaces = " Inputs ".length() - inputsLength;
                this.append(sb, ' ', spaces);
            }
            sb.append('|');
            for (String s : this.testReport.getOutputPinsOnly()) {
                if (!this.showingActualResults) {
                    if (tx.postCond.get(s) != null) {
                        sb.append("| " + tx.postCond.get(s));
                    } else {
                        sb.append("| x");
                    }
                } else {
                    sb.append("| " + tx.actual.get(s));
                }
                this.append(sb, ' ', s.length() - 1);
                sb.append(" ");
            }
            for (String s : this.testReport.getOutputBussesOnly().keySet()) {
                sb.append("| ");
                sbNumber = new StringBuilder();
                i = 0;
                while (i < this.testReport.getOutputBussesOnly().get(s)) {
                    if (!this.showingActualResults) {
                        if (tx.postCond.get(String.valueOf(s) + "\u00a7" + (i + 1)) != null) {
                            sbNumber.append(tx.postCond.get(String.valueOf(s) + "\u00a7" + (i + 1)));
                        } else {
                            sbNumber.append("x");
                        }
                    } else {
                        sbNumber.append(tx.actual.get(String.valueOf(s) + "\u00a7" + (i + 1)));
                    }
                    ++i;
                }
                sbNumber = this.transform(sbNumber);
                sb.append((CharSequence)sbNumber);
                if (sbNumber.length() < s.length()) {
                    this.append(sb, ' ', s.length() - sbNumber.length());
                }
                sb.append(" ");
            }
            if (outputsLength < outStr.length() + 2) {
                int spaces = outStr.length() - outputsLength + 2;
                this.append(sb, ' ', spaces);
            }
            sb.append("||");
            if (tx.success) {
                sb.append(" PASSED\n");
            } else {
                sb.append(" FAILED\n");
            }
            ++testNo;
        }
        sb.append('\n');
        sbTitle.append((CharSequence)sb);
        this.content = sbTitle.toString().split("\n");
    }

    private int determineOutputIdLength() {
        int length = 0;
        for (String s : this.testReport.getOutputPinsOnly()) {
            length += (" " + s + " |").length();
        }
        for (String s : this.testReport.getOutputBussesOnly().keySet()) {
            int size = this.testReport.getOutputBussesOnly().get(s);
            size = size > 8 ? 6 : size;
            length += Math.max(size, s.length()) + 3;
        }
        return --length;
    }

    private int determineInputIdLength() {
        int length = 0;
        for (String s : this.testReport.getInputPinsOnly()) {
            length += (" " + s + " |").length();
        }
        for (String s : this.testReport.getInputBussesOnly().keySet()) {
            int size = this.testReport.getInputBussesOnly().get(s);
            size = size > 8 ? 6 : size;
            length += Math.max(size, s.length()) + 3;
        }
        return --length;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (this.testReport != null && this.testReport.exes.size() > this.height) {
            int scrollBarOffset = this.height * this.offset / this.testReport.exes.size();
            int scrollBarHeigth = this.height * this.height / this.testReport.exes.size() + 1;
            String scrollBar = "";
            int i = 0;
            while (i < scrollBarHeigth && scrollBarOffset + i < this.height) {
                scrollBar = String.valueOf(scrollBar) + "|\n";
                ++i;
            }
            VerificationDialog.drawStringWithLineBreaks(g, scrollBar, this.x + this.w - 2, this.y + (this.testReport.success ? 12 : 13) + scrollBarOffset);
        }
    }

    private void createCompilationErrorDialog() {
        StringBuilder sb = new StringBuilder();
        sb.append("VERIFICATION FAILED!\n\nFollowing errors were found in the design:\n");
        this.append(sb, '-', "Following errors were found in the design:".length()).append('\n');
        for (String s : this.hwd.compilationProblems) {
            if (s.contains("\u00a7")) {
                while (s.indexOf(167) >= 0) {
                    int pos = s.indexOf(167);
                    s = s.replaceFirst("\u00a7", "[");
                    int i = pos + 1;
                    while (s.charAt(i) >= '0' && s.charAt(i) <= '9') {
                        ++i;
                    }
                    s = String.valueOf(s.substring(0, i)) + "]" + s.substring(i, s.length());
                }
            }
            sb.append("- ").append(s).append('\n');
        }
        this.content = sb.toString().split("\n");
    }

    private TestReport createTestReport(HardwareDesign hwd) {
        StopWatch sw = new StopWatch();
        sw.start();
        CustomDevice device = new CustomDevice("x", hwd);
        return device.testReport;
    }

    private StringBuilder transform(StringBuilder sbNumber) {
        if (sbNumber.length() > 8) {
            StringBuilder hex = new StringBuilder();
            int num = 0;
            int i = sbNumber.length() - 1;
            while (i >= 0) {
                num = (num << 1) + (sbNumber.charAt(i) == '1' ? 1 : 0);
                --i;
            }
            String hexStr = Integer.toHexString(num);
            hexStr = String.format("%4s", hexStr);
            hexStr = hexStr.replace(' ', '0');
            if (sbNumber.charAt(0) == 'x') {
                hexStr = hexStr.replace('0', 'X');
            }
            hex.append("0x");
            hex.append(hexStr);
            sbNumber = hex;
        } else {
            sbNumber = sbNumber.reverse();
        }
        return sbNumber;
    }

    @Override
    void drawContent(Graphics2D g) {
        boolean left = false;
        int y = this.y + 5;
        String[] stringArray = this.content;
        int n = this.content.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.contains("- ")) {
                left = true;
            }
            int leftX = this.x + 2;
            int x = this.x;
            if (left) {
                g.drawString(s, leftX * GraphicsSystem.charW, GraphicsSystem.charH * y++);
            } else {
                g.drawString(s, (x + this.w / 2 - s.length() / 2) * GraphicsSystem.charW, GraphicsSystem.charH * y++);
            }
            ++n2;
        }
    }
}

