/*
 * Decompiled with CFR 0.152.
 */
package controller.ui;

import controller.data.DesignRepo;
import controller.data.MemorySystem;
import controller.ui.CodeEditor;
import controller.ui.GlobalUIController;
import controller.ui.Options;
import controller.ui.QuickHelp;
import controller.ui.Statistics;
import controller.ui.UIController;
import engine.AudioEngineSystem;
import engine.GameObject;
import engine.GraphicsSystem;
import engine.InputSystem;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import model.Design;

public class Workspace
extends UIController
implements GameObject {
    private static Workspace instance;
    private Design currentDesign;
    private String title = "WORKSPACE";
    private int offset = 0;
    private String[] content = null;
    int height;

    public Workspace(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.height = h - 6;
        instance = this;
        AudioEngineSystem.stopPlayingCurrentSound();
    }

    @Override
    public boolean step(float td) {
        if (!this.active) {
            return false;
        }
        if (!GlobalUIController.dialogs.isEmpty()) {
            return false;
        }
        boolean draw = false;
        for (KeyEvent e : InputSystem.eventQueue) {
            if (e.getKeyChar() == '\t' && !e.isShiftDown() && !e.isControlDown()) {
                this.nextTab();
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 38) {
                if (this.content == null) continue;
                this.offset = this.offset == 0 ? 0 : this.offset - 1;
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 40) {
                if (this.content == null) continue;
                if (this.offset + this.height < this.content.length) {
                    ++this.offset;
                }
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 33) {
                this.offset = this.offset <= this.height ? 0 : this.offset - this.height;
                draw = true;
                continue;
            }
            if (e.getKeyCode() == 34) {
                if (this.content == null) continue;
                this.offset = this.offset + this.height * 2 < this.content.length ? (this.offset += this.height) : this.content.length - this.height;
                if (this.offset < 0) {
                    this.offset = 0;
                }
                draw = true;
                continue;
            }
            if (e.getKeyChar() != '\t' || !e.isShiftDown() || e.isControlDown()) continue;
            this.prevTab();
            draw = true;
        }
        return draw;
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawFrame(this.active, this.title, g);
        if (this.tabs != null && !this.tabs.isEmpty() && this.tabs.size() > 1) {
            this.drawTabRow(g);
        }
        g.setColor(GraphicsSystem.BRIGHT);
        this.content = null;
        if (this.getActiveTab().equals("Briefing")) {
            this.content = this.addLineBreaks(this.currentDesign.briefing).split("\n");
        } else if (this.getActiveTab().equals("Specification")) {
            this.content = this.addLineBreaks(this.currentDesign.spec).split("\n");
        } else if (this.getActiveTab().equals("Finished Design")) {
            this.content = this.addLineBreaks(this.currentDesign.code).split("\n");
        }
        if (this.content != null) {
            int offset;
            StringBuilder sb = new StringBuilder();
            int i = offset = !this.getActiveTab().equals("Finished Design") ? Workspace.instance.offset : 0;
            while (i < offset + this.height && i < this.content.length) {
                sb.append(this.content[i]).append('\n');
                ++i;
            }
            this.drawText(g, sb.toString());
            if (this.content.length > this.height) {
                int scrollBarOffset = this.height * offset / this.content.length;
                int scrollBarHeigth = this.height * this.height / this.content.length + 1;
                String scrollBar = "";
                int i2 = 0;
                while (i2 < scrollBarHeigth && scrollBarOffset + i2 < this.height) {
                    scrollBar = String.valueOf(scrollBar) + "|\n";
                    ++i2;
                }
                Workspace.drawStringWithLineBreaks(g, scrollBar, this.x + this.w - 2, this.y + 5 + scrollBarOffset);
            }
        }
    }

    private void drawText(Graphics2D g, String string) {
        Workspace.drawStringWithLineBreaks(g, this.addLineBreaks(string), this.x + 1, this.y + 5);
    }

    private String addLineBreaks(String s) {
        int lastLineBreak = 0;
        int lastSpace = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                lastLineBreak = i;
            } else if (i - lastLineBreak >= this.w - 2) {
                if (lastSpace <= lastLineBreak) {
                    lastSpace = i;
                } else {
                    s = String.valueOf(s.substring(0, lastSpace)) + "\n" + s.substring(lastSpace + 1);
                    lastLineBreak = i = lastSpace - 1;
                }
            } else if (s.charAt(i) == ' ') {
                lastSpace = i;
            }
            ++i;
        }
        return s;
    }

    public static void setCurrentDesign(Design d) {
        if (Workspace.instance.currentDesign == d) {
            return;
        }
        Workspace.instance.offset = 0;
        Workspace.instance.content = null;
        if (Workspace.instance.currentDesign != null && Workspace.instance.currentDesign.code != null) {
            Workspace.setCurrentDesignCode(CodeEditor.getCode());
            CodeEditor.setCode("");
            MemorySystem.save();
        }
        Workspace.instance.title = "WORKSPACE - " + d.getName();
        Workspace.instance.tabs.clear();
        Workspace.instance.activeTabElement = 0;
        CodeEditor.setActive(false);
        Options.setActive(false);
        Statistics.setActive(false);
        if (d.briefing != null) {
            Workspace.instance.tabs.add("Briefing");
        }
        if (d.spec != null) {
            Workspace.instance.tabs.add("Specification");
        }
        if (d.code != null) {
            Workspace.instance.activeTabElement = 0;
            if (d.completed) {
                Workspace.instance.tabs.add("Finished Design");
                Workspace.instance.tabs.add("Working Design");
                CodeEditor.setCode(DesignRepo.getAltImpl(d.name));
            } else {
                Workspace.instance.tabs.add("Design");
                CodeEditor.setCode(d.code);
            }
        }
        if (d.name.equals("Settings")) {
            Options.setActive(true);
            Workspace.instance.tabs.add("Options");
            Workspace.instance.tabs.add("Statistics");
        }
        Workspace.instance.currentDesign = d;
    }

    public static boolean isActive() {
        return Workspace.instance.active;
    }

    public static void toggleActive() {
        Workspace.setCurrentDesignCode(CodeEditor.getCode());
        MemorySystem.save();
        boolean bl = Workspace.instance.active = !Workspace.instance.active;
        if (Workspace.isActive()) {
            QuickHelp.addShortcut("ESC", "Activate Explorer");
            CodeEditor.setActive(false);
            if (Workspace.instance.tabs.size() > 1) {
                QuickHelp.addShortcut("TAB", "Switch Tabs");
            }
            if (instance.getActiveTab().equals("Design") || instance.getActiveTab().equals("Working Design")) {
                Workspace.goToCode();
            }
        }
        if (!Workspace.instance.active) {
            CodeEditor.disableTextCursor();
        }
    }

    public static void setCurrentDesignCode(String code) {
        if (Workspace.instance.currentDesign != null && Workspace.instance.currentDesign.code != null) {
            if (!Workspace.instance.currentDesign.completed) {
                Workspace.instance.currentDesign.code = code;
            } else {
                DesignRepo.altImplMap.put(Workspace.instance.currentDesign.name, code);
            }
        }
    }

    public static Design getCurrentDesign() {
        return Workspace.instance.currentDesign;
    }

    public static void goToCode() {
        if (Workspace.instance.tabs.contains("Design")) {
            instance.setActiveTab("Design");
        } else if (Workspace.instance.tabs.contains("Working Design")) {
            instance.setActiveTab("Working Design");
        }
    }

    public static void clear() {
        Workspace.instance.currentDesign = null;
        Workspace.instance.tabs.clear();
        Workspace.instance.title = "WORKSPACE";
        CodeEditor.setActive(false);
        Options.setActive(false);
    }

    public static void setActive(boolean b) {
        Workspace.setCurrentDesignCode(CodeEditor.getCode());
        MemorySystem.save();
        if (Workspace.isActive() != b) {
            Workspace.toggleActive();
        }
    }
}

