/*
 * Decompiled with CFR 0.152.
 */
package engine;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import utils.Logger;
import utils.Resources;

public class AudioEngineSystem {
    private static boolean muted = false;
    private static Clip looping = null;
    private static Clip lastSound = null;
    private static Clip bootSound;

    public static void setMute(boolean state) {
        muted = state;
        if (!state) {
            if (looping == null) {
                AudioEngineSystem.loopSound("noise");
            }
            return;
        }
        if (looping != null) {
            looping.stop();
            looping = null;
        }
        if (lastSound != null) {
            lastSound.stop();
        }
    }

    public static void playSound(String name) {
        if (muted) {
            return;
        }
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(Resources.getAudio(name));
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            final Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            clip.start();
            lastSound = clip;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    long duration = clip.getMicrosecondLength() + 2000L;
                    try {
                        Thread.sleep(duration);
                    }
                    catch (InterruptedException e) {
                        Logger.log(e);
                    }
                    clip.close();
                }
            }).start();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void loopSound(String name) {
        if (muted) {
            return;
        }
        try {
            if (looping != null) {
                looping.stop();
            }
            AudioInputStream stream = AudioSystem.getAudioInputStream(Resources.getAudio(name));
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            looping = (Clip)AudioSystem.getLine(info);
            looping.open(stream);
            looping.loop(-1);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void stopPlayingCurrentSound() {
        if (lastSound != null) {
            lastSound.stop();
        }
    }

    public static void stopBootSound() {
        if (bootSound != null) {
            bootSound.stop();
        }
    }

    public static void playBootSound() {
        AudioEngineSystem.playSound("boot");
        bootSound = lastSound;
    }
}

