/*
 * Decompiled with CFR 0.152.
 */
package engine;

import controller.data.MemorySystem;
import controller.ui.CodeEditor;
import controller.ui.FileExplorer;
import controller.ui.GlobalUIController;
import controller.ui.Options;
import controller.ui.QuickHelp;
import controller.ui.Statistics;
import controller.ui.Workspace;
import engine.GameObject;
import engine.GraphicsSystem;
import intro.Intro;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class GameState {
    private static State gameState = null;
    private static State newState = null;
    public static List<GameObject> gameObjects = new ArrayList<GameObject>();
    private static List<GameObject> newGameObjects = new ArrayList<GameObject>();
    private static List<GameObject> removeGameObjects = new ArrayList<GameObject>();

    public static boolean step(float td) {
        boolean repaint = false;
        for (GameObject o : gameObjects) {
            repaint |= o.step(td);
        }
        if (newState != null) {
            GameState.changeState();
        }
        gameObjects.addAll(newGameObjects);
        gameObjects.removeAll(removeGameObjects);
        removeGameObjects.clear();
        newGameObjects.clear();
        return repaint;
    }

    private static void changeState() {
        gameState = newState;
        newState = null;
        gameObjects.clear();
        switch (gameState) {
            case Init: {
                gameObjects.add(new GameObject(){

                    @Override
                    public boolean step(float td) {
                        return true;
                    }

                    @Override
                    public void draw(Graphics2D g) {
                    }
                });
                break;
            }
            case Intro: {
                int xOffset = (GraphicsSystem.getScreenWidth() - 120 * GraphicsSystem.charW) / 2 / GraphicsSystem.charW;
                int yOffset = (GraphicsSystem.getScreenHeight() - 45 * GraphicsSystem.charH) / 2 / GraphicsSystem.charH;
                gameObjects.add(new Intro(xOffset, yOffset, 120, 45));
                break;
            }
            case Boot: 
            case Shell: {
                gameObjects.clear();
                int xOffset = (GraphicsSystem.getScreenWidth() - 120 * GraphicsSystem.charW) / 2 / GraphicsSystem.charW;
                int yOffset = (GraphicsSystem.getScreenHeight() - 45 * GraphicsSystem.charH) / 2 / GraphicsSystem.charH;
                FileExplorer fe = new FileExplorer(xOffset + 0, yOffset + 0, 37, 33);
                QuickHelp qh = new QuickHelp(xOffset + 0, yOffset + 33, 37, 12);
                Workspace ws = new Workspace(xOffset + 40 - 4 + 1, yOffset + 0, 83, 45);
                CodeEditor editor = new CodeEditor(xOffset + 41 - 4 + 1, yOffset + 5, 81, 39);
                Options options = new Options(xOffset + 41 + 1, yOffset + 5, 77, 39);
                Statistics statistics = new Statistics(xOffset + 41 - 4 + 1, yOffset + 5, 81, 39);
                GlobalUIController guiController = new GlobalUIController();
                gameObjects.add(ws);
                gameObjects.add(fe);
                gameObjects.add(editor);
                gameObjects.add(options);
                gameObjects.add(statistics);
                gameObjects.add(guiController);
                gameObjects.add(qh);
                MemorySystem.load();
                QuickHelp.addShortcut("ENTER", "Activate Workspace");
                QuickHelp.addShortcut("ESC", "Exit Program");
                FileExplorer.previewInWorkspace();
                break;
            }
        }
    }

    public static State getGameState() {
        return gameState;
    }

    public static void setGameState(State s) {
        newState = s;
    }

    public static void addGameObject(GameObject go) {
        newGameObjects.add(go);
    }

    public static void deleteGameObject(GameObject go) {
        removeGameObjects.add(go);
    }

    public static enum State {
        Init,
        Intro,
        Boot,
        Shell;

    }
}

