/*
 * Decompiled with CFR 0.152.
 */
package engine;

import com.codedisaster.steamworks.SteamAPI;
import controller.data.MemorySystem;
import controller.ui.CodeEditor;
import controller.ui.FileExplorer;
import controller.ui.Options;
import controller.ui.QuickHelp;
import controller.ui.Statistics;
import controller.ui.Workspace;
import engine.GameObject;
import engine.GameState;
import engine.InputSystem;
import engine.Main;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import utils.Resources;

public class GraphicsSystem {
    private static Color WHITE_BRIGHT = Color.WHITE;
    private static Color WHITE_DARK = Color.GRAY;
    private static Color WHITE_MEDIUM = Color.LIGHT_GRAY;
    private static Color GREEN_BRIGHT = new Color(0, 255, 0);
    private static Color GREEN_DARK = new Color(0, 128, 0);
    private static Color GREEN_MEDIUM = new Color(0, 192, 0);
    private static Color AMBER_BRIGHT = new Color(255, 191, 0);
    private static Color AMBER_DARK = new Color(128, 86, 0);
    private static Color AMBER_MEDIUM = new Color(192, 143, 0);
    public static Color BRIGHT = Color.WHITE;
    public static Color DARK = Color.GRAY;
    public static Color MEDIUM = Color.LIGHT_GRAY;
    private static JComponent pc = null;
    private static long ts = 0L;
    static Font font;
    public static Font fontBackup;
    public static boolean borderless;
    public static boolean fullScreen;
    private static Frame frame;
    private static GraphicsDevice gs;
    public static int charH;
    public static int charW;
    public static int windowW;
    public static int windowH;
    public static int charOff;
    public static final int charMaxY = 45;
    public static final int charMaxX = 120;
    private static int lastDrawW;
    private static int lastDrawH;

    static {
        borderless = false;
        fullScreen = true;
        lastDrawH = 0;
    }

    public static void init() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        gs = ge.getDefaultScreenDevice();
        frame = new JFrame("MHRD", gs.getDefaultConfiguration());
        frame.setIconImage(Resources.getIcon());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (MemorySystem.isLoaded()) {
                    MemorySystem.save();
                }
                if (SteamAPI.isSteamRunning()) {
                    SteamAPI.shutdown();
                }
                System.exit(0);
            }
        });
        pc = new JComponent(){
            private boolean initialized = false;

            @Override
            public void paintComponent(Graphics graphics) {
                if (GameState.getGameState() == GameState.State.Init) {
                    if (this.initialized) {
                        return;
                    }
                    GraphicsSystem.determineFontSize(graphics);
                    GameState.setGameState(GameState.State.Intro);
                    this.initialized = true;
                } else {
                    Graphics2D g = (Graphics2D)graphics;
                    graphics.setFont(font);
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    if (GraphicsSystem.hasDimensionChanged()) {
                        lastDrawH = GraphicsSystem.getScreenHeight();
                        lastDrawW = GraphicsSystem.getScreenWidth();
                        GraphicsSystem.determineFontSize(graphics);
                        GraphicsSystem.determineGuiOffsets();
                    }
                    GraphicsSystem.clear(g);
                    GraphicsSystem.draw(g);
                }
            }
        };
        pc.setDoubleBuffered(true);
        frame.add(pc);
        frame.setFocusTraversalKeysEnabled(false);
        if (MemorySystem.saveStateExists()) {
            MemorySystem.loadDispModeOnly();
        }
        if (Options.dispMode == 0) {
            fullScreen = true;
            borderless = false;
        } else if (Options.dispMode == 1) {
            fullScreen = true;
            borderless = true;
        } else if (Options.dispMode == 2) {
            fullScreen = false;
            borderless = true;
        }
        if (fullScreen) {
            frame.setUndecorated(true);
            frame.setSize(gs.getDisplayMode().getWidth(), gs.getDisplayMode().getHeight());
            frame.setVisible(true);
            gs.setFullScreenWindow(borderless ? null : frame);
        } else {
            int h = (int)((double)gs.getDisplayMode().getHeight() * 0.75);
            h = h - h % 10 - 10;
            int w = (int)((double)h * 1.6);
            frame.setUndecorated(false);
            frame.setSize(w, h);
            frame.setLocation((gs.getDisplayMode().getWidth() - w) / 2, (gs.getDisplayMode().getHeight() - h) / 2);
            frame.setResizable(false);
            frame.setVisible(true);
            frame.setSize(w + frame.getWidth() - GraphicsSystem.getScreenWidth(), h + frame.getHeight() - GraphicsSystem.getScreenHeight());
        }
        frame.addKeyListener(InputSystem.getInstance());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point hotSpot = new Point(0, 0);
        BufferedImage cursorImage = new BufferedImage(1, 1, 3);
        Cursor invisibleCursor = toolkit.createCustomCursor(cursorImage, hotSpot, "InvisibleCursor");
        pc.setCursor(invisibleCursor);
    }

    public static boolean hasDimensionChanged() {
        return lastDrawH != GraphicsSystem.getScreenHeight() || lastDrawW != GraphicsSystem.getScreenWidth();
    }

    private static void determineFontSize(Graphics graphics) {
        if (GraphicsSystem.getScreenRatio() < 1.6) {
            charW = GraphicsSystem.getScreenWidth() / 120;
            charH = (int)Math.floor((double)(charW * 5) / 3.0);
            fontBackup = new Font("Monospaced", 1, charH);
            font = Resources.getFont("SourceCodePro-Regular").deriveFont((float)charH);
            graphics.setFont(font);
            charW = graphics.getFontMetrics().stringWidth("a");
        } else {
            charH = GraphicsSystem.getScreenHeight() / 45;
            fontBackup = new Font("Monospaced", 1, charH);
            font = Resources.getFont("SourceCodePro-Regular").deriveFont((float)charH);
            graphics.setFont(font);
            charW = graphics.getFontMetrics().stringWidth("a");
        }
        float asc = graphics.getFontMetrics().getAscent();
        float desc = graphics.getFontMetrics().getDescent();
        charOff = (int)(asc / (asc + desc) * desc);
        windowW = charW * 120;
        windowH = charH * 45;
    }

    private static double getScreenRatio() {
        return (double)GraphicsSystem.getScreenWidth() / (double)GraphicsSystem.getScreenHeight();
    }

    public static void repaint() {
        if (pc != null) {
            pc.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void draw(Graphics2D g) {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            g.setColor(BRIGHT);
            for (GameObject o : GameState.gameObjects) {
                o.draw(g);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void drawFps(Graphics2D g) {
        g.setColor(BRIGHT);
        g.setFont(font);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        float fps = 1000.0f / (float)(System.currentTimeMillis() - ts);
        g.drawString("fps: " + fps, pc.getWidth() - 200, 24);
        ts = System.currentTimeMillis();
    }

    private static void clear(Graphics2D g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, GraphicsSystem.getScreenWidth(), GraphicsSystem.getScreenHeight());
    }

    public static int getScreenHeight() {
        return frame.getComponent(0).getHeight();
    }

    public static int getScreenWidth() {
        return frame.getComponent(0).getWidth();
    }

    public static void setColorMode(int i) {
        if (i == 0) {
            BRIGHT = WHITE_BRIGHT;
            DARK = WHITE_DARK;
            MEDIUM = WHITE_MEDIUM;
        } else if (i == 1) {
            BRIGHT = GREEN_BRIGHT;
            DARK = GREEN_DARK;
            MEDIUM = GREEN_MEDIUM;
        } else if (i == 2) {
            BRIGHT = AMBER_BRIGHT;
            DARK = AMBER_DARK;
            MEDIUM = AMBER_MEDIUM;
        }
    }

    private static void determineGuiOffsets() {
        int xOffset = (GraphicsSystem.getScreenWidth() - 120 * charW) / 2 / charW;
        int yOffset = (GraphicsSystem.getScreenHeight() - 45 * charH) / 2 / charH;
        for (GameObject go : GameState.gameObjects) {
            if (go instanceof FileExplorer) {
                ((FileExplorer)go).x = xOffset;
                ((FileExplorer)go).y = yOffset;
                continue;
            }
            if (go instanceof QuickHelp) {
                ((QuickHelp)go).x = xOffset;
                ((QuickHelp)go).y = yOffset + 33;
                continue;
            }
            if (go instanceof Workspace) {
                ((Workspace)go).x = xOffset + 40 - 4 + 1;
                ((Workspace)go).y = yOffset;
                continue;
            }
            if (go instanceof CodeEditor) {
                ((CodeEditor)go).x = xOffset + 41 - 4 + 1;
                ((CodeEditor)go).y = yOffset + 5;
                ((CodeEditor)go).textCursor.xOff = ((CodeEditor)go).x;
                ((CodeEditor)go).textCursor.yOff = ((CodeEditor)go).y;
                continue;
            }
            if (go instanceof Options) {
                ((Options)go).x = xOffset + 41 + 1;
                ((Options)go).y = yOffset + 5;
                continue;
            }
            if (!(go instanceof Statistics)) continue;
            ((Statistics)go).x = xOffset + 41 - 4 + 1;
            ((Statistics)go).y = yOffset + 5;
        }
    }

    public static void switchToWindow() {
        Options.dispMode = 2;
        fullScreen = false;
        gs.setFullScreenWindow(null);
        int h = (int)((double)gs.getDisplayMode().getHeight() * 0.75);
        h = h - h % 10 - 10;
        int w = (int)((double)h * 1.6);
        frame.dispose();
        frame.setUndecorated(false);
        frame.setSize(w, h);
        frame.setLocation((gs.getDisplayMode().getWidth() - w) / 2, (gs.getDisplayMode().getHeight() - h) / 2);
        frame.setResizable(false);
        frame.setVisible(true);
        frame.setSize(w + frame.getWidth() - GraphicsSystem.getScreenWidth(), h + frame.getHeight() - GraphicsSystem.getScreenHeight());
    }

    public static void switchToFullscreen() {
        Options.dispMode = 0;
        fullScreen = true;
        borderless = false;
        frame.dispose();
        int w = gs.getDisplayMode().getWidth();
        int h = gs.getDisplayMode().getHeight();
        frame.setUndecorated(true);
        frame.setSize(w, h);
        frame.setLocation(0, 0);
        gs.setFullScreenWindow(frame);
    }

    public static void switchToBorderless() {
        Options.dispMode = 1;
        fullScreen = true;
        borderless = true;
        frame.dispose();
        int w = gs.getDisplayMode().getWidth();
        int h = gs.getDisplayMode().getHeight();
        frame.setUndecorated(true);
        frame.setSize(w, h);
        frame.setLocation(0, 0);
        frame.setVisible(true);
    }
}

