/*
 * Decompiled with CFR 0.152.
 */
package engine;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamException;
import engine.GameState;
import engine.GraphicsSystem;
import engine.InputSystem;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import utils.AchievementUtil;
import utils.Logger;
import utils.Resources;
import utils.StopWatch;

public class Main {
    public static final String VERSION = "0.5h";
    public static final boolean RELEASE = true;
    public static final boolean STEAM_BUILD = true;
    public static final boolean SKIP_INTRO = false;
    public static final boolean DEVELOPER_MODE = false;
    public static final boolean LOAD_SOLUTIONS = false;
    public static final boolean VERFICIATION_ALWAYS_SUCCESS = false;

    public static void main(String[] args) {
        try {
            System.setOut(Resources.getGameLog());
            System.setErr(Resources.getErrorLog());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (!SteamAPI.init()) {
                Logger.log("SteamWorks API couldn't be initialized");
            } else {
                AchievementUtil.init();
            }
        }
        catch (SteamException e) {
            Logger.log(e);
        }
        GraphicsSystem.init();
        GameState.setGameState(GameState.State.Init);
        StopWatch t = new StopWatch();
        t.start();
        while (true) {
            if (Main.calc(t.newLap()) || GraphicsSystem.hasDimensionChanged()) {
                GraphicsSystem.repaint();
            }
            t.waitUntil(33L);
            if (!SteamAPI.isSteamRunning()) continue;
            SteamAPI.runCallbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean calc(float td) {
        boolean repaint = false;
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            ArrayList<KeyEvent> arrayList = InputSystem.eventQueue;
            synchronized (arrayList) {
                try {
                    repaint = GameState.step(td);
                }
                catch (Exception e) {
                    Logger.log(e);
                }
                InputSystem.eventQueue.clear();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return repaint;
        }
    }
}

