/*
 * Decompiled with CFR 0.152.
 */
package intro;

import controller.data.MemorySystem;
import controller.ui.UIController;
import engine.AudioEngineSystem;
import engine.GameObject;
import engine.GameState;
import engine.InputSystem;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import utils.TestCache;

public class Intro
extends UIController
implements GameObject {
    float absoluteTimer = 0.0f;
    float cursorTimer = 0.0f;
    boolean cursorVisible = false;
    int cursorX;
    int cursorY;
    StringBuilder sb = new StringBuilder();

    public Intro(int x, int y, int w, int h) {
        super(x, y, w, h);
        if (MemorySystem.saveStateExists()) {
            MemorySystem.loadColorOnly();
        }
        this.cursorX = 0;
        this.cursorY = 0;
        AudioEngineSystem.playBootSound();
        new Thread(new Runnable(){

            @Override
            public void run() {
                TestCache.get("bla");
            }
        }).start();
    }

    @Override
    public boolean step(float td) {
        this.sb = new StringBuilder();
        this.cursorTimer += td;
        this.absoluteTimer += td;
        if (this.absoluteTimer > 2.5f) {
            this.sb.append(this.addRam());
        }
        if (this.absoluteTimer > 7.8f) {
            this.sb.append("\n\n\nFunghisoft(R) FS-DOS(R) Version 0.1\n              (C) Funghisoft Corp 1983-1985");
            this.cursorY = 5;
        }
        if (this.absoluteTimer > 11.3f) {
            this.sb.append("\n\n\nBooting Microhard Development Environment...");
            this.cursorY = 7;
            this.cursorX = "Booting Microhard Development Environment...".length() + 1;
        }
        if (this.absoluteTimer > 14.0f) {
            AudioEngineSystem.loopSound("noise");
            GameState.setGameState(GameState.State.Shell);
        }
        int i = 0;
        while (i < InputSystem.eventQueue.size()) {
            KeyEvent e = InputSystem.eventQueue.get(i);
            if (e.getKeyCode() == 27 && MemorySystem.saveStateExists()) {
                AudioEngineSystem.stopBootSound();
                AudioEngineSystem.loopSound("noise");
                GameState.setGameState(GameState.State.Shell);
            }
            ++i;
        }
        if (this.cursorTimer > 0.2f) {
            this.cursorTimer = 0.0f;
            this.cursorVisible = !this.cursorVisible;
            return true;
        }
        return true;
    }

    private String addRam() {
        float startTime = 2.5f;
        float time = this.absoluteTimer - startTime;
        float duration = 4.5f;
        int max = 512;
        int stepSize = 16;
        float timePerStep = duration / (float)(max / stepSize);
        int checked = (int)(time / timePerStep) * stepSize;
        if (checked > max) {
            checked = max;
        }
        return checked + " KB OK";
    }

    @Override
    public void draw(Graphics2D g) {
        Intro.drawStringWithLineBreaks(g, this.sb.toString(), this.x, this.y);
        if (this.cursorVisible) {
            Intro.drawStringWithLineBreaks(g, "_", this.x + this.cursorX, this.y + this.cursorY);
        }
    }
}

