/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import controller.data.DesignRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import model.Design;
import simulator.HardwareDesign;
import simulator.Test;
import simulator.Wire;
import simulator.devices.Device;
import utils.TestCache;

public class Parser {
    private String design;
    private static Pattern patternIdentifier = Pattern.compile("[a-zA-Z][a-zA-Z0-9\u00a7]*");
    private static Pattern patternDevPinIdentifier = Pattern.compile("[a-zA-Z][a-zA-Z0-9]*\\.[a-zA-Z][a-zA-Z0-9\u00a7]*");
    private static Pattern patternNumber = Pattern.compile("[0-9]+");
    Pattern patternTwoNumbersOrMore = Pattern.compile("[0-9][0-9]+");
    private static Map<String, Map<String, Device>> autoCompleteCache = new HashMap<String, Map<String, Device>>();
    private static Map<String, Boolean> autoCompleteProblemCache = new HashMap<String, Boolean>();

    public Parser(String s) {
        this.design = s;
    }

    public static HardwareDesign parse(String design) {
        design = design.replaceAll("//.*", "");
        design = design.replace("\r", "");
        design = design.replace("\n", "");
        HardwareDesign hwd = new HardwareDesign();
        Parser p = new Parser(design);
        p.parseInputs(hwd);
        p.parseOutputs(hwd);
        if (hwd.inputs == null && hwd.outputs == null) {
            hwd.compilationProblems.add("No inputs or outputs could be successfully parsed");
            return hwd;
        }
        p.parseDevices(hwd);
        if (hwd.devices == null || hwd.devices.containsValue(null)) {
            return hwd;
        }
        p.parseWires(hwd);
        p.parseTests(hwd);
        if (hwd.devices == null) {
            hwd.devices = new HashMap<String, Device>();
        }
        if (hwd.wires == null) {
            hwd.wires = new HashSet<Wire>();
        }
        HashSet<String> keySet1 = new HashSet<String>(hwd.devices.keySet());
        HashSet<String> keySet2 = new HashSet<String>(hwd.inputs);
        HashSet<String> keySet3 = new HashSet<String>(hwd.outputs);
        for (String string : keySet1) {
            if (!keySet2.contains(string)) continue;
            hwd.compilationProblems.add("Id \"" + string + "\" is declared multiple times");
            return hwd;
        }
        keySet2.addAll(keySet1);
        for (String string : keySet2) {
            if (!keySet3.contains(string)) continue;
            hwd.compilationProblems.add("Id \"" + string + "\" is declared multiple times");
            return hwd;
        }
        for (Map.Entry entry : hwd.devices.entrySet()) {
            if (entry.getValue() != null) continue;
            return hwd;
        }
        for (Wire wire : hwd.wires) {
            String pinId;
            Object devId;
            if (!(wire.start.equals("1") || wire.start.equals("0") || !wire.start.contains(".") && hwd.inputs.contains(wire.start))) {
                if (wire.start.contains(".")) {
                    devId = wire.start.split("\\.")[0];
                    pinId = wire.start.split("\\.")[1];
                    if (hwd.devices.get(devId).getOutput(pinId) == null) {
                        hwd.compilationProblems.add("Unknown id or invalid start pin: \"" + wire + "\"");
                        return hwd;
                    }
                } else {
                    hwd.compilationProblems.add("Unknown id or invalid start pin: \"" + wire + "\"");
                    return hwd;
                }
            }
            if (!wire.end.contains(".") && hwd.outputs.contains(wire.end)) continue;
            if (wire.end.contains(".")) {
                devId = wire.end.split("\\.")[0];
                pinId = wire.end.split("\\.")[1];
                if (hwd.devices.get(devId).getInput(pinId) != null) continue;
                hwd.compilationProblems.add("Unknown id or invalid start pin: \"" + wire + "\"");
                return hwd;
            }
            hwd.compilationProblems.add("Unknown id or invalid start pin: \"" + wire + "\"");
            return hwd;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Wire w : hwd.wires) {
            if (!hashMap.containsKey(w.end)) {
                hashMap.put(w.end, 1);
                continue;
            }
            hwd.compilationProblems.add("Too many incoming wires on pin \"" + w.end + "\"");
            return hwd;
        }
        HashMap<String, Set<String>> predecessorMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> successorMap = new HashMap<String, Set<String>>();
        for (Wire w : hwd.wires) {
            boolean endSeq;
            if (!w.start.contains(".") || !w.end.contains(".") || (endSeq = hwd.devices.get(w.end.split("\\.")[0]).isSequential())) continue;
            if (!predecessorMap.containsKey(w.end.split("\\.")[0])) {
                predecessorMap.put(w.end.split("\\.")[0], new HashSet());
            }
            if (!successorMap.containsKey(w.start.split("\\.")[0])) {
                successorMap.put(w.start.split("\\.")[0], new HashSet());
            }
            ((Set)predecessorMap.get(w.end.split("\\.")[0])).add(w.start.split("\\.")[0]);
            ((Set)successorMap.get(w.start.split("\\.")[0])).add(w.end.split("\\.")[0]);
        }
        for (String d : hwd.devices.keySet()) {
            if (predecessorMap.containsKey(d)) continue;
            Parser.remove(hwd, d, predecessorMap, successorMap);
        }
        if (hwd.devices.size() > hwd.deviceList.size()) {
            hwd.compilationProblems.add("Design contains illegal cycles");
            return hwd;
        }
        if (hwd.tests != null) {
            for (Test t : hwd.tests) {
                for (Wire w : t.wires) {
                    if ((w.start.equals("0") || w.start.equals("1")) && hwd.inputs.contains(w.end) || (w.end.equals("0") || w.end.equals("1")) && hwd.outputs.contains(w.start)) continue;
                    hwd.compilationProblems.add("Illegal wire for test: \"" + w + "\"");
                    return hwd;
                }
            }
        }
        if (p.design.length() > 0) {
            hwd.compilationProblems.add("Couldn't be parsed completely");
            return hwd;
        }
        return hwd;
    }

    private static boolean hasPredecessor(Wire wire, List<Wire> wireList) {
        for (Wire w : wireList) {
            if (!wire.start.equals(w.end)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidWireValue(String id, boolean testSyntax) {
        if (testSyntax) {
            return patternIdentifier.matcher(id).matches() || patternNumber.matcher(id).matches() || patternDevPinIdentifier.matcher(id).matches();
        }
        return patternIdentifier.matcher(id).matches() || id.equals("1") || id.equals("0") || patternDevPinIdentifier.matcher(id).matches();
    }

    private void parseInputs(HardwareDesign hwd) {
        hwd.inputs = this.parseIO("Inputs:", hwd);
    }

    private void parseOutputs(HardwareDesign hwd) {
        hwd.outputs = this.parseIO("Outputs:", hwd);
    }

    private Set<String> parseIO(String prefix, HardwareDesign hwd) {
        HashSet<String> ioPins = new HashSet<String>();
        this.design = this.design.trim();
        if (!this.design.startsWith(prefix)) {
            return null;
        }
        this.design = this.design.substring(prefix.length(), this.design.length());
        int ioEnd = this.design.indexOf(59);
        if (ioEnd == -1) {
            hwd.compilationProblems.add("Design contains \"" + prefix.substring(0, prefix.length() - 1) + "\" element, but it is never closed with a \";\"");
            return null;
        }
        String[] ioPinIds = this.design.substring(0, ioEnd).replaceAll("\\s", "").split(",");
        this.design = this.design.substring(ioEnd + 1, this.design.length());
        String[] stringArray = ioPinIds;
        int n = ioPinIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            boolean bus = this.isBusSyntax(id);
            int busSize = 0;
            if (id.matches("[^\\[]*\\[[0-9]+\\]")) {
                busSize = new Integer(id.substring(id.indexOf(91) + 1, id.length() - 1));
                bus = true;
                id = id.substring(0, id.indexOf(91));
            }
            if (!Parser.isValidId(id)) {
                hwd.compilationProblems.add("Id \"" + id + "\" is invalid");
            }
            if (ioPins.contains(id)) {
                hwd.compilationProblems.add("Id \"" + id + "\" is declared multiple times");
            }
            if (!bus) {
                ioPins.add(id);
            } else {
                int i = 1;
                while (i <= busSize) {
                    ioPins.add(String.valueOf(id) + "\u00a7" + i);
                    ++i;
                }
            }
            ++n2;
        }
        if (hwd.compilationProblems.isEmpty()) {
            return ioPins;
        }
        return null;
    }

    private Map<String, Device> parseDevices(HardwareDesign hwd) {
        HashMap<String, Device> devices = new HashMap<String, Device>();
        this.design = this.design.trim();
        if (!this.design.startsWith("Parts:")) {
            hwd.devices = new HashMap<String, Device>();
            return null;
        }
        this.design = this.design.substring("Parts:".length(), this.design.length());
        int devicesEnd = this.design.indexOf(59);
        if (devicesEnd == -1) {
            hwd.compilationProblems.add("Design contains \"Parts\" element, but it is never closed with a \";\"");
            return null;
        }
        String devicesString = this.design.substring(0, devicesEnd).trim();
        this.design = this.design.substring(devicesEnd + 1, this.design.length());
        String[] deviceIds = devicesString.split(",");
        int commas = this.countCharsInString(',', devicesString);
        if (commas + 1 > deviceIds.length) {
            hwd.compilationProblems.add("\"Parts\" element has invalid syntax");
            return null;
        }
        if (devicesString.isEmpty()) {
            hwd.devices = new HashMap<String, Device>();
            return null;
        }
        String[] stringArray = deviceIds;
        int n = deviceIds.length;
        int n2 = 0;
        while (n2 < n) {
            String did = stringArray[n2];
            String[] idAndType = did.trim().replaceAll("\\s+", " ").split(" ");
            if (idAndType.length != 2) {
                hwd.compilationProblems.add("Part \"" + did.trim().replace("\\s+", " ") + "\" has wrong syntax");
                return null;
            }
            if (!Parser.isValidId(idAndType[0]) || !Parser.isValidId(idAndType[1])) {
                hwd.compilationProblems.add("Part \"" + did.trim().replace("\\s+", " ") + "\" is invalid");
                return null;
            }
            if (devices.containsKey(idAndType[0])) {
                hwd.compilationProblems.add("Id \"" + idAndType[0] + "\" is declared multiple times");
                return null;
            }
            Device dev = Device.getDevice(idAndType[0], idAndType[1]);
            devices.put(idAndType[0], dev);
            if (dev == null) {
                hwd.compilationProblems.add("Part Type \"" + idAndType[1] + "\" is unknown");
            }
            ++n2;
        }
        hwd.devices = devices;
        return devices;
    }

    private int countCharsInString(char c, String devicesString) {
        int count = 0;
        int i = 0;
        while (i < devicesString.length()) {
            if (devicesString.charAt(i) == ',') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private boolean doWireChecks(String start, String end, HardwareDesign hwd, Set<Wire> wires, String wd, boolean testSyntax) {
        if (!Parser.isValidWireValue(start, testSyntax) || !Parser.isValidWireValue(end, testSyntax)) {
            hwd.compilationProblems.add("Wire \"" + wd + "\" is invalid");
            return false;
        }
        if (!wires.add(new Wire(start, end))) {
            hwd.compilationProblems.add("Wire \"" + new Wire(start, end) + "\" is declared multiple times");
            return false;
        }
        return true;
    }

    private int getBusIndex(String id) {
        if (id.matches("[^\\[]*\\[[0-9]+:[0-9]+\\]")) {
            int left = new Integer(id.substring(id.indexOf(91) + 1, id.indexOf(58)));
            return left;
        }
        return 1;
    }

    private int getBusSize(String id, HardwareDesign hwd) {
        int pinCount = 0;
        String cleanId = this.transformToPin(id, hwd);
        Set<String> inputs = hwd.inputs;
        Set<String> outputs = hwd.outputs;
        if (id.contains(".")) {
            String devId = cleanId.split("\\.")[0];
            cleanId = cleanId.split("\\.")[1];
            inputs = hwd.devices.get((Object)devId).inputs.keySet();
            outputs = hwd.devices.get((Object)devId).outputs.keySet();
        }
        for (String pin : inputs) {
            if (!pin.startsWith(String.valueOf(cleanId) + "\u00a7")) continue;
            ++pinCount;
        }
        for (String pin : outputs) {
            if (!pin.startsWith(String.valueOf(cleanId) + "\u00a7")) continue;
            ++pinCount;
        }
        if (id.matches("[^\\[]*\\[[0-9]+:[0-9]+\\]")) {
            int left = new Integer(id.substring(id.indexOf(91) + 1, id.indexOf(58)));
            int right = new Integer(id.substring(id.indexOf(58) + 1, id.indexOf(93)));
            if (right <= left || right > pinCount) {
                hwd.compilationProblems.add(String.valueOf(id) + " has an invalid index");
                return -1;
            }
            return right - left + 1;
        }
        if (this.patternTwoNumbersOrMore.matcher(id).matches()) {
            return id.length();
        }
        return pinCount;
    }

    private boolean isBus(String id, HardwareDesign hwd) {
        if (this.patternTwoNumbersOrMore.matcher(id).matches()) {
            return true;
        }
        if (id.matches("[^\\[]*\\[[0-9]+:[0-9]+\\]")) {
            return true;
        }
        Set<String> inputs = hwd.inputs;
        Set<String> outputs = hwd.outputs;
        if (id.contains(".")) {
            String devId = id.split("\\.")[0];
            id = id.split("\\.")[1];
            inputs = hwd.devices.get((Object)devId).inputs.keySet();
            outputs = hwd.devices.get((Object)devId).outputs.keySet();
        }
        for (String pin : inputs) {
            if (!pin.startsWith(String.valueOf(id) + "\u00a7")) continue;
            return true;
        }
        for (String pin : outputs) {
            if (!pin.startsWith(String.valueOf(id) + "\u00a7")) continue;
            return true;
        }
        return false;
    }

    private boolean isBusSyntax(String id) {
        return id.matches("[^\\[]*\\[[0-9]+\\]");
    }

    private String transformToPin(String id, HardwareDesign hwd) {
        if (this.isBusSyntax(id)) {
            return id.replace('[', '\u00a7').replace("]", "");
        }
        if (this.isBus(id, hwd) && id.contains("[")) {
            return id.substring(0, id.indexOf(91));
        }
        return id;
    }

    private List<Test> parseTests(HardwareDesign hwd) {
        if (TestCache.contains(hwd.name)) {
            hwd.tests = TestCache.get(hwd.name);
            return hwd.tests;
        }
        ArrayList<Test> tests = new ArrayList<Test>();
        this.design = this.design.replaceAll("\\s", "");
        if (!this.design.startsWith("Tests:")) {
            return null;
        }
        this.design = this.design.substring("Tests:".length(), this.design.length());
        int testsEnd = this.design.lastIndexOf(59);
        if (testsEnd == -1) {
            hwd.compilationProblems.add("Design contains \"Wires\" element, but it is never closed with a \";\"");
            return null;
        }
        String[] testsDescr = this.design.substring(0, testsEnd).split(";");
        this.design = this.design.substring(testsEnd + 1, this.design.length());
        String[] stringArray = testsDescr;
        int n = testsDescr.length;
        int n2 = 0;
        while (n2 < n) {
            HashSet<Wire> wires = new HashSet<Wire>();
            String test = stringArray[n2];
            String[] wiresDescr = test.split(",");
            if (!this.checkWiresCompletely(hwd, wires, wiresDescr, true)) {
                return null;
            }
            tests.add(new Test(wires));
            ++n2;
        }
        hwd.tests = tests;
        TestCache.put(hwd.name, tests);
        return tests;
    }

    private Set<Wire> parseWires(HardwareDesign hwd) {
        HashSet<Wire> wires = new HashSet<Wire>();
        this.design = this.design.replaceAll("\\s", "");
        if (!this.design.startsWith("Wires:")) {
            return null;
        }
        this.design = this.design.substring("Wires:".length(), this.design.length());
        int wiresEnd = this.design.indexOf(59);
        if (wiresEnd == -1) {
            hwd.compilationProblems.add("Design contains \"Wires\" element, but it is never closed with a \";\"");
            return null;
        }
        String wiresString = this.design.substring(0, wiresEnd).trim();
        this.design = this.design.substring(wiresEnd + 1, this.design.length());
        String[] wiresDescr = wiresString.split(",");
        int commas = this.countCharsInString(',', wiresString);
        if (commas + 1 > wiresDescr.length) {
            hwd.compilationProblems.add("\"Wires\" element has invalid syntax");
            return null;
        }
        if (wiresString.isEmpty()) {
            hwd.devices = new HashMap<String, Device>();
            return null;
        }
        if (!this.checkWiresCompletely(hwd, wires, wiresDescr, false)) {
            return null;
        }
        hwd.wires = wires;
        return wires;
    }

    private boolean checkWiresCompletely(HardwareDesign hwd, Set<Wire> wires, String[] wiresDescr, boolean testSyntax) {
        String[] stringArray = wiresDescr;
        int n = wiresDescr.length;
        int n2 = 0;
        while (n2 < n) {
            int i;
            String wd = stringArray[n2];
            if (wd.contains("\u00a7")) {
                hwd.compilationProblems.add("Wire \"" + wd + "\" is invalid");
                return false;
            }
            String[] startAndEnd = wd.split("->");
            if (startAndEnd.length != 2) {
                hwd.compilationProblems.add("Wire \"" + wd + "\" has wrong syntax");
                return false;
            }
            if (startAndEnd[0].contains(".") && hwd.devices.get(startAndEnd[0].split("\\.")[0]) == null) {
                hwd.compilationProblems.add("Device referenced by \"" + startAndEnd[0] + "\" does not exist");
                return false;
            }
            if (startAndEnd[1].contains(".") && hwd.devices.get(startAndEnd[1].split("\\.")[0]) == null) {
                hwd.compilationProblems.add("Device referenced by \"" + startAndEnd[1] + "\" does not exist");
                return false;
            }
            boolean startBus = this.isBus(startAndEnd[0], hwd);
            boolean endBus = this.isBus(startAndEnd[1], hwd);
            int startBusSize = 0;
            int endBusSize = 0;
            int startBusIndex = 0;
            int endBusIndex = 0;
            if (startBus && !endBus && !testSyntax) {
                hwd.compilationProblems.add("Wire \"" + wd + "\" is invalid... can't map bus to pin");
                return false;
            }
            if (startBus && !endBus && testSyntax) {
                startBusSize = this.getBusSize(startAndEnd[0], hwd);
                startBusIndex = this.getBusIndex(startAndEnd[0]);
                if (startBusSize == -1) {
                    hwd.compilationProblems.add("Wire \"" + wd + "\" is invalid");
                    return false;
                }
                startAndEnd[0] = this.transformToPin(startAndEnd[0], hwd);
                startAndEnd[1] = this.transformToPin(startAndEnd[1], hwd);
                i = startBusIndex;
                while (i < startBusIndex + startBusSize) {
                    if (!this.doWireChecks(String.valueOf(startAndEnd[0]) + "\u00a7" + i, startAndEnd[1], hwd, wires, wd, testSyntax)) {
                        return false;
                    }
                    ++i;
                }
            } else if (startBus && endBus) {
                int j;
                startBusSize = this.getBusSize(startAndEnd[0], hwd);
                endBusSize = this.getBusSize(startAndEnd[1], hwd);
                startBusIndex = this.getBusIndex(startAndEnd[0]);
                endBusIndex = this.getBusIndex(startAndEnd[1]);
                if (startBusSize == -1 || endBusSize == -1 || startBusSize != endBusSize) {
                    if (startBusSize != endBusSize) {
                        hwd.compilationProblems.add("Wire \"" + wd + "\" is invalid, because of different bus widths");
                    }
                    return false;
                }
                startAndEnd[0] = this.transformToPin(startAndEnd[0], hwd);
                startAndEnd[1] = this.transformToPin(startAndEnd[1], hwd);
                if (this.patternTwoNumbersOrMore.matcher(startAndEnd[0]).matches()) {
                    i = startBusIndex;
                    j = endBusIndex;
                    while (j < endBusIndex + endBusSize) {
                        if (!this.doWireChecks("" + startAndEnd[0].charAt(startBusSize - i), String.valueOf(startAndEnd[1]) + "\u00a7" + j, hwd, wires, wd, testSyntax)) {
                            return false;
                        }
                        ++i;
                        ++j;
                    }
                } else if (this.patternTwoNumbersOrMore.matcher(startAndEnd[1]).matches()) {
                    i = startBusIndex;
                    j = endBusIndex;
                    while (j < endBusIndex + endBusSize) {
                        if (!this.doWireChecks(String.valueOf(startAndEnd[0]) + "\u00a7" + i, "" + startAndEnd[1].charAt(endBusSize - j), hwd, wires, wd, testSyntax)) {
                            return false;
                        }
                        ++i;
                        ++j;
                    }
                } else {
                    i = startBusIndex;
                    j = endBusIndex;
                    while (j < endBusIndex + endBusSize) {
                        if (!this.doWireChecks(String.valueOf(startAndEnd[0]) + "\u00a7" + i, String.valueOf(startAndEnd[1]) + "\u00a7" + j, hwd, wires, wd, testSyntax)) {
                            return false;
                        }
                        ++i;
                        ++j;
                    }
                }
            } else if (!startBus && endBus) {
                endBusSize = this.getBusSize(startAndEnd[1], hwd);
                endBusIndex = this.getBusIndex(startAndEnd[1]);
                if (endBusSize == -1) {
                    hwd.compilationProblems.add("Wire \"" + wd + "\" is invalid");
                    return false;
                }
                startAndEnd[0] = this.transformToPin(startAndEnd[0], hwd);
                startAndEnd[1] = this.transformToPin(startAndEnd[1], hwd);
                i = endBusIndex;
                while (i < endBusIndex + endBusSize) {
                    if (!this.doWireChecks(startAndEnd[0], String.valueOf(startAndEnd[1]) + "\u00a7" + i, hwd, wires, wd, testSyntax)) {
                        return false;
                    }
                    ++i;
                }
            } else {
                startAndEnd[0] = this.transformToPin(startAndEnd[0], hwd);
                startAndEnd[1] = this.transformToPin(startAndEnd[1], hwd);
                if (!this.doWireChecks(startAndEnd[0], startAndEnd[1], hwd, wires, wd, testSyntax)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private static boolean isValidId(String id) {
        return id.matches("[a-zA-Z][a-zA-Z0-9]*");
    }

    private static void remove(HardwareDesign hwd, String d, Map<String, Set<String>> predecessorMap, Map<String, Set<String>> successorMap) {
        hwd.deviceList.add(hwd.devices.get(d));
        if (successorMap.get(d) == null) {
            return;
        }
        for (String s : successorMap.get(d)) {
            predecessorMap.get(s).remove(d);
            successorMap.remove(d);
            if (!predecessorMap.get(s).isEmpty()) continue;
            predecessorMap.remove(s);
            Parser.remove(hwd, s, predecessorMap, successorMap);
        }
    }

    public static HardwareDesign parseDesign(Design d) {
        HardwareDesign chwd = null;
        chwd = !d.completed ? Parser.parse(d.code) : Parser.parse(DesignRepo.getAltImpl(d.name));
        String inputAndOutput = d.iface.replace("\r", "");
        inputAndOutput = d.iface.replace("\n", "");
        String tests = "";
        if (d.tests != null) {
            tests = d.tests.replace("\r", "");
            tests = tests.replace("\n", "");
        }
        String design = String.valueOf(inputAndOutput) + tests;
        HardwareDesign dhwd = new HardwareDesign();
        Parser p = new Parser(design);
        p.parseInputs(dhwd);
        p.parseOutputs(dhwd);
        dhwd.name = d.name;
        p.parseTests(dhwd);
        if (!dhwd.inputs.equals(chwd.inputs) || !dhwd.outputs.equals(chwd.outputs)) {
            chwd.compilationProblems.add(0, "Inputs and outputs in design differ from specification");
        }
        chwd.tests = dhwd.tests;
        return chwd;
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> autoComplete(String code) {
        block35: {
            block36: {
                block33: {
                    block34: {
                        codeLines = (code = code.replace("\r", "")).split("\n");
                        if (codeLines.length > 0 && codeLines[codeLines.length - 1].contains("//")) {
                            return null;
                        }
                        code = code.replaceAll("//.*", "");
                        code = code.replace("\n", "");
                        p = new Parser(code);
                        hwd = new HardwareDesign();
                        p.parseInputs(hwd);
                        p.parseOutputs(hwd);
                        if (hwd.inputs == null || hwd.outputs == null) {
                            return null;
                        }
                        if (Parser.autoCompleteCache.size() > 64) {
                            Parser.autoCompleteCache.clear();
                            Parser.autoCompleteProblemCache.clear();
                        }
                        code = p.design;
                        semPos = code.indexOf(59);
                        hashKey = null;
                        if (semPos > 0) {
                            hashKey = code.substring(0, semPos + 1);
                        }
                        if (hashKey == null || !Parser.autoCompleteCache.containsKey(hashKey)) {
                            probNum = hwd.compilationProblems.size();
                            p.parseDevices(hwd);
                            if (hashKey != null) {
                                Parser.autoCompleteCache.put(hashKey, hwd.devices);
                                Parser.autoCompleteProblemCache.put(hashKey, hwd.compilationProblems.size() > probNum);
                            }
                        } else {
                            hwd.devices = Parser.autoCompleteCache.get(hashKey);
                            if (Parser.autoCompleteProblemCache.get(hashKey).booleanValue()) {
                                hwd.compilationProblems.add("Comp Probs");
                            }
                        }
                        if (!hwd.compilationProblems.isEmpty()) {
                            hwd.devices = null;
                        }
                        if (hwd.devices != null) break block33;
                        if (!code.startsWith("Parts:")) break block34;
                        code = code.substring("Parts:".length());
                        ** GOTO lbl44
                    }
                    if (!"Parts:".startsWith(code)) ** GOTO lbl44
                    return Arrays.asList(new String[]{"Parts:"});
lbl-1000:
                    // 1 sources

                    {
                        code = code.substring(code.indexOf(",") + 1, code.length());
lbl44:
                        // 3 sources

                        ** while (code.contains((CharSequence)","))
                    }
lbl45:
                    // 2 sources

                    while (code.startsWith(" ")) {
                        code = code.substring(1, code.length());
                    }
                    if (!code.contains(" ")) {
                        return null;
                    }
                    if ((code = code.substring(code.indexOf(" ") + 1, code.length())).contains(" ")) {
                        return null;
                    }
                    suggestions = new ArrayList<String>();
                    for (String s : DesignRepo.designMap.keySet()) {
                        d = DesignRepo.designMap.get(s);
                        if (s.startsWith(code) && !s.equals(code) && d.completed) {
                            suggestions.add(s);
                            continue;
                        }
                        if (!s.startsWith(code) || !s.equals(code)) continue;
                        suggestions.add(",");
                        suggestions.add(";");
                    }
                    return suggestions;
                }
                code = p.design;
                p.parseWires(hwd);
                if (hwd.wires != null) break block35;
                if (!code.startsWith("Wires:")) break block36;
                code = code.substring("Wires:".length());
                ** GOTO lbl78
            }
            if (!"Wires:".startsWith(code)) ** GOTO lbl78
            return Arrays.asList(new String[]{"Wires:"});
lbl-1000:
            // 1 sources

            {
                code = code.substring(code.indexOf(",") + 1, code.length());
lbl78:
                // 3 sources

                ** while (code.contains((CharSequence)","))
            }
lbl79:
            // 2 sources

            while (code.startsWith(" ")) {
                code = code.substring(1, code.length());
            }
            if (!code.contains("->") && !code.contains(" ")) {
                candidates = new ArrayList<String>();
                suggestions = new ArrayList<String>();
                candidates.addAll(hwd.inputs);
                if (hwd.devices != null && !hwd.devices.isEmpty()) {
                    for (Device d : hwd.devices.values()) {
                        for (String pin : d.outputs.keySet()) {
                            candidates.add(String.valueOf(d.name) + "." + pin);
                        }
                    }
                }
                for (String s : candidates) {
                    bus = false;
                    if (s.contains("\u00a7")) {
                        s = s.substring(0, s.indexOf(167));
                        bus = true;
                    }
                    if (s.startsWith(code) && !s.equals(code) && !suggestions.contains(s)) {
                        suggestions.add(s);
                        continue;
                    }
                    if (!s.startsWith(code) || !s.equals(code)) continue;
                    suggestions.add("->");
                    if (!bus) continue;
                    suggestions.add("[");
                }
                if (code.isEmpty()) {
                    suggestions.add("0");
                    suggestions.add("1");
                }
                return suggestions;
            }
            if (!code.contains(">") && code.contains(" ")) {
                return Arrays.asList(new String[]{"->"});
            }
            code = code.substring(code.indexOf(">") + 1, code.length()).trim();
            candidates = new ArrayList<String>();
            suggestions = new ArrayList<E>();
            candidates.addAll(hwd.outputs);
            if (hwd.devices != null) {
                for (Device d : hwd.devices.values()) {
                    for (String pin : d.inputs.keySet()) {
                        candidates.add(String.valueOf(d.name) + "." + pin);
                    }
                }
            }
            for (String s : candidates) {
                bus = false;
                if (s.contains("\u00a7")) {
                    s = s.substring(0, s.indexOf(167));
                    bus = true;
                }
                if (s.startsWith(code) && !s.equals(code)) {
                    suggestions.add(s);
                    continue;
                }
                if (!s.startsWith(code) || !s.equals(code)) continue;
                suggestions.add(",");
                suggestions.add(";");
                if (!bus) continue;
                suggestions.add("[");
            }
            return suggestions;
        }
        code = p.design;
        p.parseTests(hwd);
        if (hwd.tests == null) {
            return null;
        }
        return null;
    }

    public static List<String> parseDeviceTypes(String designCode) {
        String design = designCode;
        if (design == null) {
            return Collections.EMPTY_LIST;
        }
        design = design.replaceAll("//.*", "");
        design = design.replace("\r", "");
        design = design.replace("\n", "");
        HardwareDesign hwd = new HardwareDesign();
        Parser p = new Parser(design);
        p.parseInputs(hwd);
        p.parseOutputs(hwd);
        design = p.design;
        ArrayList<String> deviceTypes = new ArrayList<String>();
        design = design.trim();
        design = design.substring("Parts:".length(), design.length());
        int devicesEnd = design.indexOf(59);
        String devicesString = design.substring(0, devicesEnd).trim();
        String[] deviceIds = devicesString.split(",");
        if (devicesString.isEmpty()) {
            return Collections.emptyList();
        }
        String[] stringArray = deviceIds;
        int n = deviceIds.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            deviceTypes.add(s.trim().replaceAll("\\s+", " ").split(" ")[1]);
            ++n2;
        }
        return deviceTypes;
    }
}

