/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import simulator.Pin;
import simulator.devices.Device;

public class Adder
extends Device {
    int busSize = 1;

    public Adder(String name, int busSize) {
        this.busSize = busSize;
        this.name = name;
        this.inputs.put("carryIn", new Pin("carryIn"));
        this.outputs.put("carryOut", new Pin("carryOut"));
        int i = 1;
        while (i <= busSize) {
            this.inputs.put("in1\u00a7" + i, new Pin("in1\u00a7" + i));
            this.inputs.put("in2\u00a7" + i, new Pin("in2\u00a7" + i));
            this.outputs.put("out\u00a7" + i, new Pin("out\u00a7" + i));
            ++i;
        }
    }

    @Override
    public void step() {
        boolean carry = ((Pin)this.inputs.get("carryIn")).getValue();
        boolean sum = false;
        int i = 1;
        while (i <= this.busSize) {
            sum = ((Pin)this.inputs.get("in1\u00a7" + i)).getValue() ^ ((Pin)this.inputs.get("in2\u00a7" + i)).getValue() ^ carry;
            ((Pin)this.outputs.get("out\u00a7" + i)).setValue(sum);
            carry = !sum && carry || ((Pin)this.inputs.get("in1\u00a7" + i)).getValue() && ((Pin)this.inputs.get("in2\u00a7" + i)).getValue();
            ++i;
        }
        ((Pin)this.outputs.get("carryOut")).setValue(carry);
    }
}

