/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import simulator.Pin;
import simulator.devices.Adder;
import simulator.devices.Device;
import simulator.devices.Nand;

public class Alu
extends Device {
    int busSize = 1;
    Adder adder;
    Nand nand;

    public Alu(String name, int busSize) {
        this.busSize = busSize;
        this.name = name;
        this.outputs.put("zero", new Pin("zero"));
        this.outputs.put("negative", new Pin("negative"));
        this.inputs.put("opCode\u00a71", new Pin("opCode\u00a71"));
        this.inputs.put("opCode\u00a72", new Pin("opCode\u00a71"));
        this.inputs.put("opCode\u00a73", new Pin("opCode\u00a71"));
        this.inputs.put("opCode\u00a74", new Pin("opCode\u00a71"));
        int i = 1;
        while (i <= busSize) {
            this.inputs.put("in1\u00a7" + i, new Pin("in1\u00a7" + i));
            this.inputs.put("in2\u00a7" + i, new Pin("in2\u00a7" + i));
            this.outputs.put("out\u00a7" + i, new Pin("out\u00a7" + i));
            ++i;
        }
        this.adder = new Adder(String.valueOf(name) + ".adder", busSize);
        this.nand = new Nand(String.valueOf(name) + ".adder", busSize);
    }

    @Override
    public void step() {
        int i;
        boolean negateIn1 = ((Pin)this.inputs.get("opCode\u00a74")).getValue();
        boolean negateIn2 = ((Pin)this.inputs.get("opCode\u00a73")).getValue();
        boolean nandOp = ((Pin)this.inputs.get("opCode\u00a72")).getValue();
        boolean negateRes = ((Pin)this.inputs.get("opCode\u00a71")).getValue();
        if (nandOp) {
            i = 1;
            while (i <= this.busSize) {
                this.nand.getInput("in1\u00a7" + i).setValue(negateIn1 ? !((Pin)this.inputs.get("in1\u00a7" + i)).getValue() : ((Pin)this.inputs.get("in1\u00a7" + i)).getValue());
                this.nand.getInput("in2\u00a7" + i).setValue(negateIn2 ? !((Pin)this.inputs.get("in2\u00a7" + i)).getValue() : ((Pin)this.inputs.get("in2\u00a7" + i)).getValue());
                ++i;
            }
            this.nand.step();
            i = 1;
            while (i <= this.busSize) {
                ((Pin)this.outputs.get("out\u00a7" + i)).setValue(negateRes ? !this.nand.getOutput("out\u00a7" + i).getValue() : this.nand.getOutput("out\u00a7" + i).getValue());
                ++i;
            }
        } else {
            i = 1;
            while (i <= this.busSize) {
                this.adder.getInput("in1\u00a7" + i).setValue(negateIn1 ? !((Pin)this.inputs.get("in1\u00a7" + i)).getValue() : ((Pin)this.inputs.get("in1\u00a7" + i)).getValue());
                this.adder.getInput("in2\u00a7" + i).setValue(negateIn2 ? !((Pin)this.inputs.get("in2\u00a7" + i)).getValue() : ((Pin)this.inputs.get("in2\u00a7" + i)).getValue());
                ++i;
            }
            this.adder.step();
            i = 1;
            while (i <= this.busSize) {
                ((Pin)this.outputs.get("out\u00a7" + i)).setValue(negateRes ? !this.adder.getOutput("out\u00a7" + i).getValue() : this.adder.getOutput("out\u00a7" + i).getValue());
                ++i;
            }
        }
        ((Pin)this.outputs.get("negative")).setValue(((Pin)this.outputs.get("out\u00a7" + this.busSize)).getValue());
        i = 1;
        while (i <= this.busSize) {
            if (((Pin)this.outputs.get("out\u00a7" + i)).getValue()) {
                ((Pin)this.outputs.get("zero")).setValue(false);
                return;
            }
            ++i;
        }
        ((Pin)this.outputs.get("zero")).setValue(true);
    }
}

