/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import simulator.Pin;
import simulator.devices.Device;

public class Counter
extends Device {
    boolean internalValue = false;
    boolean[] internalValueArray;
    int busSize = 1;

    public Counter(String name, int busSize) {
        this.name = name;
        this.busSize = busSize;
        this.internalValueArray = new boolean[busSize];
        this.inputs.put("reset", new Pin("reset"));
        this.inputs.put("load", new Pin("load"));
        int i = 1;
        while (i <= busSize) {
            this.inputs.put("in\u00a7" + i, new Pin("in\u00a7" + i));
            this.outputs.put("out\u00a7" + i, new Pin("out\u00a7" + i));
            ++i;
        }
    }

    @Override
    public void step() {
        int i = 0;
        while (i < this.busSize) {
            ((Pin)this.outputs.get("out\u00a7" + (i + 1))).setValue(this.internalValueArray[i]);
            ++i;
        }
    }

    @Override
    public void postStep() {
        int i;
        if (((Pin)this.inputs.get("load")).getValue()) {
            i = 0;
            while (i < this.busSize) {
                this.internalValueArray[i] = ((Pin)this.inputs.get("in\u00a7" + (i + 1))).getValue();
                ++i;
            }
        } else {
            boolean carry = true;
            int i2 = 0;
            while (i2 < this.busSize && carry) {
                if (this.internalValueArray[i2]) {
                    this.internalValueArray[i2] = false;
                } else {
                    this.internalValueArray[i2] = true;
                    carry = false;
                }
                ++i2;
            }
        }
        if (((Pin)this.inputs.get("reset")).getValue()) {
            i = 0;
            while (i < this.busSize) {
                this.internalValueArray[i] = false;
                ++i;
            }
        }
    }

    @Override
    public void preStep() {
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.internalValue = false;
        if (this.busSize > 1) {
            int i = 0;
            while (i < this.busSize) {
                this.internalValueArray[i] = false;
                ++i;
            }
        }
    }
}

