/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import simulator.HardwareDesign;
import simulator.Pin;
import simulator.Test;
import simulator.TestExecution;
import simulator.TestReport;
import simulator.Wire;
import simulator.devices.Device;

public class CustomDevice
extends Device {
    public Map<String, Device> devices = new HashMap<String, Device>();
    private List<Device> deviceList = new ArrayList<Device>();
    public TestReport testReport = new TestReport();
    private boolean sequential;
    private Set<Wire> wires;

    public CustomDevice(String name, HardwareDesign hwd) {
        int n;
        this.name = name;
        for (String string : hwd.inputs) {
            this.inputs.put(string, new Pin(string));
        }
        for (String string : hwd.outputs) {
            this.outputs.put(string, new Pin(string));
        }
        if (hwd.devices != null) {
            for (Map.Entry entry : hwd.devices.entrySet()) {
                ((Device)entry.getValue()).reset();
                this.devices.put((String)entry.getKey(), (Device)entry.getValue());
            }
        }
        this.deviceList = hwd.deviceList;
        this.wires = hwd.wires;
        for (Wire wire : hwd.wires) {
            Pin pEnd = this.getOutPin(wire.end);
            if (wire.start.equals("0")) {
                pEnd.setValue(false);
                continue;
            }
            if (wire.start.equals("1")) {
                pEnd.setValue(true);
                continue;
            }
            Pin pStart = this.getInPin(wire.start);
            pStart.addSuccessorPin(pEnd);
        }
        this.sequential = this.determineSequential(hwd);
        boolean bl = true;
        int testNumber = 0;
        if (hwd.tests != null) {
            for (Test t : hwd.tests) {
                ++testNumber;
                TestExecution te = new TestExecution();
                for (Wire w : t.wires) {
                    if (w.start.equals("0")) {
                        ((Pin)this.inputs.get(w.end)).setValue(false);
                        te.addPreCondition(w.start, w.end);
                        continue;
                    }
                    if (!w.start.equals("1")) continue;
                    ((Pin)this.inputs.get(w.end)).setValue(true);
                    te.addPreCondition(w.start, w.end);
                }
                this.preStep();
                this.step();
                this.postStep();
                int success = 1;
                for (Wire wire : t.wires) {
                    if (wire.end.equals("0")) {
                        te.addPostCondition(wire.start, wire.end);
                        if (!((Pin)this.outputs.get(wire.start)).getValue()) continue;
                        success = 0;
                        continue;
                    }
                    if (!wire.end.equals("1")) continue;
                    te.addPostCondition(wire.start, wire.end);
                    if (((Pin)this.outputs.get(wire.start)).getValue()) continue;
                    success = 0;
                }
                for (Map.Entry entry : this.outputs.entrySet()) {
                    te.addActual((String)entry.getKey(), ((Pin)entry.getValue()).getValue());
                }
                te.setResult(success != 0);
                n &= success;
                this.testReport.addTestExecution(te);
            }
        }
        this.testReport.success = n;
    }

    private boolean determineSequential(HardwareDesign hwd) {
        boolean hasSequentialDevices = false;
        for (Device d : this.devices.values()) {
            hasSequentialDevices |= d.isSequential();
        }
        if (!hasSequentialDevices) {
            return false;
        }
        HashSet<String> visitedPins = new HashSet<String>();
        for (String p : hwd.inputs) {
            visitedPins.add(p);
            if (!this.searchForEnd(p, visitedPins, hwd)) continue;
            return false;
        }
        return true;
    }

    private boolean searchForEnd(String p, Set<String> visitedPins, HardwareDesign hwd) {
        for (Wire w : hwd.wires) {
            if (!w.start.equals(p)) continue;
            String successor = w.end;
            visitedPins.add(successor);
            if (hwd.outputs.contains(successor)) {
                return true;
            }
            if (this.getDevice(successor) != null && this.devices.get(this.getDevice(successor)).isSequential()) continue;
            if (this.getDevice(successor) != null) {
                String devId = this.getDevice(successor);
                Device dev = this.devices.get(devId);
                for (String p2 : dev.outputs.keySet()) {
                    visitedPins.add(p2);
                    this.searchForEnd(p2, visitedPins, hwd);
                }
                continue;
            }
            return this.searchForEnd(successor, visitedPins, hwd);
        }
        return false;
    }

    private String getDevice(String successor) {
        if (!successor.contains(".")) {
            return null;
        }
        return successor.split("\\.")[0];
    }

    private Pin getInPin(String pinId) {
        if (!pinId.contains(".")) {
            return (Pin)this.inputs.get(pinId);
        }
        String devId = pinId.split("\\.")[0];
        String devPinId = pinId.split("\\.")[1];
        return this.devices.get((Object)devId).outputs.get(devPinId);
    }

    private Pin getOutPin(String pinId) {
        if (!pinId.contains(".")) {
            return (Pin)this.outputs.get(pinId);
        }
        String devId = pinId.split("\\.")[0];
        String devPinId = pinId.split("\\.")[1];
        return this.devices.get((Object)devId).inputs.get(devPinId);
    }

    @Override
    public void preStep() {
        for (Device d : this.deviceList) {
            d.preStep();
        }
    }

    @Override
    public void postStep() {
        for (Device d : this.deviceList) {
            d.step();
        }
        for (Device d : this.deviceList) {
            d.postStep();
        }
    }

    @Override
    public void step() {
        for (Device d : this.deviceList) {
            d.step();
        }
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    @Override
    public void reset() {
        super.reset();
        for (Device d : this.devices.values()) {
            d.reset();
        }
        for (Wire w : this.wires) {
            Pin pEnd = this.getOutPin(w.end);
            if (w.start.equals("0")) {
                pEnd.setValue(false);
                continue;
            }
            if (!w.start.equals("1")) continue;
            pEnd.setValue(true);
        }
    }
}

