/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import simulator.Pin;
import simulator.devices.Device;

public class Demux
extends Device {
    int busSize = 1;
    int ways = 2;

    public Demux(String name, int ways, int busSize) {
        this.busSize = busSize;
        this.name = name;
        this.ways = ways;
        if (busSize == 1) {
            this.inputs.put("in", new Pin("in"));
            int j = 1;
            while (j <= ways) {
                this.outputs.put("out" + j, new Pin("out" + j));
                ++j;
            }
        } else {
            int i = 1;
            while (i <= busSize) {
                this.inputs.put("in" + i, new Pin("in\u00a7" + i));
                int j = 1;
                while (j <= ways) {
                    this.outputs.put("out" + j + "\u00a7" + i, new Pin("out" + j + "\u00a7" + i));
                    ++j;
                }
                ++i;
            }
        }
        if (ways == 2) {
            this.inputs.put("sel", new Pin("sel"));
        } else if (ways == 4) {
            this.inputs.put("sel\u00a71", new Pin("sel\u00a71"));
            this.inputs.put("sel\u00a72", new Pin("sel\u00a72"));
        } else if (ways == 8) {
            this.inputs.put("sel\u00a71", new Pin("sel\u00a71"));
            this.inputs.put("sel\u00a72", new Pin("sel\u00a72"));
            this.inputs.put("sel\u00a73", new Pin("sel\u00a73"));
        }
    }

    @Override
    public void step() {
        boolean[] value = this.transformInput();
        int select = this.transformSelect();
        this.transformOutput(value, select);
    }

    private void transformOutput(boolean[] value, int select) {
        int i = 0;
        while (i < this.ways) {
            int j;
            if (i == select && this.busSize == 1) {
                ((Pin)this.outputs.get("out" + (i + 1))).setValue(value[0]);
            } else if (i != select && this.busSize == 1) {
                ((Pin)this.outputs.get("out" + (i + 1))).setValue(false);
            } else if (i == select && this.busSize > 1) {
                j = 0;
                while (j < this.busSize) {
                    ((Pin)this.outputs.get("out" + (i + 1) + "\u00a7" + (j + 1))).setValue(value[j]);
                    ++j;
                }
            } else if (i != select && this.busSize > 1) {
                j = 0;
                while (j < this.busSize) {
                    ((Pin)this.outputs.get("out" + (i + 1) + "\u00a7" + (j + 1))).setValue(false);
                    ++j;
                }
            }
            ++i;
        }
    }

    private int transformSelect() {
        int ret = -1;
        if (this.ways == 2) {
            ret = ((Pin)this.inputs.get("sel")).getValue() ? 1 : 0;
        } else if (this.ways == 4) {
            ret = ((Pin)this.inputs.get("sel\u00a71")).getValue() ? 1 : 0;
            ret += ((Pin)this.inputs.get("sel\u00a72")).getValue() ? 2 : 0;
        } else if (this.ways == 8) {
            ret = ((Pin)this.inputs.get("sel\u00a71")).getValue() ? 1 : 0;
            ret += ((Pin)this.inputs.get("sel\u00a72")).getValue() ? 2 : 0;
            ret += ((Pin)this.inputs.get("sel\u00a73")).getValue() ? 4 : 0;
        }
        return ret;
    }

    private boolean[] transformInput() {
        boolean[] value = new boolean[this.busSize];
        if (this.busSize == 1) {
            value[0] = ((Pin)this.inputs.get("in")).getValue();
        } else {
            int i = 0;
            while (i < this.busSize) {
                value[i] = ((Pin)this.inputs.get("in\u00a7" + (i + 1))).getValue();
                ++i;
            }
        }
        return value;
    }
}

