/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import controller.data.DesignRepo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.Design;
import simulator.HardwareDesign;
import simulator.Parser;
import simulator.Pin;
import simulator.devices.Adder;
import simulator.devices.Alu;
import simulator.devices.And;
import simulator.devices.Counter;
import simulator.devices.CustomDevice;
import simulator.devices.Demux;
import simulator.devices.Dff;
import simulator.devices.FullAdder;
import simulator.devices.HalfAdder;
import simulator.devices.Mux;
import simulator.devices.Nand;
import simulator.devices.Not;
import simulator.devices.Or;
import simulator.devices.Ram;
import simulator.devices.Register;
import simulator.devices.Xor;

public abstract class Device {
    private static Pattern busPattern = Pattern.compile(".*[a-zA-Z]([0-9]+)B.*");
    private static Pattern wayPattern = Pattern.compile(".*[a-zA-Z]([0-9]+)W.*");
    public String name;
    public Map<String, Pin> inputs = new HashMap<String, Pin>();
    public Map<String, Pin> outputs = new HashMap<String, Pin>();

    protected String getInputBus(String string) {
        int i = 1;
        boolean cont = true;
        StringBuilder value = new StringBuilder();
        block0: while (cont) {
            cont = false;
            for (Map.Entry<String, Pin> e : this.inputs.entrySet()) {
                if (!e.getKey().equals(String.valueOf(string) + "\u00a7" + i)) continue;
                value.append(e.getValue().getValue() ? "1" : "0");
                cont = true;
                ++i;
                continue block0;
            }
        }
        return value.reverse().toString();
    }

    public static Device getDevice(String id, String deviceType) {
        boolean alreadyInDesignRepo;
        boolean bl = alreadyInDesignRepo = DesignRepo.designMap.containsKey(deviceType) && DesignRepo.designMap.get((Object)deviceType).completed;
        if (Arrays.asList("NAND", "NAND4B", "NAND8B", "NAND16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Nand(id, Device.getBusSize(deviceType));
        }
        if (Arrays.asList("NOT", "NOT4B", "NOT8B", "NOT16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Not(id, Device.getBusSize(deviceType));
        }
        if (Arrays.asList("AND", "AND4B", "AND8B", "AND16B").contains(deviceType) && alreadyInDesignRepo) {
            return new And(id, Device.getBusSize(deviceType));
        }
        if (Arrays.asList("OR", "OR4B", "OR8B", "OR16B", "OR", "OR4W", "OR8W", "OR16W").contains(deviceType) && alreadyInDesignRepo) {
            return new Or(id, Device.getWay(deviceType), Device.getBusSize(deviceType));
        }
        if (Arrays.asList("XOR", "XOR4B", "XOR8B", "XOR16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Xor(id, Device.getBusSize(deviceType));
        }
        if (Arrays.asList("MUX", "MUX4B", "MUX8B", "MUX16B", "MUX4W", "MUX4W4B", "MUX4W8B", "MUX4W16B", "MUX8W", "MUX8W4B", "MUX8W8B", "MUX8W16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Mux(id, Device.getWay(deviceType), Device.getBusSize(deviceType));
        }
        if (Arrays.asList("DEMUX", "DEMUX4B", "DEMUX8B", "DEMUX16B", "DEMUX4W", "DEMUX4W4B", "DEMUX4W8B", "DEMUX4W16B", "DEMUX8W", "DEMUX8W4B", "DEMUX8W8B", "DEMUX8W16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Demux(id, Device.getWay(deviceType), Device.getBusSize(deviceType));
        }
        if (deviceType.equals("DFF") && alreadyInDesignRepo) {
            return new Dff(id);
        }
        if (deviceType.equals("HALFADDER") && alreadyInDesignRepo) {
            return new HalfAdder(id);
        }
        if (deviceType.equals("FULLADDER") && alreadyInDesignRepo) {
            return new FullAdder(id);
        }
        if (Arrays.asList("ADDER4B", "ADDER8B", "ADDER16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Adder(id, Device.getBusSize(deviceType));
        }
        if (Arrays.asList("ALU4B", "ALU8B", "ALU16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Alu(id, Device.getBusSize(deviceType));
        }
        if (Arrays.asList("REGISTER", "REGISTER4B", "REGISTER8B", "REGISTER16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Register(id, Device.getBusSize(deviceType));
        }
        if (Arrays.asList("RAM4W8B", "RAM4W16B", "RAM8W8B", "RAM8W16B", "RAM16W8B", "RAM16W16B", "RAM256W8B", "RAM256W16B", "RAM16KW8B", "RAM16KW16B", "RAM32KW8B", "RAM32KW16B", "RAM64KW8B", "RAM64KW16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Ram(id, Device.getWay(deviceType), Device.getBusSize(deviceType));
        }
        if (Arrays.asList("COUNTER", "COUNTER4B", "COUNTER8B", "COUNTER16B").contains(deviceType) && alreadyInDesignRepo) {
            return new Counter(id, Device.getBusSize(deviceType));
        }
        Design d = DesignRepo.designMap.get(deviceType);
        if (d == null || !d.completed) {
            return null;
        }
        String code = d.code;
        HardwareDesign hwd = Parser.parse(code);
        return new CustomDevice(id, hwd);
    }

    private static int getBusSize(String deviceType) {
        Matcher matcher = busPattern.matcher(deviceType);
        if (matcher.find()) {
            return new Integer(matcher.group(1));
        }
        return 1;
    }

    private static int getWay(String deviceType) {
        Matcher matcher = wayPattern.matcher(deviceType);
        if (matcher.find()) {
            return new Integer(matcher.group(1));
        }
        if (Arrays.asList("RAM64KW8B", "RAM64KW16B").contains(deviceType)) {
            return (int)Math.pow(2.0, 16.0);
        }
        if (Arrays.asList("RAM32KW8B", "RAM32KW16B").contains(deviceType)) {
            return (int)Math.pow(2.0, 15.0);
        }
        if (Arrays.asList("RAM16KW8B", "RAM16KW16B").contains(deviceType)) {
            return (int)Math.pow(2.0, 14.0);
        }
        return 2;
    }

    public Pin getOutput(String pinId) {
        return this.outputs.get(pinId);
    }

    public Pin getInput(String pinId) {
        return this.inputs.get(pinId);
    }

    public void postStep() {
    }

    public abstract void step();

    public void preStep() {
    }

    public boolean isSequential() {
        return false;
    }

    public void reset() {
        for (Pin p : this.inputs.values()) {
            p.reset();
        }
        for (Pin p : this.outputs.values()) {
            p.reset();
        }
    }
}

