/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import simulator.Pin;
import simulator.devices.Device;

public class Mux
extends Device {
    int busSize = 1;
    int ways = 2;

    public Mux(String name, int ways, int busSize) {
        this.busSize = busSize;
        this.name = name;
        this.ways = ways;
        if (busSize == 1) {
            this.outputs.put("out", new Pin("out"));
            int j = 1;
            while (j <= ways) {
                this.inputs.put("in" + j, new Pin("in" + j));
                ++j;
            }
        } else {
            int i = 1;
            while (i <= busSize) {
                this.outputs.put("out\u00a7" + i, new Pin("out\u00a7" + i));
                int j = 1;
                while (j <= ways) {
                    this.inputs.put("in" + j + "\u00a7" + i, new Pin("in" + j + "\u00a7" + i));
                    ++j;
                }
                ++i;
            }
        }
        if (ways == 2) {
            this.inputs.put("sel", new Pin("sel"));
        } else if (ways == 4) {
            this.inputs.put("sel\u00a71", new Pin("sel\u00a71"));
            this.inputs.put("sel\u00a72", new Pin("sel\u00a72"));
        } else if (ways == 8) {
            this.inputs.put("sel\u00a71", new Pin("sel\u00a71"));
            this.inputs.put("sel\u00a72", new Pin("sel\u00a72"));
            this.inputs.put("sel\u00a73", new Pin("sel\u00a73"));
        }
    }

    @Override
    public void step() {
        boolean[][] inArray = this.transformInputs();
        int select = this.transformSelect();
        this.transformOutput(inArray[select]);
    }

    private void transformOutput(boolean[] bs) {
        if (bs.length == 1) {
            ((Pin)this.outputs.get("out")).setValue(bs[0]);
        } else {
            int i = 0;
            while (i < this.busSize) {
                ((Pin)this.outputs.get("out\u00a7" + (i + 1))).setValue(bs[i]);
                ++i;
            }
        }
    }

    private int transformSelect() {
        int ret = -1;
        if (this.ways == 2) {
            ret = ((Pin)this.inputs.get("sel")).getValue() ? 1 : 0;
        } else if (this.ways == 4) {
            ret = ((Pin)this.inputs.get("sel\u00a71")).getValue() ? 1 : 0;
            ret += ((Pin)this.inputs.get("sel\u00a72")).getValue() ? 2 : 0;
        } else if (this.ways == 8) {
            ret = ((Pin)this.inputs.get("sel\u00a71")).getValue() ? 1 : 0;
            ret += ((Pin)this.inputs.get("sel\u00a72")).getValue() ? 2 : 0;
            ret += ((Pin)this.inputs.get("sel\u00a73")).getValue() ? 4 : 0;
        }
        return ret;
    }

    private boolean[][] transformInputs() {
        boolean[][] array = new boolean[this.ways][this.busSize];
        int i = 0;
        while (i < this.ways) {
            int j = 0;
            while (j < this.busSize) {
                array[i][j] = this.busSize == 1 ? ((Pin)this.inputs.get("in" + (i + 1))).getValue() : ((Pin)this.inputs.get("in" + (i + 1) + "\u00a7" + (j + 1))).getValue();
                ++j;
            }
            ++i;
        }
        return array;
    }
}

