/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import simulator.Pin;
import simulator.devices.Device;

public class Or
extends Device {
    private int busSize;
    private int way;

    public Or(String name, int way, int busSize) {
        this.busSize = busSize;
        this.way = way;
        this.name = name;
        if (busSize == 1) {
            this.outputs.put("out", new Pin("out"));
            if (way != 2) {
                int i = 1;
                while (i <= way) {
                    this.inputs.put("in\u00a7" + i, new Pin("in\u00a7" + i));
                    ++i;
                }
            } else {
                this.inputs.put("in1", new Pin("in1"));
                this.inputs.put("in2", new Pin("in2"));
            }
        } else {
            int i = 1;
            while (i <= busSize) {
                this.inputs.put("in1\u00a7" + i, new Pin("in1\u00a7" + i));
                this.inputs.put("in2\u00a7" + i, new Pin("in2\u00a7" + i));
                this.outputs.put("out\u00a7" + i, new Pin("out\u00a7" + i));
                ++i;
            }
        }
    }

    @Override
    public void step() {
        if (this.busSize == 1) {
            boolean out = false;
            if (this.way != 2) {
                int i = 1;
                while (i <= this.way) {
                    out |= ((Pin)this.inputs.get("in\u00a7" + i)).getValue();
                    ++i;
                }
            } else {
                out |= ((Pin)this.inputs.get("in1")).getValue();
                out |= ((Pin)this.inputs.get("in2")).getValue();
            }
            ((Pin)this.outputs.get("out")).setValue(out);
        } else {
            int i = 1;
            while (i <= this.busSize) {
                boolean out = false;
                out |= ((Pin)this.inputs.get("in1\u00a7" + i)).getValue();
                ((Pin)this.outputs.get("out\u00a7" + i)).setValue(out |= ((Pin)this.inputs.get("in2\u00a7" + i)).getValue());
                ++i;
            }
        }
    }
}

