/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import simulator.Pin;
import simulator.devices.Device;

public class Ram
extends Device {
    int busSize = 1;
    int selectSize = 1;
    int ways = 2;
    int[] ram;

    public Ram(String name, int ways, int busSize) {
        this.busSize = busSize;
        this.name = name;
        this.ways = ways;
        if (busSize == 4) {
            this.selectSize = 2;
        } else if (busSize == 8) {
            this.selectSize = 3;
        } else if (busSize == 16) {
            this.selectSize = 4;
        } else if (busSize == 256) {
            this.selectSize = 8;
        } else if ((double)busSize == Math.pow(2.0, 14.0)) {
            this.selectSize = 14;
        } else if ((double)busSize == Math.pow(2.0, 15.0)) {
            this.selectSize = 15;
        } else if ((double)busSize == Math.pow(2.0, 16.0)) {
            this.selectSize = 16;
        }
        this.ram = new int[(int)Math.pow(2.0, this.selectSize)];
        this.inputs.put("load", new Pin("load"));
        int i = 1;
        while (i <= busSize) {
            this.outputs.put("out\u00a7" + i, new Pin("out\u00a7" + i));
            this.inputs.put("in\u00a7" + i, new Pin("in\u00a7" + i));
            ++i;
        }
        i = 1;
        while (i <= this.selectSize) {
            this.inputs.put("address\u00a7" + i, new Pin("address\u00a7" + i));
            ++i;
        }
    }

    @Override
    public void step() {
        this.transformOutput(this.ram[this.transformSelect()]);
    }

    @Override
    public void postStep() {
        if (((Pin)this.inputs.get("load")).getValue()) {
            this.ram[this.transformSelect()] = this.transformInput();
        }
    }

    @Override
    public void preStep() {
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.ram = new int[(int)Math.pow(2.0, this.selectSize)];
    }

    private void transformOutput(int value) {
        int i = 1;
        while (i <= this.busSize) {
            ((Pin)this.outputs.get("out\u00a7" + i)).setValue((value & 1) == 1);
            value >>= 1;
            ++i;
        }
    }

    private int transformSelect() {
        int select = 0;
        int i = 1;
        while (i <= this.selectSize) {
            if (((Pin)this.inputs.get("address\u00a7" + i)).getValue()) {
                select |= 1;
            }
            select <<= 1;
            ++i;
        }
        return select;
    }

    private short transformInput() {
        short val = 0;
        int i = 1;
        while (i <= this.busSize) {
            if (((Pin)this.inputs.get("in\u00a7" + i)).getValue()) {
                val = (short)(val | 1);
            }
            val = (short)(val << 1);
            ++i;
        }
        return val;
    }
}

