/*
 * Decompiled with CFR 0.152.
 */
package simulator.devices;

import simulator.Pin;
import simulator.devices.Device;

public class Register
extends Device {
    boolean internalValue = false;
    boolean[] internalValueArray;
    int busSize = 1;

    public Register(String name, int busSize) {
        this.name = name;
        this.busSize = busSize;
        this.internalValueArray = new boolean[busSize];
        this.inputs.put("load", new Pin("load"));
        if (busSize == 1) {
            this.inputs.put("in", new Pin("in"));
            this.outputs.put("out", new Pin("out"));
        } else {
            int i = 1;
            while (i <= busSize) {
                this.inputs.put("in\u00a7" + i, new Pin("in\u00a7" + i));
                this.outputs.put("out\u00a7" + i, new Pin("out\u00a7" + i));
                ++i;
            }
        }
    }

    @Override
    public void step() {
        if (this.busSize == 1) {
            ((Pin)this.outputs.get("out")).setValue(this.internalValue);
        } else {
            int i = 0;
            while (i < this.busSize) {
                ((Pin)this.outputs.get("out\u00a7" + (i + 1))).setValue(this.internalValueArray[i]);
                ++i;
            }
        }
    }

    @Override
    public void postStep() {
        if (((Pin)this.inputs.get("load")).getValue()) {
            if (this.busSize == 1) {
                this.internalValue = ((Pin)this.inputs.get("in")).getValue();
            } else {
                int i = 0;
                while (i < this.busSize) {
                    this.internalValueArray[i] = ((Pin)this.inputs.get("in\u00a7" + (i + 1))).getValue();
                    ++i;
                }
            }
        }
    }

    @Override
    public void preStep() {
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.internalValue = false;
        if (this.busSize > 1) {
            int i = 0;
            while (i < this.busSize) {
                this.internalValueArray[i] = false;
                ++i;
            }
        }
    }
}

