/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamLeaderboardEntriesHandle;
import com.codedisaster.steamworks.SteamLeaderboardHandle;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUserStats;
import com.codedisaster.steamworks.SteamUserStatsCallback;

public enum AchievementUtil {
    FIRST_DESIGN,
    BASIC_LOGIC,
    ADVANCED_LOGIC,
    TED,
    ALU,
    CPU,
    MEMORY;

    private static SteamUserStats userStats;

    static {
        userStats = null;
    }

    public static void complete(AchievementUtil a) {
        if (!SteamAPI.isSteamRunning()) {
            return;
        }
        AchievementUtil.init();
        userStats.setAchievement(a.toString());
        userStats.storeStats();
    }

    public static void clear(AchievementUtil a) {
        if (!SteamAPI.isSteamRunning()) {
            return;
        }
        AchievementUtil.init();
        userStats.clearAchievement(a.toString());
        userStats.storeStats();
    }

    public static synchronized void init() {
        if (userStats == null) {
            userStats = new SteamUserStats(new SteamUserStatsCallback(){

                @Override
                public void onUserStatsUnloaded(SteamID steamIDUser) {
                }

                @Override
                public void onUserStatsStored(long gameId, SteamResult result) {
                }

                @Override
                public void onUserStatsReceived(long gameId, SteamID steamIDUser, SteamResult result) {
                }

                @Override
                public void onUserAchievementStored(long gameId, boolean isGroupAchievement, String achievementName, int curProgress, int maxProgress) {
                }

                @Override
                public void onLeaderboardScoresDownloaded(SteamLeaderboardHandle leaderboard, SteamLeaderboardEntriesHandle entries, int numEntries) {
                }

                @Override
                public void onLeaderboardScoreUploaded(boolean success, SteamLeaderboardHandle leaderboard, int score, boolean scoreChanged, int globalRankNew, int globalRankPrevious) {
                }

                @Override
                public void onLeaderboardFindResult(SteamLeaderboardHandle leaderboard, boolean found) {
                }

                @Override
                public void onGlobalStatsReceived(long gameId, SteamResult result) {
                }
            });
            userStats.requestCurrentStats();
        }
    }
}

