/*
 * Decompiled with CFR 0.152.
 */
package utils;

import engine.GraphicsSystem;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Scanner;
import javax.imageio.ImageIO;
import model.Design;
import utils.Logger;

public class Resources {
    public static String defaultUserHome = String.valueOf(System.getProperty("user.home")) + "/MHDE/";

    public static String getText(String path) {
        String s = null;
        try {
            s = new Scanner(Resources.class.getClassLoader().getResourceAsStream(path)).useDelimiter("\\A").next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s != null) {
            s = s.replaceAll("\r", "");
        }
        return s;
    }

    public static Font getFont(String fontName) {
        Font f = null;
        try {
            String fontPath = String.valueOf(Resources.getUserHome()) + "font";
            File ff = new File(fontPath);
            if (!ff.exists()) {
                new File(Resources.getUserHome()).mkdirs();
                Files.copy(Resources.class.getClassLoader().getResourceAsStream(String.valueOf(fontName) + ".ttf"), ff.toPath(), new CopyOption[0]);
            }
            f = Font.createFont(0, new File(fontPath));
        }
        catch (Exception e) {
            Logger.log(e);
            f = GraphicsSystem.fontBackup;
        }
        return f;
    }

    public static String getUserHome() {
        return "userdata/";
    }

    public static Design getDesign(String designName) {
        Design d = new Design();
        d.name = designName;
        d.briefing = Resources.getText(String.valueOf(designName.toLowerCase()) + "/briefing");
        d.spec = Resources.getText(String.valueOf(designName.toLowerCase()) + "/specification");
        d.iface = Resources.getText(String.valueOf(designName.toLowerCase()) + "/iface");
        d.tests = Resources.getText(String.valueOf(designName.toLowerCase()) + "/tests");
        d.code = Resources.getText(String.valueOf(designName.toLowerCase()) + "/design");
        return d;
    }

    public static InputStream getAudio(String name) {
        return new BufferedInputStream(Resources.class.getClassLoader().getResourceAsStream(String.valueOf(name) + ".wav"));
    }

    public static Image getIcon() {
        BufferedImage i = null;
        try {
            String iconPath = String.valueOf(Resources.getUserHome()) + "icon";
            File fi = new File(iconPath);
            if (!fi.exists()) {
                new File(Resources.getUserHome()).mkdirs();
                Files.copy(Resources.class.getClassLoader().getResourceAsStream("icon.bmp"), fi.toPath(), new CopyOption[0]);
            }
            i = ImageIO.read(new File(iconPath));
        }
        catch (Exception e) {
            Logger.log(e);
            try {
                i = ImageIO.read(Resources.class.getClassLoader().getResource("icon.bmp"));
            }
            catch (IOException e1) {
                Logger.log(e1);
            }
        }
        return i;
    }

    public static PrintStream getGameLog() throws FileNotFoundException {
        return Resources.getLog("game");
    }

    public static PrintStream getErrorLog() throws FileNotFoundException {
        return Resources.getLog("error");
    }

    private static PrintStream getLog(String logName) throws FileNotFoundException {
        String logPath = String.valueOf(Resources.getUserHome()) + "game.log";
        if (!new File(logPath).exists()) {
            new File(Resources.getUserHome()).mkdirs();
        }
        return new PrintStream(new FileOutputStream(String.valueOf(Resources.getUserHome()) + logName + ".log", true));
    }
}

