/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamFriends;
import com.codedisaster.steamworks.SteamFriendsCallback;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamLeaderboardEntriesHandle;
import com.codedisaster.steamworks.SteamLeaderboardEntry;
import com.codedisaster.steamworks.SteamLeaderboardHandle;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUserStats;
import com.codedisaster.steamworks.SteamUserStatsCallback;
import controller.data.DesignRepo;
import java.util.HashMap;
import java.util.Map;

public class ScoreUtil {
    public static boolean updateAvailable = false;
    static Map<String, LeaderBoard> friendLeaderBoard = new HashMap<String, LeaderBoard>();
    static Map<String, LeaderBoard> globalLeaderBoard = new HashMap<String, LeaderBoard>();
    private static SteamFriends steamFriends = null;

    private static void init() {
        if (!SteamAPI.isSteamRunning()) {
            return;
        }
        if (steamFriends != null) {
            return;
        }
        steamFriends = new SteamFriends(new SteamFriendsCallback(){

            @Override
            public void onPersonaStateChange(SteamID steamID, SteamFriends.PersonaChange change) {
                if (change == SteamFriends.PersonaChange.Name) {
                    updateAvailable = true;
                }
            }

            @Override
            public void onGameOverlayActivated(boolean active) {
            }

            @Override
            public void onGameLobbyJoinRequested(SteamID steamIDLobby, SteamID steamIDFriend) {
            }

            @Override
            public void onAvatarImageLoaded(SteamID steamID, int image, int width, int height) {
            }
        });
    }

    public static void updateAllScores() {
        ScoreUtil.init();
        for (String s : DesignRepo.statsMap.keySet()) {
            ScoreUtil.updateScores(s);
        }
    }

    public static void updateScores(String deviceType) {
        ScoreUtil.init();
        if (!SteamAPI.isSteamRunning()) {
            return;
        }
        if (!friendLeaderBoard.containsKey(deviceType)) {
            friendLeaderBoard.put(deviceType, new LeaderBoard(true, deviceType));
        }
        friendLeaderBoard.get(deviceType).download();
        if (!globalLeaderBoard.containsKey(deviceType)) {
            globalLeaderBoard.put(deviceType, new LeaderBoard(false, deviceType));
        }
        globalLeaderBoard.get(deviceType).download();
    }

    public static void uploadScore(final String deviceType, final int score) {
        if (score <= 0) {
            return;
        }
        ScoreUtil.init();
        if (!SteamAPI.isSteamRunning()) {
            return;
        }
        if (!friendLeaderBoard.containsKey(deviceType)) {
            ScoreUtil.updateScores(deviceType);
        }
        if (friendLeaderBoard.get(deviceType) == null || friendLeaderBoard.get(deviceType).lbHandle == null) {
            new Thread(){

                @Override
                public void run() {
                    int s = score;
                    super.run();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    friendLeaderBoard.get(deviceType).upload(s);
                }
            }.start();
        } else {
            friendLeaderBoard.get(deviceType).upload(score);
        }
    }

    public static Score getScore(String deviceType, boolean friend) {
        if (!SteamAPI.isSteamRunning()) {
            return new Score();
        }
        if (!friendLeaderBoard.containsKey(deviceType)) {
            ScoreUtil.updateScores(deviceType);
        }
        if (friend) {
            return ScoreUtil.friendLeaderBoard.get((Object)deviceType).score;
        }
        return ScoreUtil.globalLeaderBoard.get((Object)deviceType).score;
    }

    private static class LeaderBoard
    implements SteamUserStatsCallback {
        String name;
        private SteamUserStats userStats;
        private SteamLeaderboardHandle lbHandle;
        boolean friendLB;
        Score score = new Score();

        public LeaderBoard(boolean b, String deviceType) {
            this.name = deviceType;
            this.userStats = new SteamUserStats(this);
            this.userStats.findLeaderboard(String.valueOf(deviceType.toLowerCase()) + "_leaderboard");
            this.friendLB = b;
        }

        @Override
        public void onUserStatsReceived(long gameId, SteamID steamIDUser, SteamResult result) {
        }

        @Override
        public void onUserStatsStored(long gameId, SteamResult result) {
        }

        @Override
        public void onUserStatsUnloaded(SteamID steamIDUser) {
        }

        @Override
        public void onUserAchievementStored(long gameId, boolean isGroupAchievement, String achievementName, int curProgress, int maxProgress) {
        }

        @Override
        public void onGlobalStatsReceived(long gameId, SteamResult result) {
        }

        @Override
        public void onLeaderboardFindResult(SteamLeaderboardHandle leaderboard, boolean found) {
            this.lbHandle = leaderboard;
        }

        @Override
        public void onLeaderboardScoresDownloaded(SteamLeaderboardHandle leaderboard, SteamLeaderboardEntriesHandle entries, int numEntries) {
            SteamLeaderboardEntry entry = new SteamLeaderboardEntry();
            this.userStats.getDownloadedLeaderboardEntry(entries, 0, entry, null);
            this.score.score = entry.getScore();
            this.score.steamId = entry.getSteamIDUser();
            if (!this.friendLB) {
                steamFriends.requestUserInformation(this.score.steamId, true);
            }
            if (numEntries > 1) {
                this.userStats.getDownloadedLeaderboardEntry(entries, 1, entry, null);
                if (entry.getScore() == this.score.score) {
                    this.score.steamId = null;
                }
            }
            updateAvailable = true;
        }

        @Override
        public void onLeaderboardScoreUploaded(boolean success, SteamLeaderboardHandle leaderboard, int score, boolean scoreChanged, int globalRankNew, int globalRankPrevious) {
        }

        public void download() {
            if (this.lbHandle == null) {
                return;
            }
            if (!this.friendLB) {
                this.userStats.downloadLeaderboardEntries(this.lbHandle, SteamUserStats.LeaderboardDataRequest.Global, 0, 2);
            } else {
                this.userStats.downloadLeaderboardEntries(this.lbHandle, SteamUserStats.LeaderboardDataRequest.Friends, 0, 2);
            }
        }

        public void upload(int score) {
            if (this.lbHandle == null) {
                return;
            }
            this.userStats.uploadLeaderboardScore(this.lbHandle, SteamUserStats.LeaderboardUploadScoreMethod.ForceUpdate, score, null);
        }
    }

    public static class Score {
        private int score;
        private SteamID steamId;

        public String getName() {
            if (this.steamId == null || this.score == Integer.MAX_VALUE) {
                return "";
            }
            return steamFriends.getFriendPersonaName(this.steamId);
        }

        public String getScore() {
            if (this.score == 0 || this.score == Integer.MAX_VALUE) {
                return "-";
            }
            return "" + this.score;
        }
    }
}

