/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import simulator.Test;
import utils.Logger;

public class TestCache {
    private static Map<String, List<Test>> testCache = new HashMap<String, List<Test>>();

    static {
        try {
            ObjectInputStream ois = new ObjectInputStream(TestCache.class.getClassLoader().getResourceAsStream("testcache"));
            testCache = (Map)ois.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean contains(String design) {
        if (design != null) {
            return testCache.containsKey(design);
        }
        return false;
    }

    public static List<Test> get(String design) {
        if (design != null) {
            return testCache.get(design);
        }
        return null;
    }

    public static void put(String design, List<Test> tests) {
        if (design != null) {
            testCache.put(design, tests);
        }
    }

    public static void persistCache() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("testcache"));
            oos.writeObject(testCache);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }
}

